using System;

namespace Server.Items
{
	public class MagicWallToolKit : BaseCharm
	{
		public override Type GetRechargeType() { return typeof( Switch ); }
      
      [Constructable]
		public MagicWallToolKit() : base( 7866 )
		{
			Weight = 5.0;
			Hue = 2633;
			Name = "magic wall tool kit";
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#9999FF>If tool kit is hold in backpack\nStone wall spell create log wall\nwith increased duration and length\n<basefont color=White>Skill requirements:\nCarpentry 100, Lumberjacking 100" );
		}

		public MagicWallToolKit( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}