/* Created by Hammerhand*/

using System;
using System.Collections;
using Server.Items;
using Server.ContextMenus;
using Server.Misc;
using Server.Network;

namespace Server.Mobiles
{
	public class Graverobber : BaseCreature
	{
		public override bool ClickTitle { get { return false; } }

		private DateTime m_NextSpeechTime = DateTime.Now;

		public static string[] GraverobberSay { get { return new string[]
				{

					"Ja jsem tu byl prvni!",
					"Priprav se na smrt, ten artefakt bude muj!",
					"Zmiz odtud, tady hledam ja!"
				}; } }

		public override WeaponAbility GetWeaponAbility()
		{
			switch (Utility.Random(3))
			{
				default:
					case 0: return WeaponAbility.DoubleStrike;
				case 1: return WeaponAbility.WhirlwindAttack;
				case 2: return WeaponAbility.CrushingBlow;
			}
		}

		[Constructable]
		public Graverobber() : base(AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4)
		{
			Title = "the Graverobber";
			Hue = Utility.RandomSkinHue();
			SpeechHue = Utility.RandomDyedHue();
			if (this.Female = Utility.RandomBool())
			{
				this.Body = 0x191;
				this.Name = NameList.RandomName("female");
			}
			else
			{
				this.Body = 0x190;
				this.Name = NameList.RandomName("male");
			}

			SetStr(586, 700);
			SetDex(281, 295);
			SetInt(361, 375);

			SetHits(958, 1711);

			SetDamage(25, 34);

			SetResistance(ResistanceType.Physical, 50, 60);
			SetResistance(ResistanceType.Fire, 50, 70);
			SetResistance(ResistanceType.Cold, 60, 65);
			SetResistance(ResistanceType.Poison, 55, 60);
			SetResistance(ResistanceType.Energy, 50, 65);

			SetSkill(SkillName.Fencing, 96.0, 107.5);
			SetSkill(SkillName.Macing, 95.0, 107.5);
			SetSkill(SkillName.MagicResist, 75.0, 87.5);
			SetSkill(SkillName.Swords, 105.0, 112.5);
			SetSkill(SkillName.Tactics, 100.0, 107.5);
			SetSkill(SkillName.Wrestling, 85.0, 97.5);
			SetSkill(SkillName.Anatomy, 100.0, 110.0);
			SetSkill(SkillName.Parry, 60.0, 90.0);

			Fame = 8000;
			Karma = -10000;

			VirtualArmor = 50;

			BaseArmor chest = new LeatherChest();
			chest.Hue = SpeechHue;
			chest.Movable = (Utility.RandomDouble() < 0.1) ? true : false;
			AddItem(chest);

			BaseArmor legs = new LeatherLegs();
			legs.Hue = SpeechHue;
			legs.Movable = (Utility.RandomDouble() < 0.1) ? true : false;
			AddItem(legs);

			if (Utility.RandomDouble() < 0.4)
				AddItem(new Cloak(Utility.RandomNeutralHue()));

			AddItem(new Boots());

			switch (Utility.Random(7))
			{
				case 0: AddItem(new Longsword()); break;
				case 1: AddItem(new Cutlass()); break;
				case 2: AddItem(new Broadsword()); break;
				case 3: AddItem(new Axe()); break;
				case 4: AddItem(new Club()); break;
				case 5: AddItem(new Dagger()); break;
				case 6: AddItem(new Spear()); break;
			}

			Utility.AssignRandomHair(this);

			PackItem(new Bandage(Utility.RandomMinMax(2, 6)));
		}

		public override void GenerateLoot()
		{
			AddLoot(LootPack.FilthyRich);
		}

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			base.OnDamage(amount, from, willKill, typ);

			if (from == null)
				return;

			if(Utility.RandomDouble() < 0.05)
			{
				if(!KhalAnkur.IsUnderInfluence(from))
				{
					KhalAnkur.Silence(from, this);
				}
			}

			if(Utility.RandomDouble() < 0.05)
			{
				Location = TavaraSewel.GetSpawnPosition(from.Location, from.Map, 1);
				FixedParticles(0x376A, 9, 32, 0x13AF, EffectLayer.Waist);
				PlaySound(0x1FE);
			}
		}

		public override bool AlwaysMurderer { get { return true; } }
		public override bool CanRummageCorpses { get { return true; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override int TreasureMapLevel { get { return 4; } }

		public Graverobber(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0); // version
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
		}
	}
}