using System;
using Server;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
	public class ArcheryButteLog
	{
		private static Dictionary<Mobile, int> m_ScoreLog;

		public static void Record( int score, Mobile archer )
		{
			if ( m_ScoreLog == null )
            m_ScoreLog = new Dictionary<Mobile, int>();
            
         m_ScoreLog[ archer ] = score;
		}
		
		public static ArrayList GetSortedData()
		{
			if ( m_ScoreLog == null )
			   return null;
			   
		   ArrayList SortedLog = new ArrayList();
         
         foreach (KeyValuePair<Mobile, int> db in m_ScoreLog)
         {
            SortedLog.Add( new KeyValuePair<Mobile, int>( db.Key, db.Value ) );
         }
         
         SortedLog.Sort( new ListAmountSorter() );
     	
         return SortedLog;
		}
		
		private class ListAmountSorter : IComparer
		{
			public ListAmountSorter() : base()
			{
			}

			public int Compare(object a, object b)
			{
				if ( a == null || b == null || a == b || !( a is KeyValuePair<Mobile, int> ) || !( b is KeyValuePair<Mobile, int> ) )
               return 0;
               
            KeyValuePair<Mobile, int> x = ( KeyValuePair<Mobile, int> ) a;
            KeyValuePair<Mobile, int> y = ( KeyValuePair<Mobile, int> ) b;
               
				if ( x.Key == y.Key && x.Key != null && y.Key != null )
				{
					return ((Mobile)x.Key).RawName.CompareTo( ((Mobile)y.Key).RawName );
				}
				return ( ( x.Value > y.Value ) ? -1 : 1 );
			}
		}
		
		public static void Reset()
		{
			m_ScoreLog.Clear();
		}
		
		public static void Configure()
		{
			EventSink.WorldLoad += new WorldLoadEventHandler( EventSink_WorldLoad );
// 			EventSink.WorldSave += new WorldSaveEventHandler( OnSave );
		}
		
		private static void EventSink_WorldLoad()
		{
			m_ScoreLog = new Dictionary<Mobile, int>();
		}

		public ArcheryButteLog()
		{
		}
	}
}