using System;
using Server;
using Server.Mobiles;
using Server.Gumps;
using Server.Network;
using Server.Prompts;
using Server.Targeting;
using System.Collections;
using Server.Engines.XmlSpawner2;

namespace Server.Items
{
	[Flipable( 3025, 3026, 3023, 3024 )]
   public class Auction : Item
	{
		public enum Currency
		{
         Gold,
         Tokens,
         CechovniMince,
         MesicniKamen
      }
      
		public static string[] CurrencyName { get { return new string[]
		{
			"Zlatych",
			"Stribrnych",
			"Cechovnich minci",
			"Mesicnich kamenu"
		}; } }
      
      private int m_StartBid = 0;
      private int m_HighestBid = 0;
      private Mobile m_Owner;
      private Mobile m_HighestBidder;
      private Item m_AuctionedItem;
		private DateTime m_AuctionEnd = DateTime.MinValue;
		private int m_Duration = 24;
		private Currency m_Currency = Currency.Gold;
      private Point3D m_ItemLoc;
		
		[CommandProperty(AccessLevel.GameMaster)]
		public int HighestBid { get { return m_HighestBid; } set { m_HighestBid = value; InvalidateProperties(); } }
		
		[CommandProperty(AccessLevel.GameMaster)]
		public int StartBid { get { return m_StartBid; } set { m_StartBid = Math.Max( value, 10 ); InvalidateProperties(); } }
		
		[CommandProperty(AccessLevel.GameMaster)]
		public Mobile Owner { get { return m_Owner; } set { m_Owner = value; InvalidateProperties(); } }

		[CommandProperty(AccessLevel.GameMaster)]
		public Mobile HighestBidder { get { return m_HighestBidder; } set { m_HighestBidder = value; InvalidateProperties(); } }
		
		[CommandProperty(AccessLevel.GameMaster)]
		public Item AuctionedItem {
         get { return m_AuctionedItem; }
         set
         {
            m_AuctionedItem = value;
            m_AuctionedItem.Movable = false;
            m_AuctionedItem.MoveToWorld( m_ItemLoc, this.Map );
            m_AuctionEnd = DateTime.Now + TimeSpan.FromHours( m_Duration );
            this.Visible = true;
            this.Hue = 2630;          
            InvalidateProperties();
         }
      }
		
		[CommandProperty(AccessLevel.GameMaster)]
		public DateTime AuctionEnd { get { return m_AuctionEnd; } set { m_AuctionEnd = value; InvalidateProperties(); } }
		
		[CommandProperty(AccessLevel.GameMaster)]
		public int Duration { get { return m_Duration; } set { m_Duration = Math.Max( value, 1 ); InvalidateProperties(); } }
		
		[CommandProperty(AccessLevel.GameMaster)]
		public Currency AuctionCurrency { get { return m_Currency; } set { m_Currency = value; InvalidateProperties(); } }
		
      [CommandProperty( AccessLevel.GameMaster )]
      public Point3D ItemLoc { get { return m_ItemLoc;} set { m_ItemLoc = value;} }
		
		[Constructable]
      public Auction() : base( 3025 )
		{
			Name = "Volna Aukcni Cedule";
			Movable = false;
			Hue = 268;
			m_StartBid = 10;
		}
		
		public Auction(Serial serial) : base(serial)
		{
		}
		
		public override void OnDoubleClick( Mobile from )
		{
			if ( !from.InRange( this.GetWorldLocation(), 6 ) )
				from.SendLocalizedMessage( 502138 );
			else if ( m_AuctionedItem == null || m_Owner == null )
			{
				from.SendMessage( "Vyber predmet, ktery chces dat do aukce" );
				from.Target = new SelectItemTarget( this );
         }
			else
				from.SendGump( new AuctionGump( this ) );
		}
		
		public static void Configure()
		{
			EventSink.WorldSave += new WorldSaveEventHandler( OnSave );
		}
		
		private static void OnSave( WorldSaveEventArgs e )
		{
			ArrayList array = new ArrayList();
         
         foreach ( Item item in World.Items.Values )
  			{
  				if ( item is Auction && !item.Deleted )
  				{
               array.Add( item );
            }
  			}
  			
         foreach ( Auction ac in array )
         {
            if ( ac != null )
               ac.CheckEnd();
         }
		}
		
		private void CheckEnd()
		{
         if ( m_AuctionedItem == null || m_Owner == null )
            return;
         
         if ( DateTime.Now > m_AuctionEnd )
         {
            m_AuctionedItem.Movable = true;
            
            if ( m_HighestBid >= m_StartBid && m_HighestBidder != null ) //Prodano
            {
               if ( m_AuctionedItem.BlessedFor != null )
                  m_AuctionedItem.BlessedFor = m_HighestBidder;
               
               m_HighestBidder.BankBox.DropItem( m_AuctionedItem );
               m_HighestBidder.SendMessage(1173, "VYHRA! Predmet vyhrany v aukci {0} za {1} {2} byl umisten do tve banky.", this.Name, m_HighestBid.ToString( "N0", Auberon.Chat.General.Nfi ), CurrencyName[ (int) m_Currency ] );
               m_HighestBidder.SendSound( 0x3D );
               
               GiveCurrency( m_Owner, this, m_HighestBid );
               m_Owner.SendMessage(1173, "Aukce {0} skoncila. Predmet byl prodan za {1} {2} od {3}.", this.Name, m_HighestBid.ToString( "N0", Auberon.Chat.General.Nfi ), CurrencyName[ (int) m_Currency ], m_HighestBidder.RawName );
               m_Owner.SendSound( 0x3D );
            }
            else //neprodano
            {
               m_Owner.BankBox.DropItem( m_AuctionedItem );
               m_Owner.SendMessage(1173, "Aukce {0} skoncila. Predmet nebyl prodan.", this.Name );
               m_Owner.SendSound( 1058 );
            }
//             else
//                m_AuctionedItem.Delete();
            
//             this.Visible = false;
            this.Name = "Volna Aukcni Cedule";
            m_Owner = null;
            Hue = 268;
            m_HighestBid = 0;
            m_StartBid = 10;
            m_HighestBidder = null;
            m_AuctionedItem = null;
            m_AuctionEnd = DateTime.MinValue;
            m_Currency = Currency.Gold;
            InvalidateProperties();
         }
         else
         {
            World.Broadcast( 2125, false, String.Format( "AKTIVNI AUKCE: {0} [{1} {2}]", this.Name, ( m_HighestBid > m_StartBid ) ? m_HighestBid.ToString( "N0", Auberon.Chat.General.Nfi ) : m_StartBid.ToString( "N0", Auberon.Chat.General.Nfi ), CurrencyName[ (int) m_Currency ] ) );
         }
		}
		
		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );
			
			if ( m_AuctionedItem == null )
			{
			   list.Add( "Dvojklik pro vytvoreni aukce" );
			   return;
         }
			
			if ( m_StartBid > 0 && m_HighestBidder == null )
				list.Add( 1060658, "Vyvolavaci cena\t{0} {1}", m_StartBid.ToString( "N0", Auberon.Chat.General.Nfi ), CurrencyName[ (int) m_Currency ] );
			else if ( m_HighestBidder != null )
				list.Add( 1060658, "{0}\t{1} {2}", m_HighestBidder.RawName, m_HighestBid.ToString( "N0", Auberon.Chat.General.Nfi ), CurrencyName[ (int) m_Currency ] );
				
			if ( m_AuctionEnd != null || m_AuctionEnd != DateTime.MinValue )
				list.Add( 1060659, "Konec aukce\t{0:g}", m_AuctionEnd );
				
         if ( m_Owner != null && m_Owner.AccessLevel == AccessLevel.Player )
				list.Add( 1060660, "Majitel aukce\t{0}", m_Owner.RawName );

// 			if (m_Label4 != null)
// 				list.Add( 1060661, "{0}\t{1}", m_Label4.ToString(), String.Format("{0}/{1}", m_Key4_cur, m_Key4_max ) );
// 			if (m_Label5 != null)
// 				list.Add( 1060662, "{0}\t{1}", m_Label5.ToString(), String.Format("{0}/{1}", m_Key5_cur, m_Key5_max ) );
		}
		
		public static void GiveCurrency( Mobile to, Auction aukce, int amount )
		{
         if ( to == null || to.BankBox == null || aukce == null || amount < 1 )
            return;
         
         switch( aukce.AuctionCurrency )
         {
         	case Currency.Tokens:
         	{
               to.BankBox.DropItem( new TokenCheck( amount ) );
               break;
            }
         	case Currency.CechovniMince:
         	{
               DepositCurrency( amount, aukce, to );
               break;
            }
         	case Currency.MesicniKamen:
         	{
               DepositCurrency( amount, aukce, to );
               break;
            }
         	default: //Gold
            {
               to.BankBox.DropItem( new BankCheck( amount ) );
               break;
            }
         }      
      }
      
      private static void DepositCurrency( int amount, Auction aukce, Mobile to )
      {
			int toAdd = amount;

			while ( toAdd > 60000 )
			{
             switch( aukce.AuctionCurrency )
             {
             	case Currency.CechovniMince: to.BankBox.DropItem( new CechovniMince( 60000 ) ); break;
             	case Currency.MesicniKamen: to.BankBox.DropItem( new MesicniKamen( 60000 ) ); break;
             	default: break;
             }
             
				toAdd -= 60000;
			}

			if ( toAdd > 0 )
			{
             switch( aukce.AuctionCurrency )
             {
             	case Currency.CechovniMince: to.BankBox.DropItem( new CechovniMince( toAdd ) ); break;
             	case Currency.MesicniKamen: to.BankBox.DropItem( new MesicniKamen( toAdd ) ); break;
             	default: break;
             }
			}
      }
      
		public static bool WithdrawCurrency( Mobile from, Currency currency, int amount )
		{
         if ( from == null || from.BankBox == null || amount < 1 )
            return false;
            
         bool has = false;
         
         switch( currency )
         {
         	case Currency.Tokens:
         	{
               has = from.BankBox.ConsumeTotal( typeof( Tokens ), amount );
               break;
            }
         	case Currency.CechovniMince:
         	{
               has = from.BankBox.ConsumeTotal( typeof( CechovniMince ), amount );
               break;
            }
         	case Currency.MesicniKamen:
         	{
               has = from.BankBox.ConsumeTotal( typeof( MesicniKamen ), amount );
               break;
            }
         	default: //Gold
            {
               has = Banker.Withdraw( from, amount );
               break;
            }
         }
         
         return has;
      }
      
      public static bool HasAuction( Mobile from )
      {
         if ( from.AccessLevel > AccessLevel.Player )
            return false;
         
         foreach ( Item item in World.Items.Values )
  			{
  				if ( item is Auction && !item.Deleted )
  				{
               if ( ((Auction)item).Owner == from )
                  return true;
            }
  			}
  			
  			return false;
      }

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write( (int) 1 );
			
			writer.Write( (int) m_Currency );
			writer.Write( m_ItemLoc );
			
			writer.Write( (int) m_HighestBid );
			writer.Write( (int) m_StartBid );
         writer.Write( (Mobile) m_Owner );
         writer.Write( (Mobile) m_HighestBidder );
         writer.Write( m_AuctionedItem );
         writer.Write( (DateTime) m_AuctionEnd );
			writer.Write( (int) m_Duration );
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
			
			switch( version )
			{
            case 1:
					{
						m_Currency = (Currency) reader.ReadInt();
						m_ItemLoc = reader.ReadPoint3D();
						goto case 0;
					}
            case 0:
					{
          			m_HighestBid = reader.ReadInt();
          			m_StartBid = reader.ReadInt();
          			m_Owner = reader.ReadMobile();
          			m_HighestBidder = reader.ReadMobile();
          			m_AuctionedItem = reader.ReadItem();
          			m_AuctionEnd = reader.ReadDateTime();
          			m_Duration = reader.ReadInt();
						break;
					}
			}
		}
		
		//GUMP
		private class AuctionGump : Gump
		{
			private Auction m_Auction;
			
			public AuctionGump( Auction auction ) : base( 300, 200 )
			{
				m_Auction = auction;
				
				if ( m_Auction.HighestBidder == null )
				  m_Auction.HighestBid = 0;
				  
				if ( m_Auction.Name == null )
				  m_Auction.Name = "Aukce";
				
				Closable=true;
				Disposable=true;
				Dragable=true;
				Resizable=false;
				AddPage(0);
            AddBackground(0, 0, 369, 190, 9200);
            AddBackground(5, 5, 300, 180, 9350);
            AddLabel(15, 15, 2, "AUKCE: " + m_Auction.Name.ToUpper());
            AddLabel(15, 40, 0, ( m_Auction.HighestBid >= m_Auction.StartBid ) ? 
               String.Format( "Nejvyssi nabidka: {0} ({1})", m_Auction.HighestBid.ToString( "N0", Auberon.Chat.General.Nfi ), m_Auction.HighestBidder.RawName ) : 
               String.Format( "Vyvolavaci cena: {0} {1}", m_Auction.StartBid.ToString( "N0", Auberon.Chat.General.Nfi ), CurrencyName[ (int) m_Auction.AuctionCurrency ] ));
            AddLabel(15, 65, 0, ( DateTime.Now > m_Auction.AuctionEnd ) ? "Ukoncena aukce" : String.Format( "Konec aukce: {0:g}", m_Auction.AuctionEnd ) );
            
            if ( DateTime.Now < m_Auction.AuctionEnd )
            {
               AddButton(240, 94, 4005, 4006, 1, GumpButtonType.Reply, 0);
               AddLabel(15, 95, 0, @"Prihodit:");
               AddTextEntry(79, 95, 156, 20, 0, 1, String.Format( "{0}", MinimalBid() ) );
            }
            
            if ( m_Auction.Owner != null && m_Auction.Owner.AccessLevel == AccessLevel.Player )
               AddLabel(15, 125, 0, String.Format( "Majitel aukce: {0}", m_Auction.Owner.RawName ) );
               
            AddLabel( 15, 150, 47, String.Format( "Nakup pomoci {0}", CurrencyName[ (int) m_Auction.AuctionCurrency ] ) );               
            AddItem(309, 11, m_Auction.AuctionedItem.ItemID, m_Auction.AuctionedItem.Hue);
			}
			
			private int MinimalBid()
			{
            return ( m_Auction.HighestBid >= m_Auction.StartBid ) ? ( m_Auction.HighestBid + ( (int)(m_Auction.HighestBid * 0.1 ) ) ) : m_Auction.StartBid;
         }

			public override void OnResponse(NetState sender, RelayInfo info)
			{
				Mobile from = sender.Mobile;
				if ( m_Auction == null || m_Auction.Deleted || m_Auction.AuctionedItem == null || from.HasTrade || from.BankBox == null )
					return;

				from.CloseGump( typeof(AuctionGump) );
				
            switch(info.ButtonID)
				{
					case 1:
						{
                     //PRIHOZENI
                     if ( DateTime.Now > m_Auction.AuctionEnd )
                     {
                        from.SendMessage(1161, "Aukce jiz byla ukoncena!");
                        return;
                     }
			            else if ( !from.InRange( m_Auction.GetWorldLocation(), 8 ) )
			            {
                        from.SendLocalizedMessage( 502138 );
                        return;
                     }
                     else if ( m_Auction.HighestBidder == from )
                     {
                        from.SendMessage(1161, "Jiz jsi ucinil/a nejvyssi nabidku!");
                        from.SendGump( new AuctionGump( m_Auction ) );
                        return;
                     }
                     else if ( m_Auction.Owner == from )
                     {
                        from.SendMessage(1161, "Nemuzes prihazovat na svoji aukci!");
                        return;
                     }
                     
                    TextRelay tr_CashAmount = info.GetTextEntry(1);
                    if (tr_CashAmount != null)
                    {
                        int i_MaxAmount = 0;
                        try
                        {
                            i_MaxAmount = Convert.ToInt32(tr_CashAmount.Text, 10);
                        }
                        catch
                        {
                            from.SendMessage(1161, "Musis napsat pouze cisla");
                            from.SendGump( new AuctionGump( m_Auction ) );
                            return;
                        }
                        
                        if( i_MaxAmount < 10 || i_MaxAmount > 100000000 )
                        {
                            from.SendMessage(1161, "Nabidka musi byt v rozmezi 10 - 100 000 000");
                            from.SendGump( new AuctionGump( m_Auction ) );
                            return;
                        }
                        
                        if ( i_MaxAmount >= MinimalBid() )
                        {
                           bool has = WithdrawCurrency( from, m_Auction.AuctionCurrency, i_MaxAmount );
                            
                            if ( has )
                            {
                                if ( m_Auction.HighestBidder != null && m_Auction.HighestBid > 0 )
                                {
                                    m_Auction.HighestBidder.SendMessage( 1173, "{0} nabidl/a {1} {2} na aukci {3}", from.RawName, i_MaxAmount.ToString( "N0", Auberon.Chat.General.Nfi ), CurrencyName[ (int) m_Auction.AuctionCurrency ], m_Auction.Name );
                                    m_Auction.HighestBidder.SendMessage( "{0} {1} za tvuj posledni prihoz bylo umisteno do banky", m_Auction.HighestBid.ToString( "N0", Auberon.Chat.General.Nfi ), CurrencyName[ (int) m_Auction.AuctionCurrency ] );
                                    GiveCurrency( m_Auction.HighestBidder, m_Auction, m_Auction.HighestBid );
                                    m_Auction.HighestBidder.SendSound( 1058 );
                                }
                                
                                m_Auction.HighestBidder = from;
                                m_Auction.HighestBid = i_MaxAmount;
                                m_Auction.AuctionEnd = m_Auction.AuctionEnd + TimeSpan.FromMinutes( 10 );
                                from.SendMessage( 1173, "Prihoz {0} {1} prijat! Konec aukce byl oddalen o 10 minut.", i_MaxAmount.ToString( "N0", Auberon.Chat.General.Nfi ), CurrencyName[ (int) m_Auction.AuctionCurrency ] );
                                from.SendSound( 55 );
                                from.SendGump( new AuctionGump( m_Auction ) );
                            }
                            else
                                from.SendMessage( 1173, "Nemas v bance tolik {0}!", CurrencyName[ (int) m_Auction.AuctionCurrency ] );
                        }
                        else
                        {
                            from.SendMessage( 1173, "Minimalni castka kterou lze prihodit je {0} {1}.", MinimalBid().ToString( "N0", Auberon.Chat.General.Nfi ), CurrencyName[ (int) m_Auction.AuctionCurrency ] );
                            from.SendGump( new AuctionGump( m_Auction ) );
                        }
                    }
                     break;
						}
				}
			}
		}
		
		//CREATE GUMP
		private class AuctionCreateGump : Gump
		{
			private Auction m_Auction;
			private Item m_Item;
			
			public AuctionCreateGump( Auction auction, Item item ) : base( 300, 100 )
			{
				m_Auction = auction;
				m_Item = item;
				
				if ( m_Auction == null || m_Item == null )
				  return;
				  
				if ( m_Auction.Name == null )
				  m_Auction.Name = "Volna Aukcni Cedule";
				  
            Closable=true;
            Disposable=true;
            Dragable=true;
            Resizable=false;
            AddPage(0);
            AddBackground(0, 0, 375, 464, 9200);
            AddBackground(5, 5, 365, 453, 9350);
            AddLabel(108, 9, 2, @"VYTVORENI NOVE AUKCE");
            AddItem(280, 25, m_Item.ItemID, m_Item.Hue);
            AddLabel(18, 39, 0, String.Format( "PREDMET: {0}", ( m_Item == null ) ? "Bez nazvu" : m_Item.Name ) );
            AddLabel(15, 105, 0, @"NAZEV AUKCE:");
            AddImageTiled(115, 105, 200, 20, 9204);
            AddTextEntry(115, 105, 200, 20, 0, (int)TextEntries.AuctionName, ( m_Item == null ) ? @"" : m_Item.Name );
            AddLabel(15, 135, 0, @"VYVOLAVACI CENA:");
            AddImageTiled(150, 135, 200, 20, 9204);
            AddTextEntry(150, 135, 200, 20, 0, (int)TextEntries.StartBid, @"");
            AddLabel(15, 165, 0, @"TRVANI AUKCE:");
            AddLabel(160, 165, 0, @"Hodin (1 - 48)");
            AddImageTiled(120, 165, 35, 20, 9204);
            AddTextEntry(120, 165, 35, 20, 0, (int)TextEntries.Duration, @"");
            AddLabel(15, 195, 0, @"MENA:");
            
            for ( int i = 0; i < CurrencyName.Length; ++i )
            {
               AddRadio( 65, 195 + (i * 20), 210, 211, ( i == 0 ) ? true : false, 1000 + i );
               AddLabel( 90, 195 + (i * 20), 0, CurrencyName[ i ] );
            }
            
            string html = "<bodytext color=black>Jednou vytvorenou aukci nelze zrusit.<br>Pri neprodani predmetu se 5% poplatek za vytvoreni aukce nevraci!<br>";
            html += "Kazdy hrac muze mit vytvorenou pouze jednu aukci v jeden moment.<br>Pozor pri prodeji predmetu, ktere behem aukce budou moci pouzit ostatni hraci (Dye Tub apod)<br>";
            html += "Predani vyhraneho predmetu a vyplata penez se provadi vzdy pri ukladani sveta (cca kazdych 20 minut)<br>";
            
            AddHtml( 15, 300, 348, 122, html, (bool)true, (bool)true);
            AddLabel(60, 431, 0, @"Ano, chci vytvorit aukci za 5% ceny:");
            AddButton(298, 429, 247, 248, 1, GumpButtonType.Reply, 0);
			}
			
        public enum TextEntries
        {
            AuctionName = 500,
            StartBid = 501,
            Duration = 502
        }
			
        public override void OnResponse(NetState state, RelayInfo info)
        {
            Mobile from = state.Mobile;

            if ( from == null || m_Auction == null )
                return;
                
            if ( m_Auction.Owner != null || m_Auction.AuctionedItem != null )
                return;

            if ( info.ButtonID == 1 ) //Create
            {
					if ( m_Item == null || m_Item.Deleted || !m_Item.IsChildOf( from.Backpack ) || HasAuction( from ) || m_Item.BlessedFor != null )
					 return;
               
               TextRelay aName = info.GetTextEntry( (int) TextEntries.AuctionName );
					TextRelay aStartBid = info.GetTextEntry( (int) TextEntries.StartBid );
					TextRelay aDuration = info.GetTextEntry( (int) TextEntries.Duration );

					string i_Name = (aName == null) ? "" : aName.Text;
					i_Name = Utility.FixHtml( i_Name.Trim() );
					
                int i_StartBid = 0;
                int i_Duration = 0;
                
                try
                {
                    i_StartBid = Convert.ToInt32(aStartBid.Text, 10);
                }
                catch
                {
                    from.SendMessage(1161, "Do pole vyvolavaci cena musis napsat pouze cisla");
                    from.SendGump( new AuctionCreateGump( m_Auction, m_Item ) );
                    return;
                }
                
                try
                {
                    i_Duration = Convert.ToInt32(aDuration.Text, 10);
                }
                catch
                {
                    from.SendMessage(1161, "Do pole trvani aukce musis napsat pouze cisla 1 - 48");
                    from.SendGump( new AuctionCreateGump( m_Auction, m_Item ) );
                    return;
                }

					if( i_Name.Length < 2 || i_Name.Length > 30 )
                {
                    from.SendMessage(1161, "Nazev aukce musi obsahovat 2 - 30 znaku");
                    from.SendGump( new AuctionCreateGump( m_Auction, m_Item ) );
                    return;
                }
					else if( i_Duration < 1 || i_Duration > 48 )
                {
                    from.SendMessage(1161, "Trvani aukce musi byt v rozmezi 1 - 48");
                    from.SendGump( new AuctionCreateGump( m_Auction, m_Item ) );
                    return;
                }
					else if( i_StartBid < 10 || i_StartBid > 100000000 )
                {
                    from.SendMessage(1161, "vyvolavaci cena musi byt v rozmezi 10 - 100 000 000");
                    from.SendGump( new AuctionCreateGump( m_Auction, m_Item ) );
                    return;
                }
                
                Currency i_Currency = Currency.Gold;
                
    				if ( info.IsSwitched( 1001 ) )
    					i_Currency = Currency.Tokens;
    				else if ( info.IsSwitched( 1002 ) )
    					i_Currency = Currency.CechovniMince;
    				else if ( info.IsSwitched( 1003 ) )
    					i_Currency = Currency.MesicniKamen;
                
                int poplatek = (int) Math.Max( 1, (int) i_StartBid * 0.05 );
               
                if ( !WithdrawCurrency( from, i_Currency, poplatek ) )
                {
                  from.SendMessage( 1173, "Nemas v bance {0} {1} pro zaplaceni 5% poplatku!", poplatek.ToString( "N0", Auberon.Chat.General.Nfi ), CurrencyName[ (int) i_Currency ] );
                  from.SendGump( new AuctionCreateGump( m_Auction, m_Item ) );
                  return;
                }
                else
                  from.SendMessage( 1173, "{0} {1} pro zaplaceni 5% poplatku bylo vybrano z tve banky!", poplatek.ToString( "N0", Auberon.Chat.General.Nfi ), CurrencyName[ (int) i_Currency ] );

                m_Auction.Duration = i_Duration;
                m_Auction.StartBid = i_StartBid;
               m_Auction.AuctionedItem = m_Item;
               m_Auction.Name = i_Name;
               m_Auction.Owner = from;
               m_Auction.AuctionCurrency = i_Currency;
                from.SendMessage( 1161, "Aukce byla uspesne vytvorena" );
                
                if ( from.AccessLevel == AccessLevel.Player )
                  World.Broadcast( 2125, false, String.Format( "{0} vytvoril/a aukci {1} za {2} {3}.", from.RawName, i_Name, i_StartBid.ToString( "N0", Auberon.Chat.General.Nfi ), CurrencyName[ (int) i_Currency ] ) );
            }
         }
		}
		
		//TARGET
		private class SelectItemTarget : Target
		{
			private Auction m_Auction;

			public SelectItemTarget( Auction auction ) : base( 1, false, TargetFlags.None )
			{
				m_Auction = auction;
			}

			protected override void OnTarget( Mobile from, object target )
			{
				if ( HasAuction( from ) )
				{
    				from.SendMessage( "Muzes mit pouze jednu aukci" );
    				return;
            }
            
            if ( target is Item && m_Auction != null )
				{
                Item item = (Item) target;
               
               if ( !( from.InRange( m_Auction.GetWorldLocation(), 6 ) && from.InLOS( m_Auction ) ) )
               {
      				from.SendLocalizedMessage( 502138 );
               }
               else if ( !item.IsChildOf( from.Backpack ) || !item.Movable )
    					from.SendMessage( "Predmet musis mit v batohu" );
               else if( item.BlessedFor != null )
    					from.SendMessage( "Blessed For predmety nelze dat do aukce" );
    				else if ( item is PeerlessKey || item is GuardKey || XmlAttach.FindAttachment( item, typeof( XmlEnchantWeaponDamage ) ) != null
                 || XmlAttach.FindAttachment( item, typeof( TemporaryQuestObject ) ) != null || XmlAttach.FindAttachment( item, typeof( XmlDesc ) ) != null ||
                 item is Xanthos.ShrinkSystem.ShrinkItem || Ethics.Ethic.IsImbued( item, true ) || 
                 item is Container || item is Engines.BulkOrders.BulkOrderBook || item is PowerScrollBook ||
                 item is CheckBook || item is SeedBox || item is BlackSmithBox || item is GemBox || item is MarbleBox
                  || item is MasonryBox || item is ScaleBox || item is TailoringBox || item is ToolBox || item is WoodBox
                  || item is BODExchangeBox || item is SpellbookBasket || ( item is BaseTalisman && ((BaseTalisman)item).Owner != null ) )
    					from.SendMessage( "Tento predmet nelze dat do aukce" );
    				else
    				{
                  from.SendGump( new AuctionCreateGump( m_Auction, item ) );
    				}
            }
				else
				{
					from.SendMessage( "Toto neni predmet" );
					return;
				}
			}
		}
	}
}
