using System;
using System.Collections;
using System.IO;
using Server;
using Server.Gumps;
using Server.Mobiles;
using Server.Network;
using System.Globalization;

namespace Auberon.Chat
{
	public class General
	{
		private static string s_Version = "1.6";
		private static string s_SavePath = "Saves/Chat";
		
		private static NumberFormatInfo s_Nfi;

		public static string Version { get { return s_Version; } }
		public static string SavePath { get { return s_SavePath; } }

      public static NumberFormatInfo Nfi { get { return s_Nfi; } }

		public static void Configure()
		{
			EventSink.WorldLoad += new WorldLoadEventHandler(OnLoad);
			EventSink.WorldSave += new WorldSaveEventHandler(OnSave);
		}

		private static void OnLoad()
		{
			Data.Load();

         s_Nfi = new CultureInfo( "de-DE", false ).NumberFormat;
         s_Nfi.NumberGroupSeparator = " ";
		}

		private static void OnSave(WorldSaveEventArgs args)
		{
			Data.Save();
		}
	}
}
