using System;
using Server;
using Server.Guilds;
using Server.Commands;
using Server.Commands.Generic;

namespace Auberon.Chat
{
	public class GuildChat
	{
		public static void Initialize()
		{
			CommandSystem.Register( "GC" , AccessLevel.Player, new CommandEventHandler( GMessage_OnCommand ) );
		}

		[Usage( "gc <text>" )]
		[Description( "Broadcasts a message to all online guild members." )]
		public static void GMessage_OnCommand( CommandEventArgs e )
		{
			Guild m_Guild = (Guild) e.Mobile.Guild;
			
			if ( m_Guild != null )
			{
			   m_Guild.GuildChat( e.Mobile, e.ArgString );
			   Server.Mobiles.PlayerMobile.SendToStaffMessage( e.Mobile, "[Guild]: {0}", e.ArgString );
// 				m_Guild.GuildMessage( 1008083, "[{0}] {1}", e.Mobile.Name, e.ArgString );
         }
			else
				e.Mobile.SendMessage( "Musis byt v guilde." );
		}
	}
}