using System;
using Server;
using Server.Network;
using Server.Mobiles;
using Server.Gumps;
using Server.Commands;
using System.Collections;

namespace Auberon.Chat
{
	public class PublicChat
	{
		public static void Initialize()
		{
			CommandSystem.Register( "c", AccessLevel.Player, new CommandEventHandler( ooc_OnCommand ) );
			CommandSystem.Register( "chat", AccessLevel.Player, new CommandEventHandler( ooc_OnCommand ) );
		}

		[Usage("chat")]
		[Description("Global chat.")]
		public static void ooc_OnCommand( CommandEventArgs e )
		{
			int color;
			string Message = e.ArgString;
			Message = Message.Trim();
			Mobile m = (Mobile) e.Mobile;
			
			if ( Message.Length == 0 )
			{
				if( m.HasGump( typeof(SIMGumpMini) ) )
					m.CloseGump( typeof(SIMGumpMini) );
				
				if( m.HasGump( typeof(SIMGumpOptions) ) )
					m.CloseGump( typeof(SIMGumpOptions) );

				if( m.HasGump( typeof(SIMGumpList) ) )
					m.CloseGump( typeof(SIMGumpList) );

				m.SendGump(new SIMGumpList(m));
			}
			else if ( Data.GetData(m).DontListenChat == true )
				m.SendMessage("Nemuzes psat na chat pokud mas zakazan jeho poslech.");
			else if ( Data.GetData(m).Status == OnlineStatus.Hidden && m.AccessLevel == AccessLevel.Player)
				m.SendMessage("Nemuzes psat na chat pokud je tvuj status {0}", Data.StatusText[2].ToUpper());
			else if ( m.Squelched == true )
				m.SendMessage("Nemuzes psat na chat pokud nemuzes mluvit.");
			else if ( m is PlayerMobile && ((PlayerMobile)m).ChatBan == true )
				m.SendMessage("Mas zakazano psat na verejny chat.");
			else
			{
				foreach (Data data in Data.Datas.Values)
				{
					if (m != null && (m == data.Mobile || (Data.GetData(data.Mobile).DontListenChat == false && !Data.GetData(data.Mobile).Ignores.Contains(m))))
					{
						if ( m.AccessLevel > AccessLevel.Player )
                     color = (Data.GetData(data.Mobile).MsgHueStaff < 1) ? 12 : Data.GetData(data.Mobile).MsgHueStaff;
                  else
                     color = (Data.GetData(data.Mobile).MsgHue < 1) ? 23 : Data.GetData(data.Mobile).MsgHue;
						
						data.Mobile.SendMessage(color, m.RawName + ": " + Message );
					}
				}

				LogIt.WriteLine("Public chat", m, "{0} {1}: \"{2}\" ", m.AccessLevel, CommandLogging.Format(m), Message);
			}
		}
	}
}
