using System;
using System.Net;
using Server;
using Server.Accounting;
using Server.Network;
using Server.Targets;
using Server.Gumps;
using Server.Commands;
using Server.Commands.Generic;

namespace Auberon.Chat
{
	public class SIMGumpChat : Gump
	{
		private NetState m_State;
		private Mobile m_Focus;
		
		private void Resend( Mobile to, RelayInfo info )
		{
			TextRelay te = info.GetTextEntry( 0 );

			to.SendGump( new SIMGumpChat( to, m_State, te == null ? "" : te.Text ) );
		}
		
		public override void OnResponse(NetState state, RelayInfo info)
		{
			if (m_State == null || m_Focus == null)
				return;
				
			if ( m_Focus.NetState != null && m_Focus.NetState != m_State )
			{
            m_State = m_Focus.NetState;
            m_Focus = m_State.Mobile;
         }
         
			Mobile from = state.Mobile;

			switch (info.ButtonID)
			{
				case 0: // close
					{
						break;
					}
				case 1: // Tell
					{
						TextRelay text = info.GetTextEntry(0);
						string Author = from.RawName;
						string Message = ( text == null ) ? "" : text.Text;
						Message = Message.Trim();

						if (m_Focus.NetState == null)
						{
							from.SendMessage("Hrac jiz neni online.");
							return;
						}
						else if (m_Focus.Deleted)
						{
							from.SendMessage("Tento hrac jiz neexistuje.");
							return;
						}
						else if ((Data.GetData(m_Focus).Ignores.Contains(from) || Data.GetData(m_Focus).Status == OnlineStatus.Hidden) && from.AccessLevel == AccessLevel.Player)
						{
							from.SendMessage("Hrac {0} nebyl nalezen.", m_Focus.RawName);
							return;
						}
						else if (Data.GetData(from).Status == OnlineStatus.Hidden && from.AccessLevel == AccessLevel.Player)
						{
							from.SendMessage("Nemuzes poslat zpravu pokud je tvuj status {0}", Data.StatusText[2].ToUpper());
							return;
						}
						else if (Message.Length == 0)
						{
							Resend(from, info);
							from.SendMessage("Musis napsat text zpravy.");
							return;
						}
						else
						{
							m_Focus.SendMessage(0x482, "Prisla zprava od {0}", from.RawName);

							m_Focus.SendGump(new SIMGumpSend(Author, Message, from.NetState));
							from.SendMessage("Zprava byla odeslana.");
							LogIt.WriteLine("Private messages", from, "{0} {1} telling {2} \"{3}\" ", from.AccessLevel, CommandLogging.Format(from), CommandLogging.Format(m_Focus), text.Text);
						}

						break;
					}
				case 2: // friends
					{
						if (m_Focus.NetState == null)
						{
							from.SendMessage("Hrac {0} jiz neni online.", m_Focus.RawName);
							return;
						}
						
                  if (Data.GetData(from).Friends.Contains(m_Focus))
							Data.GetData(from).RemoveFriend(m_Focus);
						else
							Data.GetData(from).AddFriend(m_Focus);
						
						Resend(from, info);
						break;
					}
				case 3: // ignores
					{
						if (m_Focus.NetState == null)
						{
							from.SendMessage("Hrac {0} jiz neni online.", m_Focus.RawName);
							return;
						}
                  
                  if (Data.GetData(from).Ignores.Contains(m_Focus))
							Data.GetData(from).RemoveIgnore(m_Focus);
						else
							Data.GetData(from).AddIgnore(m_Focus);
						
						Resend(from, info);
						break;
					}
				case 4: // client info
					{
						if (m_Focus.NetState == null)
						{
							from.SendMessage("Hrac {0} jiz neni online.", m_Focus.RawName);
							return;
						}
                  
                  if (from.AccessLevel >= AccessLevel.GameMaster)
							from.SendGump( new Server.Gumps.ClientGump( from, m_State ) );
						
						Resend(from, info);
						break;
					}
			}
		}

		public SIMGumpChat(Mobile from, NetState state)
			: this(from, state, "")
		{
		}

		private const int LabelColor32 = 0xFFFFFF;

		public string Center(string text)
		{
			return String.Format("<CENTER>{0}</CENTER>", text);
		}

		public string Color(string text, int color)
		{
			return String.Format("<BASEFONT COLOR=#{0:X6}>{1}</BASEFONT>", color, text);
		}

		public SIMGumpChat(Mobile from, NetState state, string initialText)
			: base(200, 100)
		{
			if (state == null)
				return;

			m_State = state;
// 			Account a = m_State.Account as Account;
			m_Focus = m_State.Mobile;
			
			int st = 0;
			if (Data.GetData(m_Focus).Status == OnlineStatus.Away)
				st = 1;
			else if (Data.GetData(m_Focus).Status == OnlineStatus.Hidden)
				st = 2;
			
			int fBut = 5402;
			int fTooltip = 1011244; //Add a Friend
			if (Data.GetData(from).Friends.Contains(m_Focus))
			{
				fBut = 5401;
				fTooltip = 1018037; //Remove a Friend
			}
			
			int iBut = 5402;
			int iTooltip = 3000469; //Ignore Player
			if (Data.GetData(from).Ignores.Contains(m_Focus))
			{
				iBut = 5401;
				iTooltip = 3000465; //Remove Player
			}

			this.Closable=false;
			this.Disposable=false;
			this.Dragable=true;
			this.Resizable=false;
			this.AddPage(0);
			this.AddBackground(6, 7, 329, 201, 5054);
			this.AddImageTiled(15, 16, 307, 20, 0xA40);
			this.AddAlphaRegion(15, 16, 307, 20);
			this.AddHtml(15, 16, 307, 20, Color(Center(String.Format("Zprava pro {0}{1}{2}", m_Focus.RawName, (st>0)?" ("+Data.StatusText[st]+")":"",(iBut==5401)?" (Ignored)":"")), LabelColor32), false, false);
			this.AddImageTiled(15, 153, 307, 24, 0xA40);
			this.AddAlphaRegion(15, 153, 307, 24);
			this.AddImageTiled(12, 41, 311, 107, 0xA40);
			this.AddImageTiled(13, 42, 309, 105, 0xBBC);
			this.AddTextEntry(15, 42, 307, 105, 0x480, 0, (initialText == null || (initialText = initialText.Trim()).Length == 0) ? "" : initialText);
			this.AddButton(65, 154, 4017, 4019, 0, GumpButtonType.Reply, 0);
			this.AddHtml( 20, 155, 45, 19, Color("Zavrit", LabelColor32), (bool)false, (bool)false);
			if (Data.GetData(m_Focus).Ignores.Contains(from) && from.AccessLevel == AccessLevel.Player)
				this.AddImage(285, 154, 4007);
			else
				this.AddButton(290, 154, 4005, 4007, 1, GumpButtonType.Reply, 0);
			this.AddHtml( 240, 155, 50, 19, Color("Odeslat", LabelColor32), (bool)false, (bool)false);
			
			//friends
			this.AddButton(15, 181, fBut, fBut, 2, GumpButtonType.Reply, 0);
			this.AddTooltip( fTooltip );
			this.AddHtml( 35, 180, 50, 19, "Friend", (bool)false, (bool)false);
			//ignore
			this.AddButton(100, 181, iBut, iBut, 3, GumpButtonType.Reply, 0);
			this.AddTooltip( iTooltip );
			this.AddHtml( 120, 180, 50, 19, "Ignore", (bool)false, (bool)false);
			
			//client info
			if (from.AccessLevel >= AccessLevel.GameMaster)
			{
				this.AddButton(270, 181, 5601, 5605, 4, GumpButtonType.Reply, 0);
				this.AddTooltip( 3005000 ); //Player Info
				this.AddHtml( 293, 180, 50, 19, "Info", (bool)false, (bool)false);
			}
		}
	}
}
