using System;
using Server;
using Server.Network;
using Server.Gumps;

namespace Auberon.Chat
{
	public class SIMGumpMini : Gump
	{
		public SIMGumpMini() : base(50, 50)
		{
			this.Closable=true;
			this.Disposable=true;
			this.Dragable=true;
			this.Resizable=false;
			this.AddPage(0);
			this.AddImageTiled(0, 0, 78, 27, 2702);
			this.AddAlphaRegion(0, 0, 78, 27);
			this.AddButton(7, 3, 2018, 2019, 1, GumpButtonType.Reply, 0);
			this.AddTooltip( 3010107 ); //This button displays the chat window.  The Ultima Online chat system enables you to talk to other players on your shard who are not near you in-game.
		}
		
		public override void OnResponse(NetState state, RelayInfo info)
		{
			if (state == null)
				return;

			Mobile from = state.Mobile;


			switch (info.ButtonID)
			{
				case 0: // close
					{
						break;
					}
				case 1: // open
					{
						from.SendGump(new SIMGumpList(from));
						break;
					}
			}
		}
	}
}
