using System;
using Server;
using Server.Mobiles;
using Server.Network;
using Server.Gumps;
using Server.HuePickers;

namespace Auberon.Chat
{
	public class SIMGumpOptions : Gump
	{
		private const int LabelColor32 = 0xFFFFFF;
		
		private Mobile c_Owner;
		public Mobile Owner{ get{ return c_Owner; } }

		public string Color(string text, int color)
		{
			return String.Format("<BASEFONT COLOR=#{0:X6}>{1}</BASEFONT>", color, text);
		}
		
		public SIMGumpOptions(Mobile m) : base(100, 100)
		{
			this.Closable=true;
			this.Disposable=true;
			this.Dragable=true;
			this.Resizable=false;
			this.AddPage(0);
			this.AddBackground(39, 51, 166, 187, 5054);
			this.AddHtml( 47, 59, 150, 20, Color("<CENTER>Options</CENTER>", LabelColor32), (bool)false, (bool)false);
			this.AddImageTiled(47, 59, 150, 20, 0xA40);
			this.AddAlphaRegion(47, 59, 150, 20);
			this.AddButton(84, 207, 4017, 4019, 0, GumpButtonType.Reply, 0);
			AddTooltip( 1052061 ); //Close
			this.AddButton(123, 207, 4005, 4007, 1, GumpButtonType.Reply, 0);
			AddTooltip( 3000187 ); //Save
			this.AddButton(175, 207, 252, 253, 4, GumpButtonType.Reply, 0);
			AddTooltip( 3000484 ); //Info
			this.AddCheck(50, 101, 210, 211, Data.GetData(m).DontListenChat, 3);
			this.AddLabelCropped(75, 101, 117, 20, 0, @"Vypnout chat");
			this.AddButton(50, 130, 1896, 1895, 2, GumpButtonType.Reply, 0);
			AddTooltip( 3000313 ); //Select a Hue
			this.AddLabelCropped(75, 131, 117, 20, (Data.GetData(m).MsgHue < 1) ? 23 : Data.GetData(m).MsgHue, @"Barva chatu");
			this.AddButton(50, 160, 1896, 1895, 3, GumpButtonType.Reply, 0);
			AddTooltip( 3000313 ); //Select a Hue
			this.AddLabelCropped(75, 161, 117, 20, (Data.GetData(m).MsgHueStaff < 1) ? 12 : Data.GetData(m).MsgHueStaff, @"Barva chatu GM");
		}
		
		private class InternalPicker : HuePicker
		{
			private bool c_Staff;
			private Mobile c_Owner;
			
			public InternalPicker(bool staff, Mobile m)
				: base(0x1018)
			{
				c_Staff = staff;
				c_Owner = m;
			}

			public override void OnResponse(int hue)
			{
				try
				{
					if ( c_Staff )
                  Data.GetData(c_Owner).MsgHueStaff = hue;
               else
                  Data.GetData(c_Owner).MsgHue = hue;
				}
				catch
				{
					c_Owner.SendMessage( "An exception was caught. The property may not have changed." );
				}
				
				c_Owner.SendGump(new SIMGumpOptions(c_Owner));
			}
		}


		public override void OnResponse(NetState state, RelayInfo info)
		{
			if (state == null)
				return;

			Mobile from = state.Mobile;


			switch (info.ButtonID)
			{
				case 0: // close
					{
						from.SendGump(new SIMGumpList(from));
						break;
					}
				case 1: // save
					{
						Data.GetData(from).DontListenChat = (info.IsSwitched( 3 )) ? true : false;
						from.SendGump(new SIMGumpOptions(from));
						from.SendMessage("Nastaveni bylo ulozeno.");
						break;
					}
				case 2: //color picker
					{
						from.SendHuePicker(new InternalPicker(false, from));
						break;
					}
				case 3: //color picker staff
					{
						from.SendHuePicker(new InternalPicker(true, from));
						break;
					}
				case 4: // info
					{
						from.SendGump(new SIMGumpOptions(from));
						from.SendMessage("Prikazy: .c, .c <text zpravy>, .chat, .pm, .im, .pm <jmeno>");
						from.SendMessage("Auberon Chat v{0} by Vinz Clortho", General.Version);
						break;
					}
			}
		}
	}
}
