using System;
using Server;
using Server.Mobiles;
using Server.Network;
using Server.Gumps;

namespace Auberon.Chat
{
	public class SIMGumpSend : Gump
	{
		private const int LabelColor32 = 0xFFFFFF;
		private const int Azul = 0x8080FF;
		private NetState m_State;
		private Mobile m_Focus;
		
		public string Center(string text)
		{
			return String.Format("<CENTER>{0}</CENTER>", text);
		}

		public string Color(string text, int color)
		{
			return String.Format("<BASEFONT COLOR=#{0:X6}>{1}</BASEFONT>", color, text);
		}
		
		public SIMGumpSend(string Author, string Message, NetState state)
			: base(160, 50)
		{
			m_State = state;
			m_Focus = m_State.Mobile;
			
			this.Closable=false;
			this.Disposable=false;
			this.Dragable=true;
			this.Resizable=false;
			this.AddPage(0);
			this.AddBackground(6, 7, 329, 181, 5054);
			this.AddImageTiled(15, 16, 45, 20, 0xA40);
			this.AddAlphaRegion(15, 16, 45, 20);
			this.AddHtml(15, 16, 45, 20, Color(Center(DateTime.Now.ToShortTimeString()), Azul), false, false);
			this.AddImageTiled(65, 16, 257, 20, 0xA40);
			this.AddAlphaRegion(65, 16, 257, 20);
			this.AddHtml(65, 16, 257, 20, Color(Center(String.Format("Zprava od {0}", m_Focus.RawName)), LabelColor32), false, false);
			this.AddImageTiled(15, 153, 307, 24, 0xA40);
			this.AddAlphaRegion(15, 153, 307, 24);
			this.AddHtml( 15, 42, 307, 105, @"" + Message, (bool)true, (bool)true);
			this.AddButton(65, 154, 4017, 4019, 0, GumpButtonType.Reply, 0);
			this.AddHtml( 20, 155, 45, 19, Color("Zavrit", LabelColor32), (bool)false, (bool)false);
			this.AddButton(290, 154, 4005, 4007, 1, GumpButtonType.Reply, 0);
			this.AddHtml( 220, 155, 70, 19, Color("Odpovedet", LabelColor32), (bool)false, (bool)false);

		}
		
		


		public override void OnResponse(NetState state, RelayInfo info)
		{
			if (m_State == null || m_Focus == null)
				return;
				
			if ( m_Focus.NetState != null && m_Focus.NetState != m_State )
			{
            m_State = m_Focus.NetState;
            m_Focus = m_State.Mobile;
         }

			Mobile from = state.Mobile;

			switch (info.ButtonID)
			{
				case 0: // close
					{
						break;
					}
				case 1: // Tell
					{
						if (m_Focus.NetState == null)
						{
							from.SendMessage("Hrac jiz neni online.");
							return;
						}
						else if (m_Focus.Deleted)
						{
							from.SendMessage("Tento hrac jiz neexistuje.");
							return;
						}
						else if ( from.Squelched == true )
						{
							from.SendMessage("Nemuzes posilat PM pokud nemuzes mluvit.");
							return;
						}
						else if (Data.GetData(from).Status == OnlineStatus.Hidden && from.AccessLevel == AccessLevel.Player)
						{
							from.SendMessage("Nemuzes poslat zpravu pokud je tvuj status {0}", Data.StatusText[2].ToUpper());
							return;
						}
						else if ((Data.GetData(m_Focus).Ignores.Contains(from) || Data.GetData(m_Focus).Status == OnlineStatus.Hidden) && from.AccessLevel == AccessLevel.Player)
						{
							from.SendMessage("Hrac {0} nebyl nalezen.", m_Focus.RawName);
							return;
						}
						else
							from.SendGump(new SIMGumpChat(from, m_State));
						
						break;
					}
			}
		}
	}
}
