/**************************************
*        Container Rename v2.0        *
*      Distro files: Container.cs     *
*                                     *
*    Created by Joeku AKA Demortris   *
*              3/2/2006               *
*                                     *
*          Updated by SHAKA			  *   
*                                     *
*     D I M E N S I O N S .com.br     *
*         hell is only a word         *
*                                     *
* Anyone can modify/redistribute this *
*  DO NOT REMOVE/CHANGE THIS HEADER!  *
**************************************/

using System;
using Server;
using Server.ContextMenus;
using Server.Prompts;

namespace Server.Items
{
	public class ContainerRenamePrompt : Prompt
	{
		private Mobile m_Mobile;
		private BaseContainer i_Cont;

		public ContainerRenamePrompt( Mobile m, BaseContainer cont )
		{
			m_Mobile = m;
			i_Cont = cont;
		}

		public override void OnResponse( Mobile from, string text )
		{
			text = text.Trim();

			if ( text.Length > 40 )
				text = text.Substring( 0, 40 );

			if( !i_Cont.IsChildOf( from.Backpack ) && !i_Cont.IsChildOf( from.BankBox ))
				from.SendMessage("Konteiner musi byt pro prejmenovani v tvem batohu nebo bance.");
			else if ( text.Length > 0 )
			{
				i_Cont.Name = text;
				from.SendMessage("Konteiner byl prejmenovan na '{0}'.", text);
			}
		}
	}

	public class ContainerRenameEntry : ContextMenuEntry
	{
		private Mobile m_From;
		private BaseContainer i_Cont;

		public ContainerRenameEntry( Mobile from, BaseContainer cont ) : base( 5104 )
		{
			m_From = from;
			i_Cont = cont;
		}

		public override void OnClick()
		{
			if ( i_Cont.IsChildOf( m_From.Backpack ) || i_Cont.IsChildOf( m_From.BankBox) ) 
			{
				if (i_Cont is BaseQuiver)
				{
				   m_From.SendMessage("Tento predmet nemuze byt prejmenovat!");
            }  
            else
            { 
               m_From.SendMessage("Jak chces konteiner prejmenovat?");
				   m_From.SendMessage("(Esc to cancel)");
				   m_From.Prompt = new ContainerRenamePrompt( m_From, i_Cont );
            }
            
			}
			else
				m_From.SendMessage("Konteiner musi byt pro prejmenovani v tvem batohu nebo bance.");
		}
	}
}