using System; 
using Server; 
using Server.Engines.Craft; 

namespace Server.Items 
{ 
	[FlipableAttribute( 0x1034, 0x1035 )]
	public class RunicCarpenterTools : BaseRunicTool 
	{ 
		public override CraftSystem CraftSystem{ get{ return DefCarpentry.CraftSystem; } } 
      
      public override int LabelNumber { get { return 1044285; } }

		public override void AddNameProperties( ObjectPropertyList list ) 
		{ 
			base.AddNameProperties( list ); 

			int index = CraftResources.GetIndex( Resource ); 

			if ( index >= 301 && index <= 311 ) 
				return; 

			if ( !CraftResources.IsStandard( Resource ) ) 
			{ 
				int num = CraftResources.GetLocalizationNumber( Resource ); 

				if ( num > 0 ) 
					list.Add( num ); 
				else 
					list.Add( CraftResources.GetName( Resource ) ); 
			} 
		} 

		[Constructable] 
		public RunicCarpenterTools( CraftResource resource ) : base( resource, 0x1034 ) 
		{ 
			Weight = 2.0;
			Hue = CraftResources.GetHue( resource );
		} 

		[Constructable] 
		public RunicCarpenterTools( CraftResource resource, int uses ) : base( resource, uses, 0x1034 ) 
		{ 
			Weight = 2.0;
			Hue = CraftResources.GetHue( resource );
		} 

		public RunicCarpenterTools( Serial serial ) : base( serial ) 
		{ 
		} 

		public override void Serialize( GenericWriter writer ) 
		{ 
			base.Serialize( writer ); 

			writer.Write( (int) 0 ); // version 
		} 

		public override void Deserialize( GenericReader reader ) 
		{ 
			base.Deserialize( reader ); 

			int version = reader.ReadInt(); 
		} 
	} 
}