using System;
using Server.Misc;
using Server.Mobiles;
using Server.Commands;
using Server.Items;
using System.Collections;
using System.Collections.Generic;

namespace Server.Commands
{
   public class DrinkCommand
   {
     public static void Initialize()
     {
  	      CommandSystem.Register( "drink", AccessLevel.Player, new CommandEventHandler( Drink_OnCommand ) );
     }
  
     public static void Register( string command, AccessLevel access, CommandEventHandler handler )
     {
  	      CommandSystem.Register( command, access, handler );
     }
  
  	  [Usage( "drink" )] 
     [Description( "vypije potion z brasny na lektvary")] 
     public static void Drink_OnCommand( CommandEventArgs e )
     {
			if ( e.Mobile == null || e.Mobile.Backpack == null || e.Mobile.Region == null || e.Mobile.Paralyzed || e.Mobile.Frozen )
            return;
         
         PotionPouch pouch = e.Mobile.Backpack.FindItemByType( typeof(PotionPouch) ) as PotionPouch;
         
         if ( pouch == null )
         {
            e.Mobile.SendMessage( "Nemas u sebe brasnu na lektvary" );
            return;
         }
         
         if ( e.Length != 0 )
			{
				if ( e.GetString(0) == "gh" )
				{
				   if ( e.Mobile.Hits >= e.Mobile.HitsMax || e.Mobile.Poisoned || MortalStrike.IsWounded( e.Mobile ) || !e.Mobile.CanBeginAction( typeof( BaseHealPotion ) ) || pouch.GreaterHealPotion < 1 )
                  return;

               GreaterHealPotion pot = new GreaterHealPotion();
               e.Mobile.AddToBackpack( pot );
               pouch.GreaterHealPotion--;

               if ( e.Mobile.Region.OnDoubleClick( e.Mobile, pot ) )
                  pot.Drink( e.Mobile );
				}
				else if ( e.GetString(0) == "tr" )
				{
				   if ( e.Mobile.Stam >= e.Mobile.StamMax || !e.Mobile.CanBeginAction( typeof( BaseRefreshPotion ) ) || pouch.TotalRefreshPotion < 1 )
                  return;

               TotalRefreshPotion pot = new TotalRefreshPotion();
               e.Mobile.AddToBackpack( pot );
               pouch.TotalRefreshPotion--;

               if ( e.Mobile.Region.OnDoubleClick( e.Mobile, pot ) )
                  pot.Drink( e.Mobile );
				}
				else if ( e.GetString(0) == "gc" )
				{
				   if ( !e.Mobile.Poisoned || pouch.GreaterCurePotion < 1 )
                  return;

               GreaterCurePotion pot = new GreaterCurePotion();
               e.Mobile.AddToBackpack( pot );
               pouch.GreaterCurePotion--;

               if ( e.Mobile.Region.OnDoubleClick( e.Mobile, pot ) )
                  pot.Drink( e.Mobile );
				}
				else if ( e.GetString(0) == "mr" )
				{
				   if ( e.Mobile.Mana >= e.Mobile.ManaMax || !e.Mobile.CanBeginAction( typeof( BaseManaRefreshPotion ) ) || pouch.ManaPotion < 1 )
                  return;

               ManaPotion pot = new ManaPotion();
               e.Mobile.AddToBackpack( pot );
               pouch.ManaPotion--;

               if ( e.Mobile.Region.OnDoubleClick( e.Mobile, pot ) )
                  pot.Drink( e.Mobile );
				}
				else if ( e.GetString(0) == "tmr" )
				{
				   if ( e.Mobile.Mana >= e.Mobile.ManaMax || !e.Mobile.CanBeginAction( typeof( BaseManaRefreshPotion ) ) || pouch.TotalManaRefreshPotion < 1 )
                  return;

               TotalManaRefreshPotion pot = new TotalManaRefreshPotion();
               e.Mobile.AddToBackpack( pot );
               pouch.TotalManaRefreshPotion--;
               
               if ( e.Mobile.Region.OnDoubleClick( e.Mobile, pot ) )
                  pot.Drink( e.Mobile );
				}
				else if ( e.GetString(0) == "revit" )
				{
				   if ( ( e.Mobile.Mana >= e.Mobile.ManaMax && e.Mobile.Hits >= e.Mobile.HitsMax && e.Mobile.Stam >= e.Mobile.StamMax && !e.Mobile.Poisoned ) || !e.Mobile.CanBeginAction( typeof( SuperPotion ) ) || pouch.SuperPotion < 1 )
                  return;

               SuperPotion pot = new SuperPotion();
               e.Mobile.AddToBackpack( pot );
               pouch.SuperPotion--;

               if ( e.Mobile.Region.OnDoubleClick( e.Mobile, pot ) )
                  pot.Drink( e.Mobile );
				}
				else if ( e.GetString(0) == "slza" )
				{
				   if ( ForcedLeech( e.Mobile ) || pouch.Slzy < 1 )
                  return;
                  
               double time = 2.0 * ( 1.0 + (0.01 * AosAttributes.GetValue( e.Mobile, AosAttribute.EnhancePotions )) );

  					e.Mobile.RevealingAction();
               e.Mobile.FixedParticles( 0x373A, 10, 15, 5012, EffectLayer.Waist );
  					e.Mobile.PlaySound( 0x5C1 );
  					e.Mobile.PlaySound( 0x2D6 );
               e.Mobile.SendMessage( "Sani z monster imunnich na krvaceni povoleno na {0:F1} minut", time );
			      
               if ( e.Mobile.Body.IsHuman && !e.Mobile.Mounted )
				     e.Mobile.Animate( 34, 5, 1, true, false, 0 );
                 
  					ExpireTimer t = new ExpireTimer( e.Mobile, TimeSpan.FromMinutes( time ) );
  					t.Start();
  					m_Table[e.Mobile] = t;
               
               pouch.Slzy--;
				}
            else
               e.Mobile.SendMessage( "Neznamy lektvar. Musis napsat .drink-mezera-[gh, tr, gc, mr, tmr, revit, slza]" );
			}
         else
            e.Mobile.SendMessage( "Musis napsat .drink-mezera-[gh, tr, gc, mr, tmr, revit, slza]" );
     }
     
		private static Hashtable m_Table = new Hashtable();
		
		public static bool ForcedLeech( Mobile m )
		{
			if( m != null && m_Table[m] != null )
				return true;
			
			return false;
		}

		private class ExpireTimer : Timer
		{
			private Mobile m_Mobile;

			public ExpireTimer( Mobile m, TimeSpan delay ) : base( delay )
			{
				m_Mobile = m;
            Priority = TimerPriority.FiveSeconds;
			}

			protected override void OnTick()
			{
				Stop();

				m_Mobile.PlaySound( 0x5C2 );
				m_Table.Remove( m_Mobile );
				m_Mobile.SendMessage( "Ucinek Slzy Auberonu skoncil" );
			}
		}
   }
}