using System;
using Server;
using Server.Gumps;
using Server.Mobiles;
using Server.Commands;
using Server.Accounting;
using System.Collections;
using System.Text.RegularExpressions;
using Server.Network;

namespace Server.Gumps
{
	public class EmailGump : Gump
	{
		public static void Initialize()
		{ CommandSystem.Register("Email", AccessLevel.Player, new CommandEventHandler(Email_OnCommand)); }
		
		[Usage("Email")]
		[Description("Zmena emailu")]		
		public static void Email_OnCommand(CommandEventArgs e)
		{
			if( e.Mobile.HasGump( typeof(EmailGump) ) )
				e.Mobile.CloseGump( typeof(EmailGump) );
         
         e.Mobile.SendGump(new EmailGump(e.Mobile));      
      }
      
      public static bool IsEmail(string Email) 
      { 
          string strRegex = @"^([a-zA-Z0-9_\-\.]+)@((\[[0-9]{1,3}" + 
              @"\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([a-zA-Z0-9\-]+\" + 
              @".)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$"; 
          Regex re = new Regex(strRegex);
          
          if (re.IsMatch(Email)) 
              return true; 
          else 
              return false; 
      }
      
		private Mobile m_from;
      
		public EmailGump(Mobile m) : base(150, 200)
		{
         m_from = m;
        
         if ( m_from == null )
            return;
            
         Account acct = m_from.Account as Account;
			if ( acct == null )
				return;
				
         string tag = acct.GetTag( "email" );         
         if ( tag == null )
            tag = "";
            
         this.Closable=true;
			this.Disposable=true;
			this.Dragable=true;
			this.Resizable=false;

			AddPage(0);
			AddBackground(0, 0, 285, 145, 9200);
			AddHtml( 5, 25, 270, 80, @"Do textoveho pole napis a tlacitkem Accept odesli svoji emailovou adresu, na kterou chces zaslat prihlasovaci udaje v pripade ze je zapomenes.", (bool)true, (bool)true);
			AddAlphaRegion(5, 25, 270, 80);
			AddLabel(8, 4, 32, @"E-Mail majitele uctu");
			AddImageTiled(5, 115, 185, 20, 3504);
			AddTextEntry(5, 115, 185, 20, 0, 0, tag);
			AddButton(198, 117, 12000, 12001, 1, GumpButtonType.Reply, 0);
        }

        public override void OnResponse(NetState sender, RelayInfo info)
        {
            if ( m_from == null || sender.Mobile == null || sender.Mobile != m_from )
				  return;
				  
            switch(info.ButtonID)
            {
    				case 0: // close
    					{
                      break;
    					}
    				case 1: // zmena
    					{
                     TextRelay entry0 = info.GetTextEntry(0);
                     string text0 = (entry0 == null ? "" : entry0.Text.Trim());
                     
                     if ( IsEmail( text0 ) )
                     {
                        Account acct = m_from.Account as Account;
			               if ( acct == null )
				              return;
				              
				            acct.SetTag( "email", text0 );                        
                        m_from.SendMessage(34, "E-mailova adresa u uctu byla nastavena na {0}", text0);
                        m_from.SendMessage(34, "Je mozne ji kdykoliv zmenit prikazem .email");
                     }
                     else
                     {
                        m_from.SendMessage(34, "Neplatna e-mailova adresa!");
                        m_from.SendGump(new EmailGump(m_from));
                     }
                        
                     break;
    					}
            }
      }
	}
}
