using System;
using Server;
using Server.Network;
using Server.Items;
using Server.Mobiles;

namespace Server.Gumps
{
	public class EquipGump : Gump
	{
		public static bool ValidateLayer(int layer)
		{
			if (layer == (int) Layer.Invalid || layer == (int) Layer.Hair || layer == (int) Layer.Unused_xF || layer == (int) Layer.FacialHair || layer == (int) Layer.Backpack
                || layer == (int) Layer.ShopBuy || layer == (int) Layer.ShopResale || layer == (int) Layer.Mount || layer == (int) Layer.ShopSell || layer == (int) Layer.Bank || layer == (int) Layer.LastValid)
			return false;

			return true;
		}
		
		private Mobile m_From;

		public EquipGump(Mobile from)
		: base(200, 200)
		{
			if (from == null)
				return;
			
			m_From = from;

			this.Closable = true;
			this.Disposable = true;
			this.Dragable = true;
			this.Resizable = false;

			this.AddPage(0);
			this.AddBackground(0, 0, 520, 740, 9200);
			// this.AddBackground(5, 5, 510, 660, 9350);
			this.AddLabel(185, 10, 0x480, String.Format("Vybaveni ({0})", from.RawName));

			int x = 0;
			int y = 0;
			int cnt = 0;

			for (int i = 0; i < from.Items.Count; ++i)
			{
				Item item = from.Items[i];

				if (item == null || item.Deleted)
					continue;

				if (!ValidateLayer((int)item.Layer))
					continue;

				cnt++;

				if (cnt == 11)
				{
					y = 0;
					x = 250;
				}

				int hits = 0, maxhits = 0;

				if (item is BaseArmor && (((BaseArmor)item).HitPoints >= 0 && ((BaseArmor)item).MaxHitPoints > 0))
				{
					hits = ((BaseArmor)item).HitPoints;
					maxhits = ((BaseArmor)item).MaxHitPoints;
				}
				else if (item is BaseWeapon && (((BaseWeapon)item).HitPoints >= 0 && ((BaseWeapon)item).MaxHitPoints > 0))
				{
					hits = ((BaseWeapon)item).HitPoints;
					maxhits = ((BaseWeapon)item).MaxHitPoints;
				}

				string popis = (hits >= 0 && maxhits > 0) ? (hits < 1) ? String.Format("<basefont color=#FF0000>Durability: {0}/{1}<basefont color=black>", hits, maxhits) : String.Format("Durability: {0}/{1}", hits, maxhits) : "";

				if (item is ILevelable)
				{
					if (!String.IsNullOrEmpty(popis))
						popis = popis + "<br>";

					popis = popis + String.Format("Level: {0}/{1}<br>Spending points: {2}", ((ILevelable)item).Level, ((ILevelable)item).MaxLevel, ((ILevelable)item).Points);
				}

				this.AddBackground(x+10, y+30, 250, 72, 9350);
				AddItem(x+10, y+40, item.ItemID, item.Hue);

				if (item.Name == null)
					AddHtmlLocalized(x+72, y+35, 185, 18, item.LabelNumber, 153, false, false);
				else
					AddHtml(x+72, y+35, 185, 18, String.Format("<basefont color=#0000FF>{0}", item.Name), false, false);

				AddButton(x+50, y+78, 22404, 22405, (int)item.Layer + 10, GumpButtonType.Reply, 0);
				AddTooltip(500280); //...and place it into your backpack.
				AddHtml(x+72, y+55, 185, 45, String.Format("<basefont color=black>{0}", popis), false, true);

				y += 70;
			}
		}

		public override void OnResponse(NetState state, RelayInfo info)
		{
			Mobile from = state.Mobile; //who clicked

			if (from == null || m_From == null)
				return;

			if (info.ButtonID > 0 && ValidateLayer(info.ButtonID - 10))
			{
				Item item = m_From.FindItemOnLayer((Layer) info.ButtonID - 10);

				if (item != null)
				{
					if (from.AccessLevel >= AccessLevel.GameMaster)
					{
						from.SendGump(new PropertiesGump(from, item));
						from.SendGump(new EquipGump(m_From));
						return;
					}

					if (item.RootParent != from)
						return;

					from.PlaySound(0x48);
					from.AddToBackpack(item);
					from.SendLocalizedMessage(500647); // Some equipment has been moved to your backpack.
				}

				from.SendGump(new EquipGump(from));
			}
		}
	}
}