// By: BTS  aka Charon
using Server.Accounting;
using Server.Commands;
using Server.Items;
using Server.Mobiles;
using Server.Network;
using System;

namespace Server.Gumps
{
    public class EYNTK : Gump
    {
        public static void Initialize()
        { CommandSystem.Register("Info", AccessLevel.Player, new CommandEventHandler(MyChar_OnCommand)); }

        [Usage("Info")]
        [Description("Popis postavy")]
        public static void MyChar_OnCommand(CommandEventArgs e)
        {
            if (e.Mobile.HasGump(typeof(EYNTK)))
                e.Mobile.CloseGump(typeof(EYNTK));

            e.Mobile.SendGump(new EYNTK(e.Mobile, e.Mobile));
        }

        private Mobile m_Owner;
        private Mobile m_Sender;

        public EYNTK(Mobile m_from, Mobile sender) : base(30, 30)
        {
            m_Owner = m_from;
            m_Sender = sender;
            PlayerMobile pm_from = (PlayerMobile)m_from;
            Account xx = ((Mobile)pm_from).Account as Account;

            int myattack = (AosAttributes.GetValue(m_from, AosAttribute.AttackChance));
            int mybonusdex = (AosAttributes.GetValue(m_from, AosAttribute.BonusDex));
            int mybonushits = (AosAttributes.GetValue(m_from, AosAttribute.BonusHits));
            int mybonusint = (AosAttributes.GetValue(m_from, AosAttribute.BonusInt));
            int mybonusmana = (AosAttributes.GetValue(m_from, AosAttribute.BonusMana));
            int mybonusstam = (AosAttributes.GetValue(m_from, AosAttribute.BonusStam));
            int mybonusstr = (AosAttributes.GetValue(m_from, AosAttribute.BonusStr));
            int mycastrecovery = (AosAttributes.GetValue(m_from, AosAttribute.CastRecovery));
            int mycastspeed = (AosAttributes.GetValue(m_from, AosAttribute.CastSpeed));
            int mydefend = (AosAttributes.GetValue(m_from, AosAttribute.DefendChance));
            int myenhancepotion = (AosAttributes.GetValue(m_from, AosAttribute.EnhancePotions));
            int mylmc = (AosAttributes.GetValue(m_from, AosAttribute.LowerManaCost));
            int mylrc = (AosAttributes.GetValue(m_from, AosAttribute.LowerRegCost));
            int myluck = (AosAttributes.GetValue(m_from, AosAttribute.Luck));
            int myreflect = (AosAttributes.GetValue(m_from, AosAttribute.ReflectPhysical));
            int myregenhit = (AosAttributes.GetValue(m_from, AosAttribute.RegenHits));
            int myregenmana = (AosAttributes.GetValue(m_from, AosAttribute.RegenMana));
            int myregenstam = (AosAttributes.GetValue(m_from, AosAttribute.RegenStam));
            int myspelldamage = (AosAttributes.GetValue(m_from, AosAttribute.SpellDamage));
            int myweapondamage = (AosAttributes.GetValue(m_from, AosAttribute.WeaponDamage));
            int myweaponspeed = (AosAttributes.GetValue(m_from, AosAttribute.WeaponSpeed));
            int mysight = (AosAttributes.GetValue(m_from, AosAttribute.NightSight));

            this.Closable = true;
            this.Disposable = true;
            this.Dragable = true;
            this.Resizable = false;
            this.AddPage(0);
            this.AddBackground(0, 0, 452, 499, 9200);
            this.AddImageTiled(5, 8, 439, 483, 2702);
            this.AddImageTiled(6, 9, 184, 44, 3504);
            this.AddLabel(10, 8, 5, m_from.RawName);

            if (xx != null)
            {
                string tag = xx.GetTag("email");
                if (tag == null || tag == "")
                    tag = "E-mail nenastaven!";

                if (m_Sender == m_Owner)
                {
                    this.AddButton(10, 34, 2103, 2104, 1, GumpButtonType.Reply, 0);
                    AddTooltip(3000192); //Mail
                }

                this.AddLabel(25, 28, 0, tag);
            }

            this.AddImageTiled(6, 56, 184, 88, 3504);
            this.AddImageTiled(6, 145, 184, 66, 3504);
            this.AddImageTiled(6, 212, 184, 188, 3504);
            this.AddImageTiled(6, 402, 184, 88, 3504);
            this.AddLabel(10, 59, 0, @"Str: " + m_from.RawStr + " / " + m_from.Str);
            this.AddLabel(10, 79, 0, @"Dex: " + m_from.RawDex + " / " + m_from.Dex);
            this.AddLabel(10, 98, 0, @"Int: " + m_from.RawInt + " / " + m_from.Int);
            this.AddLabel(10, 117, 0, @"Stats: " + m_from.RawStatTotal + " / " + m_from.StatCap);
            this.AddLabel(11, 169, 0, @"Karma: " + m_from.Karma);
            this.AddLabel(11, 189, 0, @"Fame: " + m_from.Fame);
            this.AddLabel(10, 149, 0, String.Format("Raw Skill Total: {0:F1}", ((double)(m_from.SkillsTotal / 10))));
            this.AddLabel(10, 215, 0, @"Humility: " + m_from.Virtues.Humility);
            this.AddLabel(10, 230, 0, @"Sacrifice: " + m_from.Virtues.Sacrifice);
            this.AddLabel(10, 245, 0, @"Compassion: " + m_from.Virtues.Compassion);
            this.AddLabel(10, 260, 0, @"Spirituality: " + m_from.Virtues.Spirituality);
            this.AddLabel(10, 275, 0, @"Valor: " + m_from.Virtues.Valor);
            this.AddLabel(10, 290, 0, @"Honor: " + m_from.Virtues.Honor);
            this.AddLabel(10, 305, 0, @"Justice: " + m_from.Virtues.Justice);
            this.AddLabel(10, 320, 0, @"Honesty: " + m_from.Virtues.Honesty);

            int x = pm_from.ToTTotalMonsterFame;
            double chance = 0.000863316841 * Math.Pow(10, 0.00000425531915 * x);

            this.AddLabel(10, 335, 0, String.Format("ToT Fame: {0}", x));
            this.AddLabel(10, 350, 0, String.Format("ToT Sance: {0:F3}%", chance * 100));
            this.AddLabel(10, 365, 0, String.Format("Bodu v soutezi: {0}", pm_from.Expy));
            this.AddLabel(10, 380, 0, String.Format("Auberonovych Zubu: {0}", pm_from.Zuby));

            this.AddLabel(10, 406, 0, @"Facet: " + m_from.Map);
            this.AddLabel(10, 426, ((m_from.Hunger < 2) ? 32 : 0), @"Hlad: " + m_from.Hunger + " / 20");
            this.AddLabel(10, 446, ((m_from.TithingPoints < 2) ? 32 : 0), @"Tithing Points: " + m_from.TithingPoints);
            this.AddLabel(10, 466, 0, String.Format("Sebeoziveni: {0}x", pm_from.AvailableResurrects));

            //ban cudlik pro GM
            if (m_Sender != m_Owner && m_Sender.AccessLevel >= AccessLevel.GameMaster && m_Sender.AccessLevel > m_Owner.AccessLevel)
            {
                this.AddButton(160, 8, 4002, 4004, 2, GumpButtonType.Reply, 0);
                AddTooltip(1011261); //Lift a ban!
            }

            //druha pulka
            this.AddImageTiled(193, 9, 250, 44, 3504);

            this.AddLabel(197, 8, 0, @"Ucet vytvoren: " + xx.Created.ToString());
            this.AddLabel(197, 28, 0, @"Odehrany cas: " + Engines.XmlSpawner2.XmlDesc.FormatTime(pm_from.GameTime));

            this.AddImageTiled(193, 56, 250, 346, 3504);
            this.AddImageTiled(193, 402, 250, 88, 3504);
            this.AddLabel(197, 60, 0, "Bonus Str: " + mybonusstr.ToString());
            this.AddLabel(197, 75, 0, "Bonus Dex: " + mybonusdex.ToString());
            this.AddLabel(197, 90, 0, "Bunus Int: " + mybonusint.ToString());
            this.AddLabel(197, 105, 0, "Bonus Hits: " + mybonushits.ToString());
            this.AddLabel(197, 120, 0, "Bonus Mana: " + mybonusmana.ToString());
            this.AddLabel(197, 135, 0, "Bonus Stamina: " + mybonusstam.ToString());
            this.AddLabel(197, 150, 0, "Enhance Potions: " + myenhancepotion.ToString());

            PlayerMobile.TalentEntry te = ((PlayerMobile)m_from).GetTalent(PlayerMobile.TalentType.RychlaMagie);
            double maxFCRSpeed = 0.4;

            if (te != null && te.Enabled && te.Charges >= 3)
            {
                maxFCRSpeed = 0.15;
            }

            this.AddLabel(197, 165, 0, "Faster Cast Recovery: " + mycastrecovery.ToString() + String.Format(" ({0:F2}s)", Math.Max((8.00 - ((double)mycastrecovery / 2.00)) / 4.00, maxFCRSpeed)));
            this.AddLabel(197, 180, 0, "Faster Casting: " + mycastspeed.ToString() + " / 8");
            this.AddLabel(197, 195, 0, "Defend Chance: " + mydefend.ToString() + " / 55");
            this.AddLabel(197, 210, 0, "Bonus Attack Chance: " + myattack.ToString());
            this.AddLabel(197, 225, 0, "Lower Mana Cost: " + mylmc.ToString() + " / 40");
            this.AddLabel(197, 240, 0, "Lower Reg Cost: " + String.Format("{0} / {1}", mylrc, m_from.Region.IsPartOf(typeof(Regions.DungeonRegion)) ? 50 : 75));
            this.AddLabel(197, 255, 0, "Luck: " + myluck.ToString());
            this.AddLabel(197, 270, 0, "Reflect Physical: " + myreflect.ToString());
            this.AddLabel(197, 285, 0, "Regen Hits: " + myregenhit.ToString() + String.Format("/{0}", (m_from.Map == Map.Underworld) ? 4 : 60));
            this.AddLabel(197, 300, 0, "Regen Mana: " + myregenmana.ToString() + String.Format("/{0}", (m_from.Map == Map.Underworld) ? 4 : 60));
            this.AddLabel(197, 315, 0, "Regen Stam: " + myregenstam.ToString() + String.Format("/{0}", (m_from.Map == Map.Underworld) ? 4 : 60));

            int sdiCap = 0;
            int diCap = 0;

            if (m_from.FindItemOnLayer(Layer.Shoes) is BaseShoes)
            {
                sdiCap = ((BaseShoes)m_from.FindItemOnLayer(Layer.Shoes)).SDIBonus;
                diCap = ((BaseShoes)m_from.FindItemOnLayer(Layer.Shoes)).DIBonus;
            }
            else if (m_from.FindItemOnLayer(Layer.Shoes) is BaseLevelShoes)
            {
                sdiCap = ((BaseLevelShoes)m_from.FindItemOnLayer(Layer.Shoes)).SDIBonus;
                diCap = ((BaseLevelShoes)m_from.FindItemOnLayer(Layer.Shoes)).DIBonus;
            }

            if (m_from.Map != Map.Underworld)
            {
                this.AddLabel(197, 330, 0, "Bonus Spell Damage: " + myspelldamage.ToString() + String.Format(" / {0}", sdiCap + 400));
                this.AddLabel(197, 345, 0, "Bonus Weapon Damage: " + myweapondamage.ToString() + String.Format(" / {0}", diCap + 400));

                double SwingCap = (m_from.Weapon is BladeofTorment) ? 0.9 : 1.0;
                TimeSpan SwingSpeed = (m_from.Weapon as BaseWeapon).GetDelay(m_from) < TimeSpan.FromSeconds(SwingCap) ? TimeSpan.FromSeconds(SwingCap) : (m_from.Weapon as BaseWeapon).GetDelay(m_from);

                this.AddLabel(197, 360, 0, "Bonus Weapon Speed: " + myweaponspeed.ToString() + String.Format(" ({0}s/{1}s)", new DateTime(SwingSpeed.Ticks).ToString("s.ff"), SwingCap));
                this.AddLabel(197, 375, 0, String.Format("Nightsight: {0}", (mysight > 0) ? "Ano" : "Ne"));
                this.AddLabel(197, 390, 0, "Physical Resistance: " + m_from.PhysicalResistance + " / " + m_from.GetMaxResistance(ResistanceType.Physical));
                this.AddLabel(197, 405, 0, "Fire Resistance: " + m_from.FireResistance + " / " + m_from.GetMaxResistance(ResistanceType.Fire));
                this.AddLabel(197, 420, 0, "Cold Resistance: " + m_from.ColdResistance + " / " + m_from.GetMaxResistance(ResistanceType.Cold));
                this.AddLabel(197, 435, 0, "Poison Resistance: " + m_from.PoisonResistance + " / " + m_from.GetMaxResistance(ResistanceType.Poison));
                this.AddLabel(197, 450, 0, "Energy Resistance: " + m_from.EnergyResistance + " / " + m_from.GetMaxResistance(ResistanceType.Energy));
            }
            else
            {
                int min, max;
                ((BaseWeapon)m_from.Weapon).GetStatusDamage(m_from, out min, out max);
                this.AddLabel(197, 420, 0, String.Format("Damage: {0} - {1}", min, max));
                this.AddLabel(197, 435, 0, String.Format("Weapon swing speed: {0}s", new DateTime((m_from.Weapon as BaseWeapon).GetDelay(m_from).Ticks).ToString("s.ff")));
                this.AddLabel(197, 450, 0, String.Format("Armor rating: {0:F1}", m_from.ArmorRating));
            }

            double BandageSpeed = (m_from.Map != Map.Underworld) ? 5.0 + (0.5 * ((double)(120 - m_from.Dex) / 10)) : 9.4 + (0.6 * ((double)(120 - m_from.Dex) / 10));

            this.AddLabel(197, 465, 0, String.Format("Bandage speed: {0:0.0}s", new DateTime(TimeSpan.FromSeconds(Math.Max(BandageSpeed, (m_from.Map != Map.Underworld) ? 1.0 : 2.0)).Ticks).ToString("s.ff")));

            Engines.XmlSpawner2.UspechyAttachment att = (Engines.XmlSpawner2.UspechyAttachment)Engines.XmlSpawner2.XmlAttach.FindAttachment(m_from, typeof(Engines.XmlSpawner2.UspechyAttachment));

            //Dolni lista
            this.AddBackground(0, 502, 452, 35, 9200);
            this.AddButton(5, 508, 4026, 4028, 3, GumpButtonType.Reply, 0);
            this.AddLabel(40, 509, 0, @"Talenty");
            this.AddButton(100, 508, 4011, 4013, 4, GumpButtonType.Reply, 0);
            this.AddLabel(135, 509, 0, @"Tituly");
            this.AddButton(185, 508, 4026, 4028, 6, GumpButtonType.Reply, 0);
            this.AddLabel(220, 509, 0, @"Vybava");
            this.AddButton(300, 508, 4008, 4010, 5, GumpButtonType.Reply, 0);
            this.AddLabel(340, 510, 0, (att == null) ? "0 bodu" : att.AllMaps.ToString("N0", Auberon.Chat.General.Nfi) + " bodu");
        }

        public override void OnResponse(NetState sender, RelayInfo info)
        {
            if (m_Sender == null || m_Owner == null)
                return;

            switch (info.ButtonID)
            {
                case 0: // close
                    {
                        break;
                    }

                case 1:
                    {
                        if (m_Owner != m_Sender)
                            return;

                        m_Sender.SendGump(new EmailGump(sender.Mobile));
                        break;
                    }

                case 2:
                    {
                        if (m_Sender.AccessLevel < AccessLevel.GameMaster || m_Sender.AccessLevel <= m_Owner.AccessLevel)
                            return;

                        m_Sender.SendGump(new BanDurationGump((Account)m_Owner.Account));
                        break;
                    }

                case 3:
                    {
                        if (!m_Owner.Player)
                            return;

                        if (m_Sender.HasGump(typeof(Commands.TalentsCommand.TalentGump)))
                            m_Sender.CloseGump(typeof(Commands.TalentsCommand.TalentGump));

                        m_Sender.SendGump(new Commands.TalentsCommand.TalentGump(m_Sender, (PlayerMobile)m_Owner));
                        break;
                    }

                case 4:
                    {
                        if (m_Owner != m_Sender)
                            return;

                        if (m_Sender.HasGump(typeof(Commands.PlayerTitle.PlayerTitleGump)))
                            m_Sender.CloseGump(typeof(Commands.PlayerTitle.PlayerTitleGump));

                        m_Sender.SendGump(new Commands.PlayerTitle.PlayerTitleGump(m_Owner));
                        break;
                    }

                case 5:
                    {
                        if (m_Sender.HasGump(typeof(SoutezeBoardGump)))
                            m_Sender.CloseGump(typeof(SoutezeBoardGump));

                        m_Sender.SendGump(new SoutezeBoardGump());
                        break;
                    }

                case 6:
                    {
                        if (m_Sender.HasGump(typeof(EquipGump)))
                            m_Sender.CloseGump(typeof(EquipGump));

                        m_Sender.SendGump(new EquipGump(m_Owner));
                        break;
                    }
            }
        }
    }
}