using System;
using System.IO;
using Server;
using Server.Accounting;

namespace Server.Commands
{
	public class LogIt
	{
		private static bool m_Enabled = true;

		public static bool Enabled{ get{ return m_Enabled; } set{ m_Enabled = value; } }

		public static void WriteLine( string filename, Mobile from, string format, params object[] args )
		{
			WriteLine( filename, from, String.Format( format, args ) );
		}

		public static void WriteLine( string filename, Mobile from, string text )
		{
			if ( !m_Enabled )
				return;

			try
			{
				string path = Core.BaseDirectory;

				CommandLogging.AppendPath( ref path, "Logs" );
				path = Path.Combine( path, String.Format( "{0}.log", filename ) );

            using ( StreamWriter sw = new StreamWriter( path, true ) )
               sw.WriteLine( "{0} || {1} || {2}", DateTime.Now, from.NetState, text );
			}
			catch
			{
			}
		}
	}
}