using System;
using System.Text;
using Server;
using Server.Commands;
using Server.Gumps;
using Server.Accounting;

namespace Auberon.Custom
{
	class Broadcast
	{
		//{0} is the name of the player
		private readonly static string m_LoginMessage = "{0} {1} do hry.";//logging in
		private readonly static string m_LogoutMessage = "{0} {1} ze hry.";//logging out
		private readonly static int m_LoginHue = 6;//logging in hue
		private readonly static int m_LogoutHue = 6;//logging out hue
		//maximum access level to announce
		private static AccessLevel m_AnnounceLevel = AccessLevel.Player;
		/// <summary>
		/// Subscribes to the login and out event
		/// </summary>
		public static void Initialize()
		{
			EventSink.Login += new LoginEventHandler(EventSink_Login);
			EventSink.Disconnected += new DisconnectedEventHandler( EventSink_Disconnected );
		}
		/// <summary>
		/// On player Disconnected, broadcast a message.
		/// </summary>
		public static void EventSink_Disconnected(DisconnectedEventArgs e)
		{
			if (e.Mobile.Player)
			{
				if (e.Mobile.AccessLevel <= m_AnnounceLevel)
					CommandHandlers.BroadcastMessage(AccessLevel.Player, m_LogoutHue, String.Format(m_LogoutMessage, e.Mobile.RawName, e.Mobile.Female ? "odesla":"odesel"));
				else //broadcast any other level to the staff
					CommandHandlers.BroadcastMessage(AccessLevel.Owner, m_LogoutHue, String.Format(m_LogoutMessage, e.Mobile.RawName, e.Mobile.Female ? "odesla":"odesel"));
			}
		}
		/// <summary>
		/// On player login, broadcast a message.
		/// </summary>
		public static void EventSink_Login(LoginEventArgs e)
		{
			if (e.Mobile.Player)
			{
				if (e.Mobile.AccessLevel <= m_AnnounceLevel)
					CommandHandlers.BroadcastMessage(AccessLevel.Player, m_LoginHue, String.Format(m_LoginMessage, e.Mobile.RawName, e.Mobile.Female ? "vstoupila":"vstoupil"));
				else //broadcast any other level to the staff
					CommandHandlers.BroadcastMessage(AccessLevel.Owner, m_LoginHue, String.Format(m_LoginMessage, e.Mobile.RawName, e.Mobile.Female ? "vstoupila":"vstoupil"));
			
            //Email Gump
            Account acct = e.Mobile.Account as Account;
      		if ( acct != null )
      		{
                string tag = acct.GetTag( "email" );         
                if ( tag == null || tag == "" )
                {
                   e.Mobile.SendGump(new EmailGump(e.Mobile));
                }
            }
         }
		}
	}
}
