using System;
using Server.Misc;
using Server.Network;
using Server.Mobiles;
using Server.Commands;

namespace Server.Commands
{
   public class MedicCommand
   {
     public static void Initialize()
     {
  	      CommandSystem.Register( "medik", AccessLevel.Player, new CommandEventHandler( Medic_OnCommand ) );
  	      CommandSystem.Register( "medic", AccessLevel.Player, new CommandEventHandler( Medic_OnCommand ) );
     }
  
     public static void Register( string command, AccessLevel access, CommandEventHandler handler )
     {
  	      CommandSystem.Register( command, access, handler );
     }
  
  	  [Usage( "Medic" )] 
     [Description( "Premisti najmuteho medika na pozici hrace")] 
     public static void Medic_OnCommand( CommandEventArgs e )
     {
         BaseHire hire = BaseHire.HireTable[e.Mobile] as BaseHire;
    
         if( hire != null && !hire.Deleted && hire.GetOwner() == e.Mobile && hire is Medic ) 
         { 
            hire.Map = e.Mobile.Map;
            hire.Location = e.Mobile.Location;
            ((BaseCreature)hire).ControlOrder = OrderType.Come;
         }
         else
            e.Mobile.SendMessage( "Nemas najmuteho medika." );
      }
   }
}