using System;
using Server;
using Server.Network;
using Server.Mobiles;
using Server.Engines.XmlSpawner2;

namespace Server.Items
{
	public class PandemoniumGate : ConfirmationMoongate
	{
		[Constructable]
		public PandemoniumGate()
		{
			Hue = 1294;
			Dispellable = false;

			GumpWidth = 300;
			GumpHeight = 200;

			MessageColor = 55000;
			MessageNumber = 0;
			MessageString = "POZOR! Branou lze projit jen jednou za 14 dni! Opravdu chces vstoupit do dalsiho patra dungeonu? Jiz nebude cesty zpet.";

			TitleColor = 0x7800;
			TitleNumber = 1062108; // Please verify...

			Name = "druhe patro";
		}
		
		public override void OnGateUsed( Mobile from )
		{
         if ( from is PlayerMobile && from.AccessLevel == AccessLevel.Player )
         {
            HlavniQuest qatt = (HlavniQuest)XmlAttach.FindAttachment(from,typeof(HlavniQuest));
			
            if ( qatt == null )
			      return;
			   
			   qatt.NextPandemonium = DateTime.Now + TimeSpan.FromDays( 14.0 - ( (double) Math.Min( 20, Guilds.Guild.GetLevel( from ) / 5.0 ) ) );
			   
			   from.SendMessage( 0x35, "Branou muzes znovu projit {0:g}", qatt.NextPandemonium );
         }
         
         base.OnGateUsed( from );
		}
		
		public override void CheckGate( Mobile from, int range )
		{
			if (XmlAttach.FindAttachment(from, typeof(HlavniQuest)) == null)
				XmlAttach.AttachTo(from, new HlavniQuest());
				
			HlavniQuest qatt = (HlavniQuest)XmlAttach.FindAttachment(from,typeof(HlavniQuest));
			
			if ( qatt == null )
			   return;
			   
			if ( qatt.NextPandemonium > DateTime.Now && from.AccessLevel == AccessLevel.Player )
			{
            from.SendMessage( 0x35, "Branou muzes projit az {0:g}", qatt.NextPandemonium );
         }
         else
            base.CheckGate( from, range );
		}
		
		public PandemoniumGate( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int)0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}
