using System;
using Server;
using Server.Network;
using Server.Mobiles;
using Server.Spells.Fifth;
using Server.Spells.Seventh;
using Server.Spells.Necromancy;
using Server.Spells.Ninjitsu;
using Server.Spells.Spellweaving;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
	public class PandemoniumTeleporter : Teleporter
	{
		public void EndMessageLock(object state)
		{
			((Mobile)state).EndAction(this);
		}

		public override bool OnMoveOver(Mobile m)
		{
			if (this.Active)
			{
				if (!this.Creatures && !m.Player)
					return true;

				if (m.Player && m.AccessLevel == AccessLevel.Player)
				{
					bool CanGo = true;
					BaseHire hire = BaseHire.HireTable[m] as BaseHire;

					m.MagicDamageAbsorb = 0;
					m.MeleeDamageAbsorb = 0;

					BaseTalisman.RemoveWards(m);
					m.EndAction(typeof(DefensiveSpell));

					if (CountPets(m) > 0 || (hire != null && !hire.Deleted && hire.GetOwner() == m))
						CanGo = false;

					if (HasItems(m))
						CanGo = false;

					if (m.HasTrade || m.Holding != null || !m.Alive)
						CanGo = false;

					if (AttunementSpell.IsAbsorbing(m) || GiftOfLifeSpell.IsActive(m))
						CanGo = false;

					if (m.IsBodyMod || ArcaneForm.UnderTransformation(m) || AnimalForm.UnderTransformation(m) || TransformationSpell.UnderTransformation(m) || !m.CanBeginAction(typeof(PolymorphSpell)))
						CanGo = false;

					if(!CanGo)
					{
						if (m.BeginAction(this))
						{
							m.SendMessage("Nesmis mit u sebe zadne veci, nesmis sedet na zvireti, nesmis byt pod vlivem nekterych kouzel, byt nazivu a nesmi te doprovazet zadny pomocnik.");

							Timer.DelayCall(TimeSpan.FromSeconds(5.0), new TimerStateCallback(EndMessageLock), m);
						}

						return false;
					}

					m.CloseAllGumps();
				}

				StartTeleport(m);
				return false;
			}

			return true;
		}

		public int CountPets(Mobile master)
		{
			int count = 0;

			foreach (Mobile m in master.GetMobilesInRange(10))
			{
				if (m is BaseCreature)
				{
					BaseCreature pet = (BaseCreature)m;

					if (pet.Controlled && pet.ControlMaster == master)
						count++;
				}
			}

			return count;
		}

		public bool HasItems(Mobile m)
		{
			if (m == null)
				return true;

			if (m.Backpack == null)
				return false;

			List<Item> items = m.Backpack.Items;

			if (items.Count > 0)
			{
				for (int i = items.Count - 1; i >= 0; --i)
				{
					if (i >= items.Count)
						continue;

					if (items[i] == null || items[i].Deleted)
						continue;

					if (items[i] is Marker1 || items[i] is Marker2 || items[i] is Marker3 || items[i] is AniLargeVioletFlask
                  || items[i] is QuestHolder/* || items[i] is QuestNote*/)
					continue;
					else
						return true;
				}
			}

			for (int x = 0; x < m.Items.Count; ++x)
			{
				Item item = m.Items[x];

				if (item == null || item.Deleted)
					continue;

				if (item.Layer == Layer.Invalid || item.Layer == Layer.Hair || item.Layer == Layer.Unused_xF || item.Layer == Layer.FacialHair || item.Layer == Layer.Backpack
                || item.Layer == Layer.ShopBuy || item.Layer == Layer.ShopResale || item.Layer == Layer.ShopSell || item.Layer == Layer.Bank || item.Layer == Layer.LastValid)
				continue;

				return true;
			}

			ArrayList toDelete = new ArrayList();

			foreach (Item itm in World.Items.Values)
			{
				if (itm is Corpse && ((Corpse)itm).Owner == m && !itm.Deleted)
				{
					if (itm.Items.Count > 0)
						return true;
					else //smaze prazdne mrtvoly hrace
						toDelete.Add(itm);
				}
			}

			foreach (Item item in toDelete)
				item.Delete();

			return false;
		}

		[Constructable]
		public PandemoniumTeleporter()
		{
			Visible = false;
			Name = "Pandemonium Teleporter";
		}

		public PandemoniumTeleporter(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int)0); // version
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			int version = reader.ReadInt();
		}
	}
}