using System;
using Server;
using Server.Items;
using Server.Network;
using Server.Mobiles;

namespace Server.Engines.XmlSpawner2
{
	public class PetKeeperAttachment : XmlAttachment
	{
		private bool m_Merc;
		private bool m_Hiryu;
		private bool m_Dragon;
		private bool m_Daemon;
		private bool m_Spider;
		private bool m_Golem;

		[CommandProperty( AccessLevel.GameMaster )]
		public bool Merc { get { return m_Merc; } set { m_Merc = value; CheckAll(); } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public bool Hiryu { get { return m_Hiryu; } set { m_Hiryu = value; CheckAll(); } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public bool Dragon { get { return m_Dragon; } set { m_Dragon = value; CheckAll(); } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public bool Daemon { get { return m_Daemon; } set { m_Daemon = value; CheckAll(); } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public bool Spider { get { return m_Spider; } set { m_Spider = value; CheckAll(); } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public bool Golem { get { return m_Golem; } set { m_Golem = value; CheckAll(); } }

		public PetKeeperAttachment(ASerial serial) : base(serial)
		{
		}

		[Attachable]
		public PetKeeperAttachment()
		{
			Name = "PetKeeper";
		}
		
		public void CheckAll()
		{
			if ( m_Merc && m_Hiryu && m_Dragon && m_Daemon && m_Spider && m_Golem )
			{
				if ( Owner is PlayerMobile )
				{
					Mobile m = (Mobile) Owner;
					
					PlayerTitles.AddTitle( m, 3 );
					
					Item ps = new PetPowerScroll( SkillName.Anatomy, 150.0 );
					ps.BlessedFor = m;
					ps.LootType = LootType.Regular;
					m.AddToBackpack( ps );
					
					Item ps2 = new PetPowerScroll( SkillName.Tactics, 150.0 );
					ps2.BlessedFor = m;
					ps2.LootType = LootType.Regular;
					m.AddToBackpack( ps2 );
					
					m.SendMessage("Obdrzel(a) specialni power scrolly pro sva zvirata" );
				}
			}
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize(writer);
			writer.Write( (int) 1 );
			
			writer.Write(m_Golem);
			
			// version 0
			writer.Write(m_Merc);
			writer.Write(m_Hiryu);
			writer.Write(m_Dragon);
			writer.Write(m_Daemon);
			writer.Write(m_Spider);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			switch( version )
			{
				case 1:
					{
						m_Golem = reader.ReadBool();
						goto case 0;
					}
				case 0:
					{
						m_Merc = reader.ReadBool();
						m_Hiryu = reader.ReadBool();
						m_Dragon = reader.ReadBool();
						m_Daemon = reader.ReadBool();
						m_Spider = reader.ReadBool();
						break;
					}
			}
		}
	}
}
