using System;
using Server;
using Server.Network;
using Server.Mobiles;
using Server.Gumps;
using System.Collections;
using System.Collections.Generic;
using Server.Engines.XmlSpawner2;

namespace Server.Commands
{
	public class PlayerTitle
	{
		public static void Initialize()
		{
			CommandSystem.Register("Titul", AccessLevel.Player, new CommandEventHandler(PlayerTitle_OnCommand));
		}

		[Usage("Titul")]
		[Description("Nastavi titul hrace.")]
		private static void PlayerTitle_OnCommand(CommandEventArgs e)
		{
			if (e.Mobile != null)
			{
				if(e.Mobile.HasGump(typeof(PlayerTitleGump)))
					e.Mobile.CloseGump(typeof(PlayerTitleGump));

				e.Mobile.SendGump(new PlayerTitleGump(e.Mobile));
			}
		}

		public class PlayerTitleGump : Gump
		{
			private const int FieldsPerPage = 14;

			public PlayerTitleGump(Mobile from)
			: base(200, 50)
			{
				ArrayList ids = PlayerTitles.GetAllTitlesIDs(from);
				TitleProgressAttachment att = (TitleProgressAttachment) XmlAttach.FindAttachment(from, typeof(TitleProgressAttachment));
				Archeology arch = (Archeology)XmlAttach.FindAttachment(from, typeof(Archeology));
				UspechyAttachment usp = (UspechyAttachment)XmlAttach.FindAttachment(from, typeof(UspechyAttachment));

				int index = 0;
				string str = String.Empty;

				AddPage(0);
				AddBackground(0, 0, 285, 351, 5054);
				AddBackground(0, 352, 285, 231, 5054);

				//             AddImageTiled(10, 10, 240, 23, 0x52);
				//             AddImageTiled(11, 11, 238, 21, 0xBBC);

				AddLabel(65, 11, 0, "SEZNAM TITULU (" + ids.Count.ToString() + ")");
				AddLabel(65, 360, 0, "PREFIXY");

				for (int i = 0; i < PlayerTitles.PrefixMale.GetLength(0); ++i)
				{
					AddImageTiled(11, 380 + (index * 22), 238, 21, 0xBBC);

					str = (from.Female) ? PlayerTitles.PrefixFemale[i] : PlayerTitles.PrefixMale[i];

					if (from.AccessLevel > AccessLevel.Player)
						str = i.ToString() + ". " + str;

					AddLabelCropped(13, 380 + (index * 22), 150, 21, 0, str);
					AddImageTiled(181, 380 + (index * 22), 48, 17, 0xBBC);

					bool buttonAllowed = true;
					str = "";

					if (att != null)
					{
						if (i == 1 && !PlayerTitles.CheckPrefix(from, i)) //Admiral
						{
							buttonAllowed = false;
							str += ((att != null) ? att.Fishing.ToString() : "0") + "/250";
						}
						else if (i == 2 && !PlayerTitles.CheckPrefix(from, i)) //Baron
						{
							buttonAllowed = false;
							str += ((att != null) ? att.Collector.ToString() : "0") + "/200";
						}
						else if (i == 3 && !PlayerTitles.CheckPrefix(from, i)) //Marquis
						{
							buttonAllowed = false;
							XmlQuestPoints p = (XmlQuestPoints)XmlAttach.FindAttachment(from, typeof(XmlQuestPoints));
							str += ((p != null) ? p.QuestsCompleted.ToString() : "0") + "/600";
						}
						else if (i == 4 && !PlayerTitles.CheckPrefix(from, i)) //Knight
						{
							buttonAllowed = false;
							from.SendMessage("ring");
						}
						else if (i == 5 && !PlayerTitles.CheckPrefix(from, i)) //Professor
						{
							buttonAllowed = false;
							str += ((arch != null) ? arch.Artifacts.ToString() : "0") + "/25";
						}
						else if (i == 6 && !PlayerTitles.CheckPrefix(from, i)) //Crusader
						{
							buttonAllowed = false;
						}
						else if (i == 7 && !Items.Zanbato.HasFullSet(from)) //Samurai
						{
							buttonAllowed = false;
						}
						else if (i == 8 && !Multis.Deeds.HouseDeed.HasUWHouse(from)) //Immigrant
						{
							buttonAllowed = false;
							from.SendMessage("Immigrant");
						}

						if (str != "")
							AddLabelCropped(184, 380 + (index * 22), 234, 21, 0, str);

						if (buttonAllowed)
						{
							AddButton(256, 380 + (index * 22), 0x15E1, 0x15E5, i + 3000, GumpButtonType.Reply, 0);
							AddTooltip(3000187); //Save
						}
					}

					++index;
				}

				AddPage(1);

				int page = 1;
				index = 0;

				if (from.Title != null)
				{
					AddImageTiled(10, 32 + (index * 22), 240, 23, 0x52);
					AddImageTiled(11, 33 + (index * 22), 238, 21, 0xBBC);

					AddLabelCropped(13, 33 + (index * 22), 150, 21, 0, "Bez titulu");
					AddImageTiled(180, 34 + (index * 22), 50, 19, 0x52);
					AddImageTiled(181, 35 + (index * 22), 48, 17, 0xBBC);
					AddButton(256, 35 + (index * 22), 0x15E1, 0x15E5, 5000, GumpButtonType.Reply, 0);

					++index;
				}

				for (int i = 0; i < PlayerTitles.TitleName.GetLength(0); ++i)
				{
					if (index >= FieldsPerPage)
					{
						AddButton(231, 13, 0x15E1, 0x15E5, 0, GumpButtonType.Page, page + 1);
						AddTooltip(1011066); //Next page

						++page;
						index = 0;

						AddPage(page);

						AddButton(213, 13, 0x15E3, 0x15E7, 0, GumpButtonType.Page, page - 1);
						AddTooltip(1011067); //Previous page
					}

					// 					AddImageTiled(10, 32 + (index * 22), 240, 23, 0x52);
					AddImageTiled(11, 33 + (index * 22), 238, 21, 0xBBC);

					str = PlayerTitles.TitleName[i];

					if (from.AccessLevel > AccessLevel.Player)
						str = i.ToString() + ". " + str;

					AddLabelCropped(13, 33 + (index * 22), 150, 21, 0, str);
					// 					AddImageTiled(180, 34 + (index * 22), 50, 19, 0x52);
					AddImageTiled(181, 35 + (index * 22), 48, 17, 0xBBC);

					if (!ids.Contains(i))
					{
						str = "";

						if (i == 3) //Pet Keeper
						{
							PetKeeperAttachment petatt = (PetKeeperAttachment) XmlAttach.FindAttachment(from, typeof(PetKeeperAttachment));

							if (petatt != null)
							{
								if (petatt.Daemon)
									str = str + "D";
								if (petatt.Dragon)
									str = str + "Dr";
								if (petatt.Hiryu)
									str = str + "H";
								if (petatt.Merc)
									str = str + "M";
								if (petatt.Spider)
									str = str + "S";
								if (petatt.Golem)
									str = str + "G";
							}
						}
						else if (i == 6) //Handyman
							str += ((att != null) ? att.Craft.ToString() : "0") + "/200";
						else if (i == 7) //gadgeteer
							str += ((att != null) ? att.Craft.ToString() : "0") + "/400";
						else if (i == 8) //Workoholic
							str += ((att != null) ? att.Craft.ToString() : "0") + "/600";
						else if (i == 11) //Exterminator
							str += ((att != null) ? att.Exterminator.ToString() : "0") + "/1k";
						else if (i == 12) //Vampire Slayer
							str += ((att != null) ? att.VampSlayer.ToString() : "0") + "/1k";
						else if (i == 13) //Butcher
							str += ((att != null) ? att.Butcher.ToString() : "0") + "/1k";
						else if (i == 14) //Deratizator
							str += ((att != null) ? att.Deratizator.ToString() : "0") + "/1k";
						else if (i == 15) //Collector
							str += ((att != null) ? att.Collector.ToString() : "0") + "/10";
						else if (i == 16) //Harvester
							str += ((att != null) ? att.Collector.ToString() : "0") + "/20";
						else if (i == 17) //Gladiator
							str += ((att != null) ? att.PvP.ToString() : "0") + "/100";
						else if (i == 18) //Battlemaster
							str += ((att != null) ? att.PvP.ToString() : "0") + "/200";
						else if (i == 19) //Sailor
							str += ((att != null) ? att.Fishing.ToString() : "0") + "/25";
						else if (i == 20) //Sea-Dog
							str += ((att != null) ? att.Fishing.ToString() : "0") + "/50";
						else if (i == 25) //Sea-Lord
							str += ((att != null) ? att.Fishing.ToString() : "0") + "/100";
						else if (i == 26) //Seeker
							str += ((att != null) ? att.Collector.ToString() : "0") + "/100";
						else if (i == 27) //Tomb Raider
							str += ((arch != null) ? arch.Graverobbers.ToString() : "0") + "/100";
						else if (i == 28) //Archeologist
							str += ((arch != null) ? arch.Fragments.ToString() : "0") + "/200";
						else if (i == 29) //Treasure Hunter
							str += ((att != null) ? att.Treasure.ToString() : "0") + "/100";
						else if (i == 30) //Insane
							str += ((usp != null) ? usp.AllMaps.ToString() : "0") + "/1M";
						else if (i == 31) //Double Agent
							str += ((usp != null) ? usp.Soutez.ToString() : "0") + "/15";

						AddLabelCropped(184, 35 + (index * 22), 234, 21, 0, str);
					}

					if (ids.Contains(i))
					{
						AddButton(256, 35 + (index * 22), 0x15E1, 0x15E5, i + 1, GumpButtonType.Reply, 0);
						AddTooltip(3000187); //Save
					}

					++index;
				}
			}

			public override void OnResponse(NetState state, RelayInfo info)
			{
				Mobile from = state.Mobile;

				if (from == null)
					return;

				if (info.ButtonID > 0)
				{
					if (info.ButtonID == 5000)
						from.Title = null;
					else if (info.ButtonID < 3000 && PlayerTitles.HasTitle(from, (info.ButtonID - 1)))
					{
						from.Title = PlayerTitles.TitleName[ (info.ButtonID - 1) ];
						from.SendMessage("Nyni jsi {0} {1}", from.Name, from.Title);
					}
					else if (info.ButtonID > 2999 && PlayerTitles.CheckPrefix(from, (info.ButtonID - 3000)))
					{
						PlayerTitles.SetPrefix(from, (info.ButtonID - 3000));
						from.InvalidateProperties();
						from.SendMessage("Prefix nastaven");
					}
				}
			}
		}
	}
}