using System;
using System.Collections;
using Server;
using Server.Gumps;
using Server.Items;
using Server.Mobiles;
using Server.Network;
using Server.Engines.XmlSpawner2;

namespace Server
{
	public class PlayerTitles
	{
		public static string[] TitleName = new string[]
		{

			"the Dragonslayer", // 0
			",Bane of Ancient Dragon", // 1
			"the Loremaster", // 2
			"the Pet Keeper", // 3
			"the Gambler", // 4
			"the Jack-of-All-Trades", // 5
			"the Handyman", // 6
			"the Gadgeteer", // 7
			"the Workoholic", // 8
			"the Conqueror", // 9
			"the Conquistador", // 10
			"the Exterminator", // 11
			"the Vampire Slayer", // 12
			"the Butcher", // 13
			"the Deratizator", // 14
			"the Collector", // 15
			"the Harvester", // 16
			"the Gladiator", // 17
			"the Battlemaster", // 18
			"the Sailor", // 19
			"the Sea-Dog", // 20
			"from Pandemonium", // 21
			"the Merchant", // 22
			"the Undying", // 23
			",Knight of Virtue", // 24
			"the Sea Lord", // 25
			"the Seeker", // 26
			"the Tomb Raider", // 27
			"the Archeologist", // 28
			"the Treasure Hunter", // 29
			"the Insane", // 30
			"the Double Agent" // 31
		};

		public static string[] PrefixMale = new string[]
		{

			"Lord", // 0
			"Admiral", // 1
			"Baron", // 2
			"Marquis", // 3
			"Knight", // 4
			"Professor", // 5
			"Crusader", // 6
			"Samurai", // 7
			"Immigrant" // 8
		};

		public static string[] PrefixFemale = new string[]
		{

			"Lady", // 0
			"Admiral", // 1
			"Baroness", // 2
			"Marquise", // 3
			"Knight", // 4
			"Professor", // 5
			"Crusader", // 6
			"Samurai", // 7
			"Immigrant" // 8
		};

		public static bool HasTitle(Mobile from, int titleID)
		{
			TitlesAttachment att = GetTitleAttachment(from);

			if (att == null)
				return false;

			string[] split = att.Titles.Split('|');

			if (split.GetLength(0) > 0)
			{
				for (int i = 0; i < split.GetLength(0); ++i)
				{
					if (StrToInt(split[i]) == titleID)
					{
						return true;
					}
				}
			}

			return false;
		}

		public static ArrayList GetAllTitlesIDs(Mobile from)
		{
			ArrayList intVal = new ArrayList();
			TitlesAttachment att = GetTitleAttachment(from);

			if (att == null)
				return intVal;

			string[] split = att.Titles.Split('|');

			int splitedInt = -1;

			if (split.GetLength(0) > 0)
			{
				for (int i = 0; i < split.GetLength(0); ++i)
				{
					splitedInt = StrToInt(split[i]);

					if (splitedInt > -1)
					{
						intVal.Add(splitedInt);
					}
				}

				return intVal;
			}

			return intVal;
		}

		public static void AddTitle(Mobile from, int newTitleID)
		{
			if (HasTitle(from, newTitleID) || (from.Map == Map.Underworld && newTitleID != 31))
				return;

			TitlesAttachment att = GetTitleAttachment(from);

			if (att == null || newTitleID >= TitleName.GetLength(0))
				return;

			att.Titles += newTitleID.ToString() + "|";

			if (att.Owner is PlayerMobile)
			{
				from.SendMessage(34, "Ziskavas titul {0}", PlayerTitles.TitleName[ newTitleID ]);

				if (newTitleID == 8) //Workoholic
				{
					BaseClothing apron = new FullApron(2625);
					apron.BlessedFor = from;
					apron.Name = "Worcoholic's full apron";
					apron.Attributes.BonusHits = 20;
					apron.Attributes.BonusStr = 20;
					apron.Attributes.NightSight = 1;

					apron.SkillBonuses.SetValues(0, SkillName.Blacksmith, 10);
					apron.SkillBonuses.SetValues(1, SkillName.Tailoring, 10);
					apron.SkillBonuses.SetValues(2, SkillName.Fletching, 10);
					apron.SkillBonuses.SetValues(3, SkillName.Carpentry, 10);
					apron.SkillBonuses.SetValues(4, SkillName.Tinkering, 10);
					from.AddToBackpack(apron);

					BaseJewel bracelet = new SilverBracelet();
					bracelet.BlessedFor = from;
					bracelet.Hue = 2625;
					bracelet.Name = "Worcoholic's Bracelet";
					bracelet.Attributes.BonusStam = 20;
					bracelet.Attributes.BonusDex = 20;
					bracelet.Attributes.RegenHits = 5;

					bracelet.SkillBonuses.SetValues(0, SkillName.Alchemy, 10);
					bracelet.SkillBonuses.SetValues(1, SkillName.Inscribe, 10);
					bracelet.SkillBonuses.SetValues(2, SkillName.Cooking, 10);
					bracelet.SkillBonuses.SetValues(3, SkillName.ArmsLore, 10);
					bracelet.SkillBonuses.SetValues(4, SkillName.Cartography, 10);
					from.AddToBackpack(bracelet);
					from.SendMessage("Jako odmenu ziskavas zasteru a naramek.");
				}
				else if (newTitleID == 20) //Sea-Dog
				{
					from.AddToBackpack(new RecipeMagicalFishingPole());
					from.AddToBackpack(new SOSPiece(20));
					from.SendMessage("Jako odmenu ziskavas recept na vyrobu magickeho rybarskeho prutu a nekolik casti SOS zprav.");
				}
				else if (newTitleID == 2) //Loremaster
				{
					XmlQuestPoints p = (XmlQuestPoints)XmlAttach.FindAttachment(from, typeof(XmlQuestPoints));

					if (p != null)
					{
						p.Credits += 250;
						from.SendMessage("Jako odmenu ziskavas 250 quest kreditu pro nakup odmen.");
					}
				}
				else if (newTitleID == 23) //Undying
				{ }
				else if (newTitleID == 24) //,Knight of Virtue
				{
					from.AddToBackpack(new ScrollOfVirtue());
					from.SendMessage("Jako odmenu za titul ziskavas Scroll of Virtue.");
				}
				else if (newTitleID == 27) //Tomb Raider
				{
					from.AddToBackpack(new ArtifactFragment(10));
					from.SendMessage("Jako odmenu za titul ziskavas 10 fragmentu artefaktu.");
				}
				else if (newTitleID == 28) //Archeologist
				{
					ClothingSkillScroll css = new ClothingSkillScroll(SkillName.Forensics, 10.0);
					css.BlessedFor = from;
					from.AddToBackpack(css);
					from.SendMessage("Jako odmenu za titul ziskavas Clothing Skill Scroll +10 Forensics.");
				}
				else if (newTitleID == 29) //Treasure Hunter
				{
					UnbreakableLockpicks pick = new UnbreakableLockpicks();
					pick.BlessedFor = from;
					from.AddToBackpack(pick);
					from.SendMessage("Jako odmenu za titul ziskavas nezlomitelny paklic.");
				}
				else if (newTitleID == 31) //Double agent
				{
					BaseClothing cloak = new Cloak(1076);
					cloak.ItemID = 11013;
					cloak.BlessedFor = from;
					cloak.Name = from.RawName + "'s cloak";
					cloak.Attributes.BonusHits = 10;
					cloak.Attributes.NightSight = 1;
					cloak.BlessedFor = from;
					SecureStash.DropToStash(cloak, from);
					from.SendMessage("Odmena byla umistena do tve bezpecnostni truhly na zakladane (underworld)");
				}
				else
				{
					TokenCheck ch = new TokenCheck(250);
					ch.Name = "Sek na stribro za titul " + PlayerTitles.TitleName[ newTitleID ];
					from.AddToBackpack(ch);
					from.SendMessage("Jako odmenu ziskavas sek na 250 stribrnych minci.");
				}

				// Guilds.Guild.GiveXp(from, 1000);
			}
		}

		public static void TitleProgress(Mobile from, string what, int x)
		{
			if (XmlAttach.FindAttachment(from, typeof(TitleProgressAttachment)) == null)
				XmlAttach.AttachTo(from, new TitleProgressAttachment());

			TitleProgressAttachment att = (TitleProgressAttachment) XmlAttach.FindAttachment(from, typeof(TitleProgressAttachment));

			if (att != null && from != null && what != null)
			{
				if (x < 1)
					x = 1;

				what = what.ToLower();

				if (what == "craft")
				{
					att.Craft += x;
				}
				else if (what == "exterminator")
				{
					att.Exterminator += x;
				}
				else if (what == "vampslayer")
				{
					att.VampSlayer += x;
				}
				else if (what == "butcher")
				{
					att.Butcher += x;
				}
				else if (what == "deratizator")
				{
					att.Deratizator += x;
				}
				else if (what == "pvp")
				{
					att.PvP += x;
				}
				else if (what == "collector")
				{
					att.Collector += x;
				}
				else if (what == "fishing")
				{
					att.Fishing += x;
				}
				else if (what == "treasure")
				{
					att.Treasure += x;
				}

				from.SendMessage("Tituly: +{0} bod", x);
			}
		}

		public static TitlesAttachment GetTitleAttachment(Mobile from)
		{
			if (XmlAttach.FindAttachment(from, typeof(TitlesAttachment)) == null)
				XmlAttach.AttachTo(from, new TitlesAttachment());

			return (TitlesAttachment) XmlAttach.FindAttachment(from, typeof(TitlesAttachment));
		}

		public static void SetPrefix(Mobile from, int newPrefixID)
		{
			TitlesAttachment att = GetTitleAttachment(from);

			if (att == null || newPrefixID >= PrefixMale.GetLength(0))
				return;

			att.Prefix = newPrefixID;
		}

		public static bool CheckPrefix(Mobile from, int newPrefixID)
		{
			TitleProgressAttachment att = (TitleProgressAttachment) XmlAttach.FindAttachment(from, typeof(TitleProgressAttachment));

			if (att == null || newPrefixID >= PrefixMale.GetLength(0))
				return false;

			if (newPrefixID == 1 && att.Fishing < 250) //Admiral
				return false;
			else if (newPrefixID == 2 && att.Collector < 200) //Baron
				return false;
			else if (newPrefixID == 3) //Marquis
			{
				XmlQuestPoints p = (XmlQuestPoints)XmlAttach.FindAttachment(from, typeof(XmlQuestPoints));

				if (p == null || p.QuestsCompleted < 600)
					return false;
			}
			else if (newPrefixID == 4) //Knight
			{
				Item iring;
				if ((iring = from.FindItemOnLayer(Layer.Ring)) == null || !(iring is KnightsRing))
					return false;

				KnightsRing ring = (KnightsRing) iring;

				if (ring != null && (ring.Bonus < 10 || ring.BlessedFor != from))
					return false;
			}
			else if (newPrefixID == 5) //Profesor
			{
				Archeology a = (Archeology)XmlAttach.FindAttachment(from, typeof(Archeology));

				if (a == null || a.Artifacts < 25)
					return false;
			}
			else if (newPrefixID == 6) //Crusader
			{
				Item item;

				if (CrusadersShield.FullCrusadersSetPresent(from))
				{
					if (from.FindItemOnLayer(Layer.OneHanded) is CrusadersWarMace)
					{
						item = from.FindItemOnLayer(Layer.OneHanded);

						if (item.BlessedFor != from || ((CrusadersWarMace)item).Bonus < 10)
							return false;
					}

					if (from.FindItemOnLayer(Layer.TwoHanded) is CrusadersShield)
					{
						item = from.FindItemOnLayer(Layer.TwoHanded);

						if (item.BlessedFor != from || ((CrusadersShield)item).Bonus < 10)
							return false;
					}
				}
				else
					return false;
			}
			else if (newPrefixID == 7) //Samurai
				return Zanbato.HasFullSet(from);
			else if (newPrefixID == 8) //Immigrant
				return Multis.Deeds.HouseDeed.HasUWHouse(from);

			return true;
		}

		public static int StrToInt(string input)
		{
			// ToInt32 can throw FormatException or OverflowException.
			int numVal = -1;

			try
			{
				numVal = Convert.ToInt32(input);
			}
			catch (FormatException e)
			{
				numVal = -1;
			}
			catch (OverflowException e)
			{
				numVal = -1;
			}

			return numVal;
		}
	}
}