using System;
using Server;
using Server.Items;
using Server.Network;
using Server.Mobiles;

namespace Server.Engines.XmlSpawner2
{
	public class TitleProgressAttachment : XmlAttachment
	{
		private int m_Craft = 0;
		private int m_Exterminator = 0;
		private int m_VampSlayer = 0;
		private int m_Butcher = 0;
		private int m_Deratizator = 0;
		private int m_PvP = 0;
		private int m_Collector = 0;
		private int m_Fishing = 0;
		private int m_Treasure = 0;
		
		//Craft tituly
		[CommandProperty( AccessLevel.GameMaster )]
		public int Craft
		{
			get { return m_Craft; }
			set
			{
				m_Craft = value;
				
				if ( m_Craft > 199 && m_Craft < 400 )
					GiveTitle( 6 ); //the Handyman
				else if ( m_Craft > 399 && m_Craft < 600 )
					GiveTitle( 7 ); //the Gadgeteer
				else if ( m_Craft > 599 )
					GiveTitle( 8 ); //the Workoholic
			}
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int Exterminator
		{
			get { return m_Exterminator; }
			set
			{
				m_Exterminator = value;
				
				if ( m_Exterminator > 999 )
					GiveTitle( 11 ); //the Exterminator
			}
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int VampSlayer
		{
			get { return m_VampSlayer; }
			set
			{
				m_VampSlayer = value;
				
				if ( m_VampSlayer > 999 )
					GiveTitle( 12 ); //the Vampire Slayer
			}
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int Butcher
		{
			get { return m_Butcher; }
			set
			{
				m_Butcher = value;
				
				if ( m_Butcher > 999 )
					GiveTitle( 13 ); //the Butcher
			}
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int Deratizator
		{
			get { return m_Deratizator; }
			set
			{
				m_Deratizator = value;
				
				if ( m_Deratizator > 999 )
					GiveTitle( 14 ); //the Deratizator
			}
		}
		
		//PvP tituly
		[CommandProperty( AccessLevel.GameMaster )]
		public int PvP
		{
			get { return m_PvP; }
			set
			{
				m_PvP = value;
				
				if ( m_PvP > 100 && m_PvP < 200 )
					GiveTitle( 17 ); //the Gladiator
				else if ( m_PvP > 199 )
					GiveTitle( 18 ); //the Battlemaster
			}
		}
		
		//Collector tituly
		[CommandProperty( AccessLevel.GameMaster )]
		public int Collector
		{
			get { return m_Collector; }
			set
			{
				m_Collector = value;
				
				if ( m_Collector > 9 && m_Collector < 20 )
					GiveTitle( 15 ); //the Collector
				else if ( m_Collector > 19 && m_Collector < 100 )
					GiveTitle( 16 ); //the Harvester
				else if ( m_Collector > 99 )
					GiveTitle( 26 ); //the Seeker
			}
		}
		
		//Fishing tituly
		[CommandProperty( AccessLevel.GameMaster )]
		public int Fishing
		{
			get { return m_Fishing; }
			set
			{
				m_Fishing = value;
				
				if ( m_Fishing > 24 && m_Fishing < 50 )
					GiveTitle( 19 ); //the Sailor
				else if ( m_Fishing > 49 && m_Fishing < 100 )
					GiveTitle( 20 ); //the Sea-Dog
				else if ( m_Fishing > 99 )
					GiveTitle( 25 ); //the Sea Lord
			}
		}
		
		//Treasure
		[CommandProperty( AccessLevel.GameMaster )]
		public int Treasure
		{
			get { return m_Treasure; }
			set
			{
				m_Treasure = value;
				
				if ( m_Treasure > 99 )
					GiveTitle( 29 ); //the Treasure Hunter
			}
		}

		public TitleProgressAttachment(ASerial serial) : base(serial)
		{
		}

		[Attachable]
		public TitleProgressAttachment()
		{
			Name = "TitleProgress";
		}
		
		public void GiveTitle( int TitleID )
		{
			if ( Owner is PlayerMobile )
				PlayerTitles.AddTitle( (Mobile) Owner, TitleID );
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize(writer);

			writer.Write( (int) 1 );
			// version 1
			writer.Write(m_Treasure);
			// version 0
			writer.Write(m_Craft);
			writer.Write(m_Exterminator);
			writer.Write(m_VampSlayer);
			writer.Write(m_Butcher);
			writer.Write(m_Deratizator);
			writer.Write(m_PvP);
			writer.Write(m_Collector);
			writer.Write(m_Fishing);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			switch ( version )
			{
				case 1:
					{
          			m_Treasure = reader.ReadInt();
                  goto case 0;
					}
				case 0:
					{
          			m_Craft = reader.ReadInt();
          			m_Exterminator = reader.ReadInt();
          			m_VampSlayer = reader.ReadInt();
          			m_Butcher = reader.ReadInt();
          			m_Deratizator = reader.ReadInt();
          			m_PvP = reader.ReadInt();
          			m_Collector = reader.ReadInt();
          			m_Fishing = reader.ReadInt();
						break;
					}
			}
		}
	}
}
