using System;
using Server;
using Server.Items;
using Server.Network;
using Server.Mobiles;

namespace Server.Engines.XmlSpawner2
{
	public class TitlesAttachment : XmlAttachment
	{
		private string m_Titles;
		private int m_Prefix;

		[CommandProperty( AccessLevel.GameMaster )]
		public string Titles
		{
			get { return m_Titles; }
			set
			{
				m_Titles = value;
				
				if ( m_Titles == null )
					m_Titles = "";
			}
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int Prefix
		{
			get { return m_Prefix; }
			set
			{
				m_Prefix = value;
				
				if ( m_Titles == null )
					m_Prefix = 0;
			}
		}

		public TitlesAttachment(ASerial serial) : base(serial)
		{
		}

		[Attachable]
		public TitlesAttachment()
		{
			Name = "Tituly";
			Titles = "";
			Prefix = 0;
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize(writer);

			writer.Write( (int) 1 );
			
			writer.Write( (int) m_Prefix );
			// version 0
			writer.Write(m_Titles);
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			switch( version )
			{
				case 1:
					{
						m_Prefix = reader.ReadInt();
						goto case 0;
					}
				case 0:
					{
						m_Titles = reader.ReadString();
						break;
					}
			}
		}
	}
}
