using System;
using Server.Misc;
using Server.Gumps;
using Server.Mobiles;
using Server.Items;
using Server.Commands;
using Server.Targeting;
using Server.Network;

namespace Server.Commands
{
    public class TalentsCommand
    {
        public static void Initialize()
        {
            CommandSystem.Register("talenty", AccessLevel.Player, new CommandEventHandler(Talents_OnCommand));
        }

        public static void Register(string command, AccessLevel access, CommandEventHandler handler)
        {
            CommandSystem.Register(command, access, handler);
        }

        [Usage("talenty")]
        [Description("zobrazi talenty hrace")]
        public static void Talents_OnCommand(CommandEventArgs e)
        {
            e.Mobile.SendMessage("Zamer sebe nebo jineho hrace pro zobrazeni talentu");
            e.Mobile.Target = new InternalTarget();
        }

        private class InternalTarget : Target
        {
            public InternalTarget() : base(20, true, TargetFlags.None)
            {
            }

            protected override void OnTarget(Mobile from, object targeted)
            {
                if (targeted is PlayerMobile)
                {
                    PlayerMobile pm = (PlayerMobile)targeted;

                    if (from.HasGump(typeof(TalentGump)))
                        from.CloseGump(typeof(TalentGump));

                    from.SendGump(new TalentGump(from, pm));
                }
                else
                    from.SendMessage("Musis zamerit hrace");
            }
        }

        public class TalentGump : Gump
        {
            private Mobile m_From;
            private PlayerMobile m_Target;

            public TalentGump(Mobile from, PlayerMobile target) : base(300, 75)
            {
                m_From = from;
                m_Target = target;

                if (m_Target == null || m_From == null)
                    return;

                Closable = true;
                Disposable = true;
                Dragable = true;
                Resizable = false;
                AddPage(0);

                AddBackground(0, 0, 313, 470, 9200);
                AddBackground(315, 0, 313, 470, 9200);
                this.AddHtml(110, 5, 400, 25, String.Format("<center><basefont color=blue>TALENTY - {0}</center>", m_Target.RawName), (bool)true, (bool)false);

                int x = 0;
                int y = 0;
                int count = m_Target.Talents.Count;

                for (int i = 0; i < count; ++i)
                {
                    if (i + 1 > (count / 2))
                    {
                        x = 315;
                        y = i - (count / 2);
                    }
                    else
                        y = i;

                    PlayerMobile.TalentEntry e = (PlayerMobile.TalentEntry)m_Target.Talents[i];

                    AddBackground(30 + x, 35 + (y * 40), 186, 35, e.Enabled ? 9350 : 9300);
                    AddBackground(220 + x, 35 + (y * 40), 64, 35, e.Enabled ? 9350 : 9300);


                    if (i < 10 && (m_From.AccessLevel > AccessLevel.Player || m_Target == m_From))
                    {
                        AddButton(5 + x, 43 + (y * 40), (e.Enabled) ? 211 : 210, 211, i + 100, GumpButtonType.Reply, 0);

                        if (e.Enabled)
                            AddTooltip(1071022); //DISABLE IT!

                        AddButton(290 + x, 45 + (y * 40), 5601, 5605, i + 200, GumpButtonType.Reply, 0);
                    }

                    AddLabel(40 + x, 43 + (y * 40), 0, String.Format("{0}{1}", i < 10 ? PlayerMobile.TalentName[i] : "---", e.Level > 1 ? " [lvl " + e.Level.ToString() + "]" : ""));

                    if (m_From.AccessLevel > AccessLevel.Player)
                        AddTextEntry(225 + x, 43 + (y * 40), 50, 20, 0x480, i, e.Charges.ToString());
                    else
                        AddLabel(225 + x, 43 + (y * 40), 0, e.Charges.ToString()); //e.Charges.ToString("N0", Auberon.Chat.General.Nfi));
                }

                AddButton(555, 440, 2031, 2032, 1000, GumpButtonType.Reply, 0); //help
            }

            public override void OnResponse(NetState state, RelayInfo info)
            {
                if (m_From == null || m_From != state.Mobile || m_Target == null)
                    return;

                if (info.ButtonID > 0)
                {
                    if (info.ButtonID == 1000)
                    {
                        //HELP
                        m_From.LaunchBrowser("http://auberon.stranky.org/kompendium.php");
                        m_From.SendGump(new TalentGump(m_From, m_Target));
                    }
                    else if (info.ButtonID < 200)
                    {
                        PlayerMobile.TalentEntry e = (PlayerMobile.TalentEntry)m_Target.Talents[info.ButtonID - 100];

                        if (!e.Enabled && e.Charges < 1)
                        {
                            m_From.SendMessage(1161, "Pro zapnuti talentu musis talent nabit");
                            m_From.SendGump(new TalentGump(m_From, m_Target));
                            return;
                        }

                        if (m_From.AccessLevel < AccessLevel.GameMaster)
                        {
                            if (m_From != m_Target)
                                return;

                            if (!e.Enabled)
                            {
                                if (!m_From.Backpack.ConsumeTotal(typeof(TalentScroll), 1))
                                {
                                    m_From.SendMessage(1161, "Pro zapnuti talentu musis mit u sebe talentovy svitek");
                                    m_From.SendGump(new TalentGump(m_From, m_Target));
                                    return;
                                }

                                e.Enabled = true;
                            }
                            else
                                e.Enabled = false;
                        }
                        else
                        {
                            if (e.Enabled)
                                e.Enabled = false;
                            else
                                e.Enabled = true;
                        }

                        m_Target.SendMessage("Talent {0} byl {1}", PlayerMobile.TalentName[info.ButtonID - 100], e.Enabled ? "povolen" : "zakazan");
                        m_From.SendGump(new TalentGump(m_From, m_Target));
                    }
                    else if (info.ButtonID > 199)  //Charges
                    {
                        PlayerMobile.TalentEntry e = (PlayerMobile.TalentEntry)m_Target.Talents[info.ButtonID - 200];

                        if (e == null) return;

                        if (m_From.AccessLevel > AccessLevel.Player) //Uprava GM
                        {
                            TextRelay tr = info.GetTextEntry(info.ButtonID - 200);
                            int cnt = 0;

                            try
                            {
                                cnt = Convert.ToInt32(tr.Text, 10);
                            }
                            catch
                            {
                                m_From.SendMessage(1161, "Do pole vyber musis napsat pouze cisla 0 - 999999");
                                return;
                            }

                            e.Charges = cnt;
                            m_From.SendGump(new TalentGump(m_From, m_Target));
                        }
                        else  //Dobijeni
                        {
                            Type type = typeof(Gold);
                            string itemname = "zlataky";

                            switch (info.ButtonID - 200)
                            {
                                case 3: //balron
                                    type = typeof(Xanthos.Evo.RaelisDemonioDust);
                                    itemname = "demon dust";
                                    break;
                                case 4: //navnada
                                    type = typeof(PowderOfTranslocation);
                                    itemname = "powder of translocation";
                                    break;
                                case 5: //leceni
                                    type = typeof(Tokens);
                                    itemname = "stribrne mince";
                                    break;
                                case 6: //Improvizace
                                    type = typeof(Tokens);
                                    itemname = "stribrne mince";
                                    break;
                                case 7: //craft
                                    type = typeof(PowderOfTemperament);
                                    itemname = "powder of fortifying";
                                    break;
                            }

                            m_From.Target = new InternalTarget(e, m_From, m_Target, type, itemname);
                            m_Target.SendMessage("Zamer {0} pro dobiti talentu {1}", itemname, PlayerMobile.TalentName[info.ButtonID - 200]);
                        }
                    }
                }
            }

            private class InternalTarget : Target
            {
                private PlayerMobile.TalentEntry m_Entry;
                private Mobile m_From;
                private PlayerMobile m_Target;
                private Type m_Type;
                private string m_ItemName;

                public InternalTarget(PlayerMobile.TalentEntry entry, Mobile from, PlayerMobile target, Type type, string itemname) : base(-1, false, TargetFlags.None)
                {
                    m_Entry = entry;
                    m_From = from;
                    m_Target = target;
                    m_Type = type;
                    m_ItemName = itemname;
                }

                protected override void OnTarget(Mobile from, object targeted)
                {
                    if (m_Entry == null || m_From == null || m_Target == null || m_Type == null)
                        return;

                    if (targeted.GetType() == m_Type)
                    {
                        Item rechargeItem = (Item)targeted;
                        int amount = 0;

                        if (m_Type == typeof(PowderOfTemperament))
                            amount = ((PowderOfTemperament)rechargeItem).UsesRemaining;
                        else
                            amount = rechargeItem.Amount;

                        if (!rechargeItem.IsChildOf(m_From.Backpack))
                        {
                            m_From.SendMessage("Predmet musis mit v batohu");
                            m_From.Target = new InternalTarget(m_Entry, m_From, m_Target, m_Type, m_ItemName);
                            return;
                        }
                        else if (m_Entry.Charges + amount > 999999)
                        {
                            m_From.SendMessage("Maximalni mnozstvi dobiti je 999 999");
                            m_From.Target = new InternalTarget(m_Entry, m_From, m_Target, m_Type, m_ItemName);
                            return;
                        }

                        m_Entry.Charges += amount;
                        m_From.SendMessage("{0} pouziti bylo pridano do talentu", amount);
                        rechargeItem.Delete();

                        m_From.SendGump(new TalentGump(m_From, m_Target));
                    }
                    else
                    {
                        from.SendMessage("Musis zamerit {0}", m_ItemName);
                        m_From.Target = new InternalTarget(m_Entry, m_From, m_Target, m_Type, m_ItemName);
                    }
                }
            }
        }
    }
}