using System;
using Server.Network;
using Server.Misc;
using System.Collections;
using Server.Commands;

namespace Server.Commands
{
   public class UnblessCommand
   {
     public static void Initialize()
     {
  	  CommandSystem.Register( "unbless", AccessLevel.Player, new CommandEventHandler( Unbless_OnCommand ) );
  	  CommandSystem.Register( "u", AccessLevel.Player, new CommandEventHandler( Unbless_OnCommand ) );
     }
  
     public static void Register( string command, AccessLevel access, CommandEventHandler handler )
     {
  	  CommandSystem.Register( command, access, handler );
     }
  
  	   [Usage( "Unbless" )] 
      [Description( "Remove bless from player!")] 
     public static void Unbless_OnCommand( CommandEventArgs e )
     {
        if ( Server.Mobiles.PlayerMobile.UnderBlessTimer( e.Mobile ) )
        {
            Server.Mobiles.PlayerMobile.StopBlessTimer( e.Mobile, false );
        }
     }
   }
}