using System;
using System.Collections;
using Server.Items;
using Server.Guilds;

namespace Server.Mobiles
{
	public class SBUWProvisioner : SBInfo
	{
		private ArrayList m_BuyInfo = new InternalBuyInfo();
		private IShopSellInfo m_SellInfo = new InternalSellInfo();

		public SBUWProvisioner()
		{
		}

		public override IShopSellInfo SellInfo { get { return m_SellInfo; } }
		public override ArrayList BuyInfo { get { return m_BuyInfo; } }

		public class InternalBuyInfo : ArrayList
		{
			public InternalBuyInfo()
			{
				// Add( new GenericBuyInfo( typeof( TinkerTools ), 0, 20, 0x1EB8, 0 ) );
				// Add( new GenericBuyInfo( typeof( Shovel ), 0, 20, 0xF39, 0 ) );
				
				Add( new GenericBuyInfo( "Cechovni mince", typeof( CechovniMince ), 1000, 999, 0xEF0, 2544 ) );
				Add( new GenericBuyInfo( typeof( RecallRune ), 50, 25, 0x1F14, 1081, new object[] { true } ) );

				Add( new GenericBuyInfo( typeof( Arrow ), 5, 500, 0xF3F, 0 ) );
				Add( new GenericBuyInfo( typeof( Bolt ), 5, 500, 0x1BFB, 0 ) );
				
				Add( new GenericBuyInfo( "Reagenty po 100ks", typeof( BagOfReagents ), 100, 50, 0xE76, 83, new object[] { 100 } ) );
				
				Add( new GenericBuyInfo( typeof( Bottle ), 5, 500, 0xF0E, 0 ) );
				Add( new GenericBuyInfo( typeof( LesserHealPotion ), 12, 500, 0xF0C, 0 ) );
				Add( new GenericBuyInfo( typeof( RefreshPotion ), 12, 500, 0xF0B, 0 ) );
				Add( new GenericBuyInfo( typeof( LesserCurePotion ), 12, 500, 0xF07, 0 ) );

				Add( new GenericBuyInfo( typeof( Backpack ), 150, 20, 0x9B2, 0 ) );
				Add( new GenericBuyInfo( typeof( Bag ), 20, 20, 0xE76, 0 ) );
				
/* 				Add( new GenericBuyInfo( typeof( BlackPearl ), 5, 500, 0xF7A, 0 ) );
				Add( new GenericBuyInfo( typeof( Bloodmoss ), 5, 500, 0xF7B, 0 ) );
				Add( new GenericBuyInfo( typeof( Garlic ), 3, 500, 0xF84, 0 ) );
				Add( new GenericBuyInfo( typeof( Ginseng ), 3, 500, 0xF85, 0 ) );
				Add( new GenericBuyInfo( typeof( MandrakeRoot ), 3, 500, 0xF86, 0 ) );
				Add( new GenericBuyInfo( typeof( Nightshade ), 3, 500, 0xF88, 0 ) );
				Add( new GenericBuyInfo( typeof( SpidersSilk ), 3, 500, 0xF8D, 0 ) );
				Add( new GenericBuyInfo( typeof( SulfurousAsh ), 3, 500, 0xF8C, 0 ) );
 */				
				Add( new AnimalBuyInfo( 1, typeof( PackHorse ), 315, 3, 291, 0 ) );				
				Add( new GenericBuyInfo( typeof( Lantern ), 12, 5, 0xA25, 0 ) );
					
				Add( new GenericBuyInfo( typeof( BreadLoaf ), 100, 20, 0x103B, 0 ) );
				Add( new BeverageBuyInfo( typeof( Pitcher ), BeverageType.Water, 11, 20, 0x1F9D, 0 ) );
				
				Add( new GenericBuyInfo( "1047016", typeof( CommodityDeed ), 3, 100, 0x14F0, 0x47 ) );
				Add( new GenericBuyInfo( "1041280", typeof( InteriorDecorator ), 1000, 20, 0xFC1, 0 ) );
				Add( new GenericBuyInfo( typeof( ContractOfEmployment ), 452, 20, 0x14F0, 0 ) );

				Add( new GenericBuyInfo( typeof( Dices ), 29, 20, 0xFA7, 0 ) );
			}
		}

		public class InternalSellInfo : GenericSellInfo
		{
			public InternalSellInfo()
			{
				Add( typeof( Amber ), 5 );
				Add( typeof( Amethyst ), 7 );
				Add( typeof( Citrine ), 5 );
				Add( typeof( Diamond ), 10 );
				Add( typeof( Emerald ), 8 );
				Add( typeof( Ruby ), 7 );
				Add( typeof( Sapphire ), 8 );
				Add( typeof( StarSapphire ), 9 );
				Add( typeof( Tourmaline ), 3 );
				Add( typeof( WhitePearl ), 10 );
				Add( typeof( Tokens ), 10 );
			}
		}
	}
}
