using System;
using Server.Items;
using System.Collections;
using System.Collections.Generic;
using Server.Spells;
using Server.Engines.CannedEvil;
using Server.Network;

namespace Server.Mobiles
{
	public class Xabrix : BaseChampion
	{
		public override bool ClickTitle { get { return false; } }
		public override bool ShowFameTitle { get { return false; } }
		public override bool CanRummageCorpses { get { return true; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override Poison PoisonImmune { get { return Poison.Lethal; } }
		public override bool BleedImmune { get { return true; } }
		public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp
		public override bool AlwaysMurderer { get { return true; } }

		private DateTime m_Delay = DateTime.Now;
		private DateTime m_VortexDelay = DateTime.Now;
		private DateTime m_SummonDelay = DateTime.Now;

		public override ChampionSkullType SkullType { get { return ChampionSkullType.Greed; } }

		[Constructable]
		public Xabrix() : this (false, 3)
		{
		}

		[Constructable]
		public Xabrix(int range) : this (false, range)
		{
		}

		[Constructable]
		public Xabrix(bool ischampion, int range) : base(AIType.AI_Necromage, FightMode.Closest, ischampion, range)
		{
			Title = "the Corpsemaker";
			Name = "Xabrix";
			Body = 0x190;
			SpeechHue = Utility.RandomDyedHue();
			Hue = Utility.RandomSkinHue();
			// Utility.AssignRandomHair(this);
			// Utility.AssignRandomFacialHair(this, HairHue);

			DropMin = 6;
			DropMax = 6;
			DropType = ChampDrop.Gold;
			BonusLoot = "superpotion";
			BonusLootAmount = 1;

			SetStr( 216, 305 );
			SetDex( 96, 115 );
			SetInt( 1000, 1045 );

			SetHits( 2000 );

			SetDamage( 10, 20 );

			SetDamageType(ResistanceType.Cold, 70);
			SetDamageType(ResistanceType.Physical, 30);

			SetResistance(ResistanceType.Physical, 70, 75);
			SetResistance(ResistanceType.Fire, 70, 75);
			SetResistance(ResistanceType.Cold, 100);
			SetResistance(ResistanceType.Poison, 100);
			SetResistance(ResistanceType.Energy, 100);
			
			SetSkill(SkillName.Necromancy, 100.0);
			SetSkill(SkillName.SpiritSpeak, 100.0);
			SetSkill( SkillName.EvalInt, 75.0 );
			SetSkill( SkillName.Magery, 100.0 );
			SetSkill( SkillName.Meditation, 100.1, 101.0 );
			SetSkill( SkillName.MagicResist, 175.2, 200.0 );
			SetSkill( SkillName.Tactics, 90.1, 100.0 );
			SetSkill( SkillName.Wrestling, 75.1, 100.0 );
			SetSkill(SkillName.Poisoning, 80.5);

			int Barva = Utility.RandomNeutralHue();
			BoneChest chest = new BoneChest();
			chest.Hue = Barva;
			chest.Movable = false;
			AddItem(chest);
			BoneArms arms = new BoneArms();
			arms.Hue = Barva;
			arms.Movable = false;
			AddItem(arms);
			BoneGloves gloves = new BoneGloves();
			gloves.Hue = Barva;
			gloves.Movable = false;
			AddItem(gloves);
			BoneLegs legs = new BoneLegs();
			legs.Hue = Barva;
			legs.Movable = false;
			AddItem(legs);
			BoneHelm helm = new BoneHelm();
			helm.Hue = Barva;
			helm.Movable = false;
			AddItem(helm);

			Necklace necklace = new Necklace();
			necklace.Hue = 2552;
			necklace.Movable = false;
			AddItem(necklace);

			Item book = new NecromancerSpellbook((UInt64)0xFFFF);
			book.Hue = 2552;
			book.Movable = false;
			AddItem(book);

			Cloak cloak = new Cloak();
			cloak.Hue = 2552;
			cloak.Movable = false;
			AddItem(cloak);

			Kilt kilt = new Kilt();
			kilt.Hue = 2552;
			kilt.Movable = false;
			AddItem(kilt);

			Sandals sandals = new Sandals();
			sandals.Hue = 2552;
			sandals.Movable = false;
			AddItem(sandals);

			Fame = 10000;
			Karma = -15000;

			VirtualArmor = 50;

			PackReg(60, 100);
		}

		public override bool OnBeforeDeath()
		{
			Server.Regions.KhaldunRegion.DropHealthOrb(this);
			Server.Regions.KhaldunRegion.DropHealthOrb(this);

			return base.OnBeforeDeath();
		}

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			if (typ == 2)
				amount = 0;

			base.OnDamage(amount, from, willKill, typ);

			if (from == null)
				return;

			if (this.Hits > (this.HitsMax * 90) / 100)
				return;

			if (DateTime.Now > m_VortexDelay && this.Hits < (this.HitsMax * 70) / 100)
			{
				Server.Engines.XmlSpawner2.FlareVortex vortex = new Server.Engines.XmlSpawner2.FlareVortex();
				vortex.MoveToWorld(TavaraSewel.GetSpawnPosition(from.Location, from.Map, 10), from.Map);
				m_VortexDelay = DateTime.Now + TimeSpan.FromSeconds(120.0);
				Effects.PlaySound(this.Location, this.Map, this.GetAngerSound());
				Say("By fire be purged!");
			}

			if (Utility.RandomDouble() < 0.1)
				Utilitky.CorpseExplosion(from, this);

			if(DateTime.Now > m_Delay)
			{
				m_Delay = DateTime.Now + TimeSpan.FromSeconds(20.0);

				BaseCreature summon = (BaseCreature) new Zombie();

				if (summon == null)
					return;

				summon.Name = "a flesh golem";
				summon.Body = 304;
				summon.BaseSoundID = 684;
				summon.Hue = 0;
				summon.Combatant = from;
				summon.SetHits(150);
				summon.SetDamage(3, 5);

				summon.MoveToWorld(TavaraSewel.GetSpawnPosition(from.Location, from.Map, 6), from.Map);

				Timer.DelayCall(TimeSpan.FromSeconds(5.0), new TimerStateCallback(SummonKill), new object[] { summon, from });
			}

			if(DateTime.Now > m_SummonDelay)
			{
				m_SummonDelay = DateTime.Now + TimeSpan.FromSeconds(60.0);
				FixedParticles(0x375A, 1, 17, 0x7DA, 0x960, 0x3, EffectLayer.Waist);
				Effects.PlaySound(this.Location, this.Map, this.GetAngerSound());
				Say("Kal Xen Bal Beh");
				
				Revenant rev = new Revenant(this, from, TimeSpan.FromSeconds(120.0));

				if (rev.Weapon is Halberd)
				{
					((Item)rev.Weapon).Delete();

					Item weap = new Bow();
					weap.Movable = false;
					weap.Hue = 997;
					rev.AddItem(weap);
				}
				
				rev.Name = "a dark archer";
				rev.RangeFight = 8;
				rev.SetSkill( SkillName.Archery, 100.0 );
				rev.SetSkill( SkillName.Anatomy, 100.0 );
				rev.MoveToWorld(TavaraSewel.GetSpawnPosition(from.Location, from.Map, 8), from.Map);
				rev.FixedParticles(0x373A, 1, 15, 9909, EffectLayer.Waist);
				rev.PlaySound(0x81);
				
				Server.Regions.KhaldunRegion.DropHealthOrb(rev);
			}
		}

		#region Effects
		private void SummonKill(object state)
		{
			object[] args = (object[])state;
			BaseCreature summon = (BaseCreature) args[0];

			if (summon == null || summon.Deleted)
				return;

			if (this.Deleted)
			{
				summon.Delete();
				return;
			}

			summon.Kill();
			
			if (summon.Corpse != null)
			{
				List<Item> items = summon.Corpse.Items;

				if (items.Count > 0)
				{
					for (int i = items.Count - 1; i >= 0; --i)
					{
						if (i >= items.Count)
							continue;

						if (items[i] != null)
							items[i].Delete();
					}
				}
			}

			this.PlaySound(Utility.RandomList(1049, 1050, 1066, 1068, 1073, 1075, 1085, 1086));
			Timer.DelayCall(TimeSpan.FromSeconds(2.0), new TimerStateCallback(ExplodeCorpse), new object[] { (Mobile) args[1] });
		}

		private void ExplodeCorpse(object state)
		{
			object[] args = (object[])state;

			if (this.Deleted)
				return;

			Utilitky.CorpseExplosion((Mobile) args[0], this);
		}

		#endregion

		public Xabrix(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0); // version
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			Hits = HitsMax;
			Blessed = false;
		}
	}
}