using System;
using System.Collections;
using Server;
using Server.Items;
using Server.Gumps;
using Server.Mobiles;
using Server.Network;
using Server.Engines.XmlSpawner2;

namespace Server.Items
{
	public class SkillSetStone : Item
	{
		public void EndStoneLock(object state)
		{
			((Mobile)state).EndAction(typeof(SkillSetStone));
		}

		public override bool DisplayWeight { get { return false; } }

		[Constructable]
		public SkillSetStone() : base(4484)
		{
			Name = "Kamen dovednosti";
			Movable = false;
			Hue = 2635;
		}

		public SkillSetStone(Serial serial) : base(serial)
		{
		}

		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			list.Add("Nastaveni novych skillu a statu pro Underworld");
		}

		public override void OnDoubleClick(Mobile from)
		{
			if (!from.CanBeginAction(typeof(SkillSetStone)))
			{
				from.SendLocalizedMessage(1074882, "20"); // You must wait ~1_val~ seconds for this to recharge.
				return;
			}

			if (!from.InRange(this.GetWorldLocation(), 3))
				from.SendLocalizedMessage(502138);
			else
			{
				SkillsBackupAttachment att = (SkillsBackupAttachment) XmlAttach.FindAttachment(from, typeof(SkillsBackupAttachment));

				if (att == null)
					from.SendMessage("Kamen nemuzes pouzit. Chyba 01. Kontaktuj GM.");
				else
				{
					if(!from.HasGump(typeof(InternalGump)))
						from.SendGump(new InternalGump(from));

					from.BeginAction(typeof(SkillSetStone));
					Timer.DelayCall(TimeSpan.FromSeconds(20.0), new TimerStateCallback(EndStoneLock), from);
				}
			}
		}

		private class InternalGump : Gump
		{
			public InternalGump(Mobile from) : base(200, 120)
			{
				if (from == null)
					return;

				this.Closable = false;
				this.Disposable = true;
				this.Dragable = true;
				this.Resizable = false;

				this.AddPage(0);
				this.AddBackground(0, 0, 600, 555, 9200);
				this.AddBackground(5, 30, 590, 410, 9350);
				this.AddBackground(5, 440, 100, 110, 9350);
				this.AddBackground(104, 440, 490, 110, 9350);
				this.AddLabel(10, 10, 1152, @"NASTAVENI SKILLU A STATU:");
				this.AddButton(520, 5, 241, 243, 0, GumpButtonType.Reply, 0); //Cancel
				this.AddButton(520, 520, 238, 240, 1, GumpButtonType.Reply, 0); //Apply
				this.AddHtml(110, 445, 405, 100, @"<basefont color=black>Skills cap (maximalni soucet skillu): 700<br>Stats cap (soucet statu): 250
				Jednotlivy skill muze mit hodnotu 0-100
				Jednotlivy stat muze mit hodnotu 10-130
				Skilly a staty si zde muzes menit neomeze.
				Odchodem z mapy Underground se tyto skilly zrusi a vrati se ti tve puvodni.", false, true);

				//SKILLY START
				int x = 0;
				int y = 0;

				for (int i = 0;i<48;i++)
				{
					this.AddLabel(x+10, y+35, 0, from.Skills[i].Name);
					this.AddTextEntry(x+150, y+35, 46, 20, 1152, i+10, from.Skills[i].Base.ToString("F0"));
					y += 25;

					if (i == 15)
					{
						y = 0;
						x = 195;
					}
					else if (i == 31)
					{
						y = 0;
						x = 390;
					}
				}

				//SJILLY END

				//STATY START
				this.AddLabel(10, 450, 0, @"STR:");
				this.AddLabel(10, 475, 0, @"DEX:");
				this.AddLabel(10, 500, 0, @"INT:");
				this.AddLabel(10, 525, 0, @"CAP: 250");
				this.AddTextEntry(50, 450, 46, 20, 1152, 1000, from.RawStr.ToString());
				this.AddTextEntry(50, 475, 46, 20, 1152, 1001, from.RawDex.ToString());
				this.AddTextEntry(50, 500, 46, 20, 1152, 1002, from.RawInt.ToString());
				//STATY END
			}

			public override void OnResponse(NetState sender, RelayInfo info)
			{
				Mobile from = sender.Mobile;

				if (from == null)
					return;

				if(info.ButtonID == 1)
				{
					SkillsBackupAttachment att = (SkillsBackupAttachment) XmlAttach.FindAttachment(from, typeof(SkillsBackupAttachment));

					if (att == null) //Hrac musi mit attach any si nezmenil sve normal skilly
						return;

					ArrayList skillsArray = new ArrayList();
					int skillsum = 0;

					for (int i = 0;i<48;i++)
					{
						int sk = CheckTextEntry(info.GetTextEntry(i+10), true);
						skillsum += sk;
						skillsArray.Add(sk);
					}

					int str = CheckTextEntry(info.GetTextEntry(1000), false);
					int dex = CheckTextEntry(info.GetTextEntry(1001), false);
					int intel = CheckTextEntry(info.GetTextEntry(1002), false);
					// int skillsum = skillsArray.Sum();

					if (skillsum > 700)
					{
						from.SendMessage("Soucet tebou vybranych skillu je {0} (maximum je 700)", skillsum);
					}

					if ((str + dex + intel) > 250)
					{
						from.SendMessage("Soucet tebou vybranych statu je {0} (maximum je 250)", (str + dex + intel));
					}

					// from.SendMessage("skillsArray.Count {0}", skillsArray.Count);

					if((str + dex + intel) > 250 || skillsum > 700)
						return;

					for (int i = 0; i < skillsArray.Count; i++)
					{
						// double sk = Convert.ToDouble(skillsArray[i]);
						from.Skills[i].Base = Convert.ToDouble(skillsArray[i]);
						// from.SendMessage("{0}. {1} -{2}", i, sk, sk.GetType());
					}

					from.RawStr = str;
					from.RawDex = dex;
					from.RawInt = intel;
				}
			}

			private static int CheckTextEntry(TextRelay tr, bool skill)
			{
				int trValue = 0;

				try
				{
					trValue = Convert.ToInt32(tr.Text, 10);
				}
				catch
				{
					return 0;
				}

				if(skill)
				{
					if (trValue < 0)
						return 0;
					else if (trValue > 100)
						return 100;
				}
				else
				{
					if (trValue < 10)
						return 10;
					else if (trValue > 130)
						return 130;
				}

				return trValue;
			}
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0); // version
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
		}
	}
}