using System;
using System.Collections;
using System.Collections.Generic;
using Server;
using Server.Items;
using Server.Network;
using Server.Mobiles;

namespace Server.Engines.XmlSpawner2
{
	public class SkillsBackupAttachment : XmlAttachment
	{
		private int m_RawStr = 0;
		private int m_RawDex = 0;
		private int m_RawInt = 0;
		private int m_StatCap = 0;
		private int m_SkillsCap;

		private List<SkillBackup> m_BackupList = new List<SkillBackup>();

		//Craft tituly
		[CommandProperty(AccessLevel.GameMaster)]
		public int RawStr { get { return m_RawStr; } set { m_RawStr = value; } }

		[CommandProperty(AccessLevel.GameMaster)]
		public int RawDex { get { return m_RawDex; } set { m_RawDex = value; } }

		[CommandProperty(AccessLevel.GameMaster)]
		public int RawInt { get { return m_RawInt; } set { m_RawInt = value; } }

		[CommandProperty(AccessLevel.GameMaster)]
		public int StatCap { get { return m_StatCap; } set { m_StatCap = value; } }

		[CommandProperty(AccessLevel.GameMaster)]
		public int SkillsCap { get { return m_SkillsCap; } set { m_SkillsCap = value; } }

		public SkillsBackupAttachment(ASerial serial) : base(serial)
		{
		}

		[Attachable]
		public SkillsBackupAttachment()
		{
			Name = "zaloha skillu";
		}

		public override void OnAttach()
		{
			base.OnAttach();

			if(AttachedTo is PlayerMobile)
			{
			}
			else if(AttachedTo is Item)
			{
				// dont allow item attachments
				Delete();
			}
		}

		public void DoBackup()
		{
			Mobile from = (Mobile) AttachedTo;

			for (int i = 0;i<from.Skills.Length;i++)
			{
				m_BackupList.Add(new SkillBackup(from.Skills[i].Base, from.Skills[i].Cap, (int) from.Skills[i].Lock));
			}

			//Debug
			// for(int i = 0; i < m_BackupList.Count; i++)
			// {
				// SkillBackup sk = m_BackupList[i];
				// from.SendMessage("{0}. base {1}, lock {2} cap {3}", i, sk.Base, sk.Lock, sk.Cap);
			// }

			m_SkillsCap = from.SkillsCap;
			m_RawStr = from.RawStr;
			m_RawDex = from.RawDex;
			m_RawInt = from.RawInt;
			m_StatCap = from.StatCap;

			//vynulovani skillu hrace
			for (int i = 0;i<from.Skills.Length;i++)
			{
				from.Skills[i].Base = 0;
				from.Skills[i].SetLockNoRelay(SkillLock.Locked);
				from.Skills[i].Cap = 100.0;
			}

			from.SkillsCap = 7000;
			from.RawStr = 10;
			from.RawDex = 10;
			from.RawInt = 10;
			from.StatCap = 250;
		}

		public void DoRestore()
		{
			if (m_BackupList != null && m_BackupList.Count > 0)
			{
				Mobile from = (Mobile) AttachedTo;

				from.SkillsCap = m_SkillsCap;
				from.StatCap = m_StatCap;
				from.RawStr = m_RawStr;
				from.RawDex = m_RawDex;
				from.RawInt = m_RawInt;

				for(int i = 0; i < m_BackupList.Count; i++)
				{
					SkillBackup sk = m_BackupList[i];
					from.Skills[i].Base = sk.Base;
					from.Skills[i].SetLockNoRelay((SkillLock) sk.Lock);
					from.Skills[i].Cap = sk.Cap;
				}
			}

			Delete();
		}

		// public override void OnReattach()
		// {
		// base.OnReattach();

		// Delete();
		// }

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 1);
			// version 1
			writer.Write(m_RawStr);
			// version 0
			writer.Write(m_RawDex);
			writer.Write(m_RawInt);
			writer.Write(m_StatCap);
			writer.Write((int)m_SkillsCap);

			if(m_BackupList == null)
			{
				writer.Write((int)0);
			}
			else
			{
				int skillsCount = m_BackupList.Count;

				writer.Write((int)skillsCount);

				if(skillsCount > 0)
				{
					for(int i = 0; i < skillsCount; i++)
					{
						SkillBackup sk = m_BackupList[i];
						writer.Write((double) sk.Base);
						writer.Write((double) sk.Cap);
						writer.Write((int) sk.Lock);
					}
				}
			}
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			switch (version)
			{
				case 1:
				{
					m_RawStr = reader.ReadInt();
					goto case 0;
				}

				case 0:
				{
					m_RawDex = reader.ReadInt();
					m_RawInt = reader.ReadInt();
					m_StatCap = reader.ReadInt();
					m_SkillsCap = reader.ReadInt();

					int skillsCount = reader.ReadInt();

					if(skillsCount > 0)
					{
						m_BackupList = new List<SkillBackup>();

						for(int i = 0; i < skillsCount; i++)
						{
							double rb = reader.ReadDouble();
							double rc = reader.ReadDouble();
							int rl = reader.ReadInt();
							m_BackupList.Add(new SkillBackup(rb, rc, rl));
						}
					}

					break;
				}
			}
		}

		public class SkillBackup
		{
			private double m_Base;
			private double m_Cap;
			private int m_Lock;

			public double Base { get { return m_Base; } set { m_Base = value; } }
			public double Cap { get { return m_Cap; } set { m_Cap = value; } }
			public int Lock { get { return m_Lock; } set { m_Lock = value; } }

			public SkillBackup(double basev, double cap, int locke)
			{
				m_Base = basev;
				m_Cap = cap;
				m_Lock = locke;
			}
		}
	}
}