using System;
using Server;
using Server.Items;
using System.Collections;
using System.Collections.Generic;

namespace Server.Mobiles
{
	public class StrongerMonster
	{
		public static void Convert(BaseCreature bc, Point3D location, Map m)
		{
			if (bc is Harrower || bc is BaseVendor || bc is BaseEscortable || bc is Clone)
				return;

			Regions.UnderworldRegion reg = (Regions.UnderworldRegion) Region.Find(location, m).GetRegion(typeof(Regions.UnderworldRegion));
			int buff = 120;

			if (reg != null)
			{
				buff = reg.Difficulty;
			}

			//          bc.Name = String.Format( "{0} ({1})", bc.Name, reg.Difficulty);

			if (bc.HitsMaxSeed >= 0)
				bc.HitsMaxSeed = AOS.Scale(bc.HitsMaxSeed, buff); //(int)( bc.HitsMaxSeed * HitsBuff );

			// bc.RawStr = AOS.Scale(bc.RawStr, buff);
			// bc.RawDex = AOS.Scale(bc.RawDex, buff);
			bc.RawInt = AOS.Scale(bc.RawInt, buff);

			bc.Hits = bc.HitsMax;
			bc.Mana = bc.ManaMax;
			bc.Stam = bc.StamMax;

/* 			for(int i = 0; i < bc.Skills.Length; i++)
			{
				Skill skill = (Skill)bc.Skills[i];

				if (skill.Base > 0.0)
					skill.Base *= ((double) buff) / 100.0;
			}
 */
			bc.DamageMin = AOS.Scale(bc.DamageMin, buff);
			bc.DamageMax = AOS.Scale(bc.DamageMax, buff);

			// Item tal = bc.FindItemOnLayer(Layer.Talisman) as Item;

			// if (tal != null)
			// tal.Delete();

			//Vyprazdneni baglu
			if (bc.Backpack != null)
			{
				List<Item> items = bc.Backpack.Items;

				if (items.Count > 0)
				{
					for (int i = items.Count - 1; i >= 0; --i)
					{
						if (i >= items.Count || AllowedLootItem(items[i]))
							continue;

						if (items[i] != null)
							items[i].Delete();
					}
				}
			}

			//Equipnute veci movable false
			for (int i = 0; i < bc.Items.Count; ++i)
			{
				Item item = bc.Items[i];

				if (item == null || item.Deleted)
					continue;

				if (!Gumps.EquipGump.ValidateLayer((int)item.Layer))
					continue;

				if (item is BaseWeapon)
				{
					((BaseWeapon)item).IsUWItem = true;
					((BaseWeapon)item).Identified = true;
				}
				else if (item is BaseArmor)
				{
					((BaseArmor)item).IsUWItem = true;
					((BaseArmor)item).Identified = true;
				}
				else
					item.Movable = false;
			}
		}

		public static bool AllowedLootItem(Item item)
		{
			if (item == null)
				return false;

			if (item is Arrow || item is Bolt || item is Bandage || item is Bandage
				 || item is BlackPearl || item is Bloodmoss || item is Garlic || item is Ginseng
				 || item is MandrakeRoot || item is Nightshade || item is SulfurousAsh || item is SpidersSilk
				 || item is Amber || item is Amethyst || item is Citrine || item is Diamond || item is Tourmaline
				 || item is Emerald || item is Ruby || item is Sapphire || item is StarSapphire)
			return true;

			return false;
		}
	}
}