using System;
using System.Xml;
using Server;
using Server.Mobiles;

namespace Server.Regions
{
	public class UnderworldRegion : DungeonRegion
	{
		public virtual string EnterMessage { get { return null; } }
		public virtual int EnterSound { get { return 0; } }

		private int m_Difficulty;

		public int Difficulty { get { return m_Difficulty; } set { m_Difficulty = value; } }

		public UnderworldRegion(XmlElement xml, Map map, Region parent) : base(xml, map, parent)
		{
			ReadInt32(xml["Difficulty"], "obtiznost", ref m_Difficulty, false);
		}

		public override void OnEnter(Mobile m)
		{
			base.OnEnter(m);

			if (m.Player && m.Alive/*  && m.AccessLevel == AccessLevel.Player */)
			{
				if (EnterSound > 0)
					m.PlaySound(EnterSound);

				if (!String.IsNullOrEmpty(EnterMessage))
					m.SendMessage(EnterMessage);

				m.SendMessage(33, "Vstupujes do {0}", this.Name);
				m.SendMessage(33, "Obtiznost: {0}", m_Difficulty);
			}
		}

		public override bool OnBeginSpellCast(Mobile m, ISpell s)
		{
			if (m.AccessLevel > AccessLevel.Player || !m.Player /* || ((Spell)s).Scroll != null */)
				return base.OnBeginSpellCast(m, s);

			if (s is Spells.Sixth.MarkSpell || s is Spells.Chivalry.PaladinSpell || s is Spells.Necromancy.NecromancerSpell || s is Spells.Ninjitsu.NinjaSpell || s is Spells.SamuraiMove ||
				s is Spells.Bushido.SamuraiSpell || s is Spells.NinjaMove || s is Spells.Spellweaving.ArcanistSpell || s is Spells.Second.MagicTrapSpell || s is Spells.Third.MagicLockSpell)
			{
				m.SendLocalizedMessage(501802); // Thy spell doth not appear to work...
				return false;
			}

			return base.OnBeginSpellCast(m, s);
		}

		public override bool CanUseStuckMenu(Mobile m)
		{
			return false;
		}
	}

	public class UnderworldOutdoor : UnderworldRegion
	{
		public UnderworldOutdoor(XmlElement xml, Map map, Region parent) : base(xml, map, parent)
		{
		}

		public override void AlterLightLevel(Mobile m, ref int global, ref int personal)
		{
			global = LightCycle.NightLevel;
		}

		public override bool AllowHousing(Mobile from, Point3D p)
		{
			return true;
		}
	}

	public class UnderworldDungeon : UnderworldRegion
	{
		public override int EnterSound { get { return 257; } }

		public UnderworldDungeon(XmlElement xml, Map map, Region parent) : base(xml, map, parent)
		{
		}
	}
}