using System;
using Server;
using Server.Network;
using Server.Mobiles;
using System.Collections;
using Server.Gumps;
using Server.Engines.XmlSpawner2;

namespace Server.Items
{
	public class UnderworldTeleporter : PandemoniumTeleporter
	{
		public override bool OnMoveOver(Mobile m)
		{
			if (this.Active)
			{
				if (!this.Creatures && !m.Player)
					return true;

				if (m is PlayerMobile && m.AccessLevel == AccessLevel.Player)
				{
					if (((PlayerMobile)m).Young)
						return true;
					
					SkillsBackupAttachment att = (SkillsBackupAttachment) XmlAttach.FindAttachment(m, typeof(SkillsBackupAttachment));

					if (att != null && this.Map != Map.Underworld && this.MapDest == Map.Underworld) //Hrac mimo UW mapu by nemel mit attachment, proto ho smazeme a vratime mu puvodni skilly
					{
						att.DoRestore();
						return false;
					}

					if (m.BeginAction(this))
					{
						m.CloseGump(typeof(ConfirmGump));
						m.SendGump(new ConfirmGump(m, this));

						Timer.DelayCall(TimeSpan.FromSeconds(5.0), new TimerStateCallback(EndMessageLock), m);
					}

					return false;
				}

				StartTeleport(m);
				return false;
			}

			return true;
		}

		private void Confirmed(Mobile m)
		{
			if (this.Map != Map.Underworld && this.MapDest == Map.Underworld)//Prichod
			{
				m.EndAction(this);
				base.OnMoveOver(m); //Kontrola veci 
			}
			else if (this.Map == Map.Underworld && this.MapDest != Map.Underworld)//Odchod
				StartTeleport(m); //Odchod mozny s vecmi
			else
				m.SendMessage("Chyba 03. Kontaktuj GM.");
		}

		public override void StartTeleport(Mobile m)
		{
			if (m.AccessLevel > AccessLevel.Player)
			{
				base.StartTeleport(m);
				return;
			}

			SkillsBackupAttachment att = (SkillsBackupAttachment) XmlAttach.FindAttachment(m, typeof(SkillsBackupAttachment));

			if (this.Map != Map.Underworld && this.MapDest == Map.Underworld)//Prichod
			{
				if (att == null)
				{
					XmlAttach.AttachTo(m, new SkillsBackupAttachment());
					att = (SkillsBackupAttachment) XmlAttach.FindAttachment(m, typeof(SkillsBackupAttachment));

					if (att != null)
						att.DoBackup();
				}
				else
				{
					m.SendMessage("Chyba 01. Kontaktuj GM.");
					return;
				}
			}
			else if (this.Map == Map.Underworld && this.MapDest != Map.Underworld)//Odchod
			{
				if (att != null)
				{
					att.DoRestore();
				}
				else
				{
					m.SendMessage("Chyba 04. Kontaktuj GM.");
					return;
				}
			}
			else
			{
				m.SendMessage("Chyba 02. Kontaktuj GM.");
				return;
			}

			base.StartTeleport(m);
		}

		[Constructable]
		public UnderworldTeleporter()
		{
			Visible = false;
			Name = "Underworld Teleporter";
			SoundID = 0x1FC;
		}

		private class ConfirmGump : Gump
		{
			private UnderworldTeleporter m_Tele;

			public ConfirmGump(Mobile from, UnderworldTeleporter tele) : base(100, 150)
			{
				if (tele == null || from == null) return;
				m_Tele = tele;

				AddPage(0);

				AddBackground(0, 0, 420, 400, 5054);
				AddBackground(10, 10, 400, 380, 3000);

				AddHtml(20, 40, 380, 260, @"<basefont color=black>" + 
				((m_Tele.Map != Map.Underworld) ? @"Vstupujes na mapu Underworld<br>Pokud chces vstoupit, nesmis mit u sebe zadne veci.
				Tvoje skilly a staty budou ulozeny a po teleportaci si budes moci nastavit staty a skilly nove.
				Pozor, v Underworldu funguji veci jinak nez jsi zvykly/a<br><br>Opravdu si prejes pokracovat?"
				: @"Odchazis z mapy Underworld<br>Tve skilly a staty budou navraceny na puvodni hodnoty. Veci co mas u sebe si muzes odnest, ale pozor, jiz se s nimi nemuzes vratit
				<br>Opravdu si prejes pokracovat?"), false, true);

				AddHtmlLocalized(55, 310, 290, 20, 1011012, false, false); // CANCEL
				AddButton(20, 310, 4005, 4007, 0, GumpButtonType.Reply, 0);

				AddHtmlLocalized(55, 340, 290, 40, 1011011, false, false); // CONTINUE
				AddButton(20, 340, 4005, 4007, 1, GumpButtonType.Reply, 0);
			}

			public override void OnResponse(NetState sender, RelayInfo info)
			{
				Mobile from = sender.Mobile;

				if (m_Tele == null || m_Tele.Deleted)
					return;

				switch(info.ButtonID)
				{
					case 0:
					{
						break;
					}

					case 1:
					{
						m_Tele.Confirmed(from);
						break;
					}

					case 2:
					{
						// from.CloseGump(typeof(LookAtGump));
						// from.SendGump(new LookAtGump(from, m_Golem));
						break;
					}
				}
			}
		}

		public UnderworldTeleporter(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int)0); // version
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			int version = reader.ReadInt();
		}
	}
}