using System;
using System.Collections;
using System.Collections.Generic;
using Server;
using Server.Items;
using Server.Network;
using Server.Mobiles;
using Server.Engines.XmlSpawner2;

namespace Server.Misc
{
	public class Uspechy
	{
		public static void CheckNewRound()
		{
			DateTime date = DateTime.Now;

			if (date.DayOfWeek.Equals(DayOfWeek.Thursday) && date.TimeOfDay >= new TimeSpan(17, 00, 00) && date.TimeOfDay <= new TimeSpan(17, 20, 00))
			{
				Dictionary<Mobile, int> m_Vysledky = new Dictionary<Mobile, int>();

				foreach (XmlAttachment i in XmlAttach.Values)
				{
					if (i != null && !i.Deleted && i is UspechyAttachment)
					{
						UspechyAttachment a = (UspechyAttachment) i;

						if (a.AttachedTo is PlayerMobile)
						{
							if (a.UW > 0 && !m_Vysledky.ContainsKey((Mobile) a.AttachedTo))
								m_Vysledky.Add((Mobile) a.AttachedTo, a.UW);

							a.UW = 0;
						}
						else
							a.Delete();
					}
				}

				ArrayList SortedLog = new ArrayList();

				foreach (KeyValuePair<Mobile, int> db in m_Vysledky)
				{
					SortedLog.Add(new KeyValuePair<Mobile, int>(db.Key, db.Value));
				}

				SortedLog.Sort(new ListAmountSorter());
				m_Vysledky = null;

				World.Broadcast(192, false, "Zacalo nove kolo souteze Tyden v podsveti.");
				int cnt = 1;
				int revcnt = 1;

				foreach (KeyValuePair<Mobile, int> p in SortedLog)
				{
					if (p.Key == null || p.Key.Deleted)
						continue;

					UspechyAttachment att = (UspechyAttachment) XmlAttach.FindAttachment(p.Key, typeof(UspechyAttachment));

					if (cnt == 1)
					{
						revcnt = 3;
						SecureStash.DropToStash(new ItemBlessDeed(), p.Key);
					}
					else if (cnt == 2)
					{
						revcnt = 2;
					}
					else if (cnt == 3)
					{
						revcnt = 1;
					}

					if (att != null)
					{
						att.Soutez += revcnt;

						if (att.Soutez > 14)
							PlayerTitles.AddTitle(p.Key, 31);
					}

					if (p.Key.BankBox != null)
					{
						p.Key.BankBox.DropItem(new CechovniMince(revcnt * 1000));
					}

					SecureStash.DropToStash(new Gold(revcnt * 1000), p.Key);

					p.Key.SendMessage("Odmena byla umistena do tve bezpecnostni truhly a banky. Gratulujeme!");

					World.Broadcast(192, false, "{2}. misto {0} - {1} bodu", p.Key.RawName, p.Value, cnt);

					if (cnt > 2)
						break;

					cnt++;
				}
			}
		}

		private class ListAmountSorter : IComparer
		{
			public ListAmountSorter() : base()
			{
			}

			public int Compare(object a, object b)
			{
				if (a == null || b == null || a == b || !(a is KeyValuePair<Mobile, int>) || !(b is KeyValuePair<Mobile, int>))
					return 0;

				KeyValuePair<Mobile, int> x = (KeyValuePair<Mobile, int>) a;
				KeyValuePair<Mobile, int> y = (KeyValuePair<Mobile, int>) b;

				if (x.Key == y.Key && x.Key != null && y.Key != null)
				{
					return ((Mobile)x.Key).RawName.CompareTo(((Mobile)y.Key).RawName);
				}

				return ((x.Value > y.Value) ? -1 : 1);
			}
		}

		public static string[] GetHTMLList()
		{
			Dictionary<Mobile, int> m_Vysledky = new Dictionary<Mobile, int>();
			Dictionary<Mobile, int> m_VysledkyUW = new Dictionary<Mobile, int>();

			string str = "";
			string strUW = "";
			int cnt = 1;

			foreach (XmlAttachment i in XmlAttach.Values)
			{
				if (i != null && !i.Deleted && i is UspechyAttachment)
				{
					UspechyAttachment a = (UspechyAttachment) i;

					if (a.AttachedTo is PlayerMobile)
					{
						if (a.AllMaps > 0 && !m_Vysledky.ContainsKey((Mobile) a.AttachedTo))
							m_Vysledky.Add((Mobile) a.AttachedTo, a.AllMaps);

						if (a.UW > 0 && !m_VysledkyUW.ContainsKey((Mobile) a.AttachedTo))
							m_VysledkyUW.Add((Mobile) a.AttachedTo, a.UW);
					}
					else
						a.Delete();
				}
			}

			ArrayList SortedLog = new ArrayList();

			foreach (KeyValuePair<Mobile, int> db in m_Vysledky)
			{
				SortedLog.Add(new KeyValuePair<Mobile, int>(db.Key, db.Value));
			}

			SortedLog.Sort(new ListAmountSorter());

			ArrayList SortedLogUW = new ArrayList();

			foreach (KeyValuePair<Mobile, int> db in m_VysledkyUW)
			{
				SortedLogUW.Add(new KeyValuePair<Mobile, int>(db.Key, db.Value));
			}

			SortedLogUW.Sort(new ListAmountSorter());

			m_Vysledky = null;
			m_VysledkyUW = null;

			foreach (KeyValuePair<Mobile, int> p in SortedLog)
			{
				str += String.Format("{0}. {1} - {2}<br>", cnt, p.Key.RawName, p.Value.ToString("N0", Auberon.Chat.General.Nfi));

				if (cnt > 15)
					break;

				cnt++;
			}

			cnt = 1;

			foreach (KeyValuePair<Mobile, int> p in SortedLogUW)
			{
				strUW += String.Format("{0}. {1} - {2}<br>", cnt, p.Key.RawName, p.Value.ToString("N0", Auberon.Chat.General.Nfi));

				if (cnt > 15)
					break;

				cnt++;
			}

			return new string[] { str, strUW };
		}
	}
}