using System;
using Server;
using Server.Items;
using Server.Network;
using Server.Mobiles;

namespace Server.Engines.XmlSpawner2
{
	public class UspechyAttachment : XmlAttachment
	{
		private int m_Temp1 = 0;
		private int m_Temp2 = 0;
		private int m_Temp3 = 0;
		private int m_Soutez = 0;
		private int m_UW = 0;
		private int m_AllMaps = 0;

		//Craft tituly
		[CommandProperty(AccessLevel.GameMaster)]
		public int Temp1 { get { return m_Temp1; } set { m_Temp1 = value; } }

		[CommandProperty(AccessLevel.GameMaster)]
		public int Temp2 { get { return m_Temp2; } set { m_Temp2 = value; } }

		[CommandProperty(AccessLevel.GameMaster)]
		public int Temp3 { get { return m_Temp3; } set { m_Temp3 = value; } }

		[CommandProperty(AccessLevel.GameMaster)]
		public int Soutez
		{
			get { return m_Soutez; }
			set
			{
				m_Soutez = value;
			}
		}

		[CommandProperty(AccessLevel.GameMaster)]
		public int UW
		{
			get { return m_UW; }
			set
			{
				m_UW = value;

				// 				if ( m_Fishing > 24 && m_Fishing < 50 )
				// 					GiveTitle( 19 ); //the Sailor
				// 				else if ( m_Fishing > 49 && m_Fishing < 100 )
				// 					GiveTitle( 20 ); //the Sea-Dog
				// 				else if ( m_Fishing > 99 )
				// 					GiveTitle( 25 ); //the Sea Lord
			}
		}

		//Treasure
		[CommandProperty(AccessLevel.GameMaster)]
		public int AllMaps
		{
			get { return m_AllMaps; }
			set
			{
				m_AllMaps = value;
			}
		}

		public UspechyAttachment(ASerial serial) : base(serial)
		{
		}

		[Attachable]
		public UspechyAttachment()
		{
			Name = "Uspechy";
		}

		// 		public void GiveTitle( int TitleID )
		// 		{
		// 			if ( Owner is PlayerMobile )
		// 				PlayerTitles.AddTitle( (Mobile) Owner, TitleID );
		// 		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 1);
			// version 1
			writer.Write(m_Temp1);
			// version 0
			writer.Write(m_Temp2);
			writer.Write(m_Temp3);
			writer.Write(m_Soutez);
			writer.Write(m_UW);
			writer.Write(m_AllMaps);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			switch (version)
			{
				case 1:
				{
					m_Temp1 = reader.ReadInt();
					goto case 0;
				}

				case 0:
				{
					m_Temp2 = reader.ReadInt();
					m_Temp3 = reader.ReadInt();
					m_Soutez = reader.ReadInt();
					m_UW = reader.ReadInt();
					m_AllMaps = reader.ReadInt();
					break;
				}
			}
		}
	}
}