using System;
using Server;
using Server.Items;
using Server.Network;
using Server.Mobiles;

namespace Server.Engines.XmlSpawner2
{
	public class XmlExpy : XmlAttachment
	{
		private string m_Description;
		private int m_Xp = 1;
		private int m_Count;
		private int m_Body;
		
		[CommandProperty(AccessLevel.GameMaster)]
		public string Description { get { return m_Description; } set { m_Description = value; } }
		
		[CommandProperty(AccessLevel.GameMaster)]
		public int Xp { get { return m_Xp; } set { m_Xp = value; } }
		
		[CommandProperty(AccessLevel.GameMaster)]
		public int Count { get { return m_Count; } set { m_Count = value; } }
		
		[CommandProperty(AccessLevel.GameMaster)]
		public int Body { get { return m_Body; } set { m_Body = value; } }
		
		public XmlExpy(ASerial serial) : base(serial)
		{
		}
		
		[Attachable]
		public XmlExpy(int xp)
		{
			Name = "Exp";
			m_Description = "Guild XP";
			m_Xp = xp;
			m_Body = 0;
		}
		
		[Attachable]
		public XmlExpy(string value, int xp)
		{
			Name = "Exp";
			m_Description = value;
			m_Xp = xp;
			m_Body = 0;
		}
		
		[Attachable]
		public XmlExpy(string value, int xp, int body)
		{
			Name = "Exp";
			m_Description = value;
			m_Xp = xp;
			m_Body = body;
		}
		
		public override void OnAttach()
		{
			base.OnAttach();
			
			if(AttachedTo is BaseCreature || AttachedTo is ILockable)
			{ }
			else
				Delete();
		}
		
		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);
			
			writer.Write((int) 1);
			// version 1
			writer.Write(m_Body);
			// version 0
			writer.Write(m_Description);
			writer.Write(m_Xp);
			writer.Write(m_Count);
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			
			int version = reader.ReadInt();
			
			switch( version )
			{
				case 1:
				{
					m_Body = reader.ReadInt();
					goto case 0;
				}
				case 0:
				{
					m_Description = reader.ReadString();
					m_Xp = reader.ReadInt();
					m_Count = reader.ReadInt();
					break;
					}
			}
		}
		
		public override string OnIdentify(Mobile from)
		{
			//if(Description == null || Description.Length < 1) return null;
			
			return String.Format("{0}{1}[ziskano {2}x]{3}", (String.IsNullOrEmpty(Description)) ? "" : String.Format("{0}: ", Description), (Xp > 0) ?  String.Format("[{0} bodu]", Xp) : "", Count, (Body > 0) ?  String.Format("[Soutez: {0}]", Body) : "" );
		}
	}
}