using System;
using Server;
using Server.Gumps;
using Server.Network;

namespace Server.Items
{
	public class TravelStone : Item
	{
		public override bool DisplayWeight { get { return false; } }

		[Constructable]
		public TravelStone() : base( 0xED4 )
		{
			Hue = 39;
			Movable = false;
			Name = "Cestovni kamen";
		}

		public TravelStone( Serial serial ) : base( serial )
		{
		}

		public override void OnDoubleClick( Mobile from )
		{
			if ( from.InRange( this.GetWorldLocation(), 4 ) && from.InLOS( this ) )
			{
			   if( from.HasGump( typeof(TravelWandGump) ) )
				  from.CloseGump( typeof(TravelWandGump) );
            
            from.SendGump( new TravelWandGump( from, (Item)this ) );
         }
			else
				from.SendLocalizedMessage( 502138 );
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}
