using System;
using Server;
using Server.Gumps;
using Server.Network;
using Server.Multis;
using Server.ContextMenus;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
	public class TravelWand : Item, ISecurable
	{
		private SecureLevel m_Level;

		[CommandProperty( AccessLevel.GameMaster )]
		public SecureLevel Level
		{
			get{ return m_Level; }
			set{ m_Level = value; }
		}
      
      [Constructable]
		public TravelWand() : base( 0xDF2 )
		{
			Hue = 1161;
			Movable = true;
			Name = "Cestovni hulka";
			LootType = LootType.Blessed;
		}

		public TravelWand( Serial serial ) : base( serial )
		{
		}

		public override void OnDoubleClick( Mobile from )
		{
			if ( IsChildOf( from.Backpack ) || ( from.InRange( this.GetWorldLocation(), 4 ) && from.InLOS( this ) ) )
			{
			   if( from.HasGump( typeof(TravelWandGump) ) )
				  from.CloseGump( typeof(TravelWandGump) );
            
            from.SendGump( new TravelWandGump( from, (Item)this ) );
         }
			else
				from.SendLocalizedMessage( 502138 );
		}
		
		public override void GetContextMenuEntries( Mobile from, List<ContextMenuEntry> list )
		{
			base.GetContextMenuEntries( from, list );
			SetSecureLevelEntry.AddTo( from, this, list );
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 1 ); // version
			
			writer.WriteEncodedInt( (int) m_Level );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
			
			switch( version )
			{
				case 1:
				{
					m_Level = (SecureLevel) reader.ReadEncodedInt();
					goto case 0;
				}
            case 0:
				{
					break;
				}
			}
		}
	}
}
