using System;
using Server;
using Server.Gumps;
using Server.Network;
using Server.Mobiles;
using Server.Items;

namespace Server.Gumps
{
    public class TravelWandGump : Gump
    {
        public Point3D f_Location;
        public Map f_Map;
        private Item m_Stone;

        public TravelWandGump(Mobile owner, Item stone) : base(50, 45)
        {
            m_Stone = stone;

            this.Closable = true;
            this.Disposable = true;
            this.Dragable = true;
            this.Resizable = false;
            this.AddPage(0);
            this.AddBackground(0, 0, 500, 400, 5054);
            this.AddLabel(428, 12, 52, @"Zavrit");
            this.AddBackground(10, 282, 465, 108, 9350);
            this.AddButton(389, 11, 4017, 4019, 0, GumpButtonType.Reply, 0);
            this.AddImage(470, 3, 10410);
            this.AddImage(470, 305, 10412);
            this.AddImage(466, 150, 10411);
            this.AddButton(20, 290, 11411, 11412, 2, GumpButtonType.Page, 1);
            this.AddLabel(40, 288, 52, @"Trammel Mesta");
            this.AddButton(20, 315, 11411, 11412, 3, GumpButtonType.Page, 2);
            this.AddLabel(40, 313, 39, @"Felucca Mesta");
            this.AddLabel(178, 288, 43, @"Trammel Dungeony");
            this.AddLabel(178, 313, 38, @"Felucca Dungeony");
            this.AddLabel(345, 288, 447, @"Auberon");
            this.AddLabel(345, 313, 69, @"Ilshenar");
            this.AddLabel(41, 338, 83, @"Tokuno");
            this.AddLabel(182, 338, 94, @"Malas");
            this.AddLabel(345, 340, 109, @"Mondain's Legacy");
            this.AddLabel(41, 363, 128, @"Specialni Lokace");
            this.AddButton(20, 340, 11411, 11412, 4, GumpButtonType.Page, 3);
            this.AddButton(20, 365, 11411, 11412, 5, GumpButtonType.Page, 8);
            this.AddButton(158, 290, 11411, 11412, 6, GumpButtonType.Page, 5);
            this.AddButton(158, 315, 11411, 11412, 7, GumpButtonType.Page, 6);
            this.AddButton(158, 340, 11411, 11412, 8, GumpButtonType.Page, 7);
            this.AddButton(325, 290, 11411, 11412, 9, GumpButtonType.Page, 4); //auberon
            this.AddButton(325, 315, 11411, 11412, 10, GumpButtonType.Page, 9);
            this.AddButton(325, 340, 11411, 11412, 11, GumpButtonType.Page, 10);

            // PAGE 1
            this.AddPage(1);
            this.AddHtml(10, 10, 303, 27, @"Trammel Mesta", (bool)true, (bool)false);
            this.AddAlphaRegion(10, 45, 303, 225);
            this.AddHtml(324, 46, 152, 225, @"Města v Trammelu jsou bezpečná a hlídána několika skupinami královských stráží. Města kypí životem a je zde možno načerpat síly po dlouhých cestách v mnoha hostincích, tavernách a noclehárnách. Lze tu nakoupit vše potřebné jídlem počínaje, přes zbraně, brnění až po magické předměty.", (bool)true, (bool)true);
            this.AddButton(20, 55, 9763, 9762, 101, GumpButtonType.Reply, 0);
            this.AddLabel(40, 52, 52, @"Britain");
            this.AddButton(20, 85, 9763, 9762, 102, GumpButtonType.Reply, 0);
            this.AddLabel(40, 82, 52, @"Delucia");
            this.AddButton(20, 115, 9763, 9762, 103, GumpButtonType.Reply, 0);
            this.AddLabel(40, 112, 52, @"Haven");
            this.AddButton(20, 145, 9763, 9762, 104, GumpButtonType.Reply, 0);
            this.AddLabel(40, 142, 52, @"Vesper");
            this.AddButton(20, 175, 9763, 9762, 105, GumpButtonType.Reply, 0);
            this.AddLabel(40, 172, 52, @"Cove");
            this.AddButton(20, 205, 9763, 9762, 106, GumpButtonType.Reply, 0);
            this.AddLabel(40, 202, 52, @"Jhelom");
            this.AddButton(20, 235, 9763, 9762, 107, GumpButtonType.Reply, 0);
            this.AddLabel(40, 232, 52, @"Minoc");
            this.AddButton(120, 55, 9763, 9762, 108, GumpButtonType.Reply, 0);
            this.AddLabel(140, 52, 52, @"Moonglow");
            this.AddButton(120, 85, 9763, 9762, 109, GumpButtonType.Reply, 0);
            this.AddLabel(140, 82, 52, @"Nujel'm");
            this.AddButton(120, 115, 9763, 9762, 110, GumpButtonType.Reply, 0);
            this.AddLabel(140, 112, 52, @"Serp hold");
            this.AddButton(120, 145, 9763, 9762, 111, GumpButtonType.Reply, 0);
            this.AddLabel(140, 142, 52, @"Skara Brae");
            this.AddButton(120, 175, 9763, 9762, 112, GumpButtonType.Reply, 0);
            this.AddLabel(140, 172, 52, @"Trinsic");
            this.AddButton(120, 205, 9763, 9762, 113, GumpButtonType.Reply, 0);
            this.AddLabel(140, 202, 52, @"Wind");
            this.AddButton(120, 235, 9763, 9762, 114, GumpButtonType.Reply, 0);
            this.AddLabel(140, 232, 52, @"Yew");
            this.AddButton(220, 55, 9763, 9762, 115, GumpButtonType.Reply, 0);
            this.AddLabel(240, 52, 52, @"Papua");
            this.AddButton(220, 85, 9763, 9762, 116, GumpButtonType.Reply, 0);
            this.AddLabel(240, 82, 52, @"Magincia");

            // PAGE 2
            this.AddPage(2);
            this.AddHtml(10, 10, 303, 27, @"Felucca Mesta", (bool)true, (bool)false);
            this.AddAlphaRegion(10, 45, 303, 225);
            this.AddHtml(324, 46, 152, 225, @"Města ve Feluccii nehlídají stráže. Přesto je zde možno načerpat síly po dlouhých cestách a v mnoha tavernách a noclehárnách. Lze tu nakoupit vše potřebné od jídla počínaje, přes zbraně a brnění, až po magické předměty.", (bool)true, (bool)true);
            this.AddButton(20, 55, 9763, 9762, 201, GumpButtonType.Reply, 0);
            this.AddLabel(40, 52, 39, @"Britain");
            this.AddButton(20, 85, 9763, 9762, 202, GumpButtonType.Reply, 0);
            this.AddLabel(40, 82, 39, @"Delucia");
            this.AddButton(20, 115, 9763, 9762, 203, GumpButtonType.Reply, 0);
            this.AddLabel(40, 112, 39, @"Occlo (PvP)");
            this.AddButton(20, 145, 9763, 9762, 204, GumpButtonType.Reply, 0);
            this.AddLabel(40, 142, 39, @"Vesper");
            this.AddButton(20, 175, 9763, 9762, 205, GumpButtonType.Reply, 0);
            this.AddLabel(40, 172, 39, @"Cove");
            this.AddButton(20, 205, 9763, 9762, 206, GumpButtonType.Reply, 0);
            this.AddLabel(40, 202, 39, @"Jhelom");
            this.AddButton(20, 235, 9763, 9762, 207, GumpButtonType.Reply, 0);
            this.AddLabel(40, 232, 39, @"Minoc");
            this.AddButton(120, 55, 9763, 9762, 208, GumpButtonType.Reply, 0);
            this.AddLabel(140, 52, 39, @"Moonglow");
            this.AddButton(120, 85, 9763, 9762, 209, GumpButtonType.Reply, 0);
            this.AddLabel(140, 82, 39, @"Nujel'm");
            this.AddButton(120, 115, 9763, 9762, 210, GumpButtonType.Reply, 0);
            this.AddLabel(140, 112, 39, @"Serp hold");
            this.AddButton(120, 145, 9763, 9762, 211, GumpButtonType.Reply, 0);
            this.AddLabel(140, 142, 39, @"Skara Brae");
            this.AddButton(120, 175, 9763, 9762, 212, GumpButtonType.Reply, 0);
            this.AddLabel(140, 172, 39, @"Trinsic");
            this.AddButton(120, 205, 9763, 9762, 213, GumpButtonType.Reply, 0);
            this.AddLabel(140, 202, 39, @"Wind + Mage's Dungeon");
            this.AddButton(120, 235, 9763, 9762, 214, GumpButtonType.Reply, 0);
            this.AddLabel(140, 232, 39, @"Yew");
            this.AddButton(220, 55, 9763, 9762, 215, GumpButtonType.Reply, 0);
            this.AddLabel(240, 52, 39, @"Papua");
            this.AddButton(220, 85, 9763, 9762, 216, GumpButtonType.Reply, 0);
            this.AddLabel(240, 82, 39, @"Magincia");

            // PAGE 3
            this.AddPage(3);
            this.AddHtml(10, 10, 303, 27, @"Tokuno", (bool)true, (bool)false);
            this.AddAlphaRegion(10, 45, 303, 225);
            this.AddHtml(324, 46, 152, 225, @"Cesta do země ninjů a samurajů, překrásných přírodních scenérií, exotických monster a zuřivých, ale čestných bojovníků.", (bool)true, (bool)true);
            this.AddButton(20, 55, 9763, 9762, 301, GumpButtonType.Reply, 0);
            this.AddLabel(40, 52, 83, @"Zento");
            this.AddButton(20, 85, 9763, 9762, 302, GumpButtonType.Reply, 0);
            this.AddLabel(40, 82, 83, @"Waste");
            this.AddButton(20, 115, 9763, 9762, 303, GumpButtonType.Reply, 0);
            this.AddLabel(40, 112, 83, @"Bushido Dojo");
            this.AddButton(20, 145, 9763, 9762, 304, GumpButtonType.Reply, 0);
            this.AddLabel(40, 142, 83, @"Fan Dancer Dojo");
            this.AddButton(20, 175, 9763, 9762, 305, GumpButtonType.Reply, 0);
            this.AddLabel(40, 172, 83, @"Kitsune Woods");
            this.AddButton(20, 205, 9763, 9762, 306, GumpButtonType.Reply, 0);
            this.AddLabel(40, 202, 83, @"Yomotsu Mines");
            this.AddButton(20, 235, 9763, 9762, 307, GumpButtonType.Reply, 0);
            this.AddLabel(40, 232, 83, @"Crane March");
            this.AddButton(160, 55, 9763, 9762, 308, GumpButtonType.Reply, 0);
            this.AddLabel(180, 52, 83, @"Sleeping Dragon");
            this.AddButton(160, 85, 9763, 9762, 309, GumpButtonType.Reply, 0);
            this.AddLabel(180, 82, 83, @"Central Shrine");
            this.AddButton(160, 115, 9763, 9762, 310, GumpButtonType.Reply, 0);
            this.AddLabel(180, 112, 83, @"Lotus Lakes");
            this.AddButton(160, 145, 9763, 9762, 311, GumpButtonType.Reply, 0);
            this.AddLabel(180, 142, 83, @"Storm Point");

            // PAGE 4
            this.AddPage(4);
            this.AddHtml(10, 10, 303, 27, @"Auberon", (bool)true, (bool)false);
            this.AddAlphaRegion(10, 45, 303, 225);
            this.AddHtml(324, 46, 152, 225, @"Auberon je země zahalená tajemstvím. Tato země byla objevena naprostou náhodou. Od té doby se o ni začali zajímat nejpřednější mágové celé Britanie. Na popud Lorda Britishe byly do této země vysláni průzkumníci, z nichž se vrátila sotva čtvrtina. Tito lidé se z návratu nikdy nevzpamatovali a do konce života křičeli o úděsných nestvůrách. Lord British poučen touto událostí nechal sestavit druhou skupinu, skládající se z dobrodruhů, mágů, ale i prostých lidí, kterým se za největšího úsilí podařilo postavit několik křížů bohyně Ankh. Do této země se neodváží ani ty nejlepší z léčitelek, proto se i těch několik málo dobrodruhů, kteří se tam vydají, musí spolehnout sami na sebe nebo na své přátele.", (bool)true, (bool)true);
            this.AddButton(20, 55, 9763, 9762, 401, GumpButtonType.Reply, 0);
            this.AddLabel(40, 52, 447, @"Etharcas mountains");
            this.AddButton(20, 85, 9763, 9762, 402, GumpButtonType.Reply, 0);
            this.AddLabel(40, 82, 447, @"Lucennon valley");
            this.AddButton(20, 115, 9763, 9762, 403, GumpButtonType.Reply, 0);
            this.AddLabel(40, 112, 447, @"Ebenya");
            this.AddButton(20, 145, 9763, 9762, 404, GumpButtonType.Reply, 0);
            this.AddLabel(40, 142, 447, @"Darkmarsh swamp");
            this.AddButton(20, 175, 9763, 9762, 405, GumpButtonType.Reply, 0);
            this.AddLabel(40, 172, 447, @"Euphor pass");
            this.AddButton(20, 205, 9763, 9762, 406, GumpButtonType.Reply, 0);
            this.AddLabel(40, 202, 447, @"Woodmoor");
            this.AddButton(20, 235, 9763, 9762, 407, GumpButtonType.Reply, 0);
            this.AddLabel(40, 232, 447, @"Euphartica");
            this.AddButton(160, 55, 9763, 9762, 408, GumpButtonType.Reply, 0);
            this.AddLabel(180, 52, 447, @"Tirantor woods");
            this.AddButton(160, 85, 9763, 9762, 409, GumpButtonType.Reply, 0);
            this.AddLabel(180, 82, 447, @"Amennum");

            // PAGE 5
            this.AddPage(5);
            this.AddHtml(10, 10, 303, 27, @"Trammel Dungeony", (bool)true, (bool)false);
            this.AddAlphaRegion(10, 45, 303, 225);
            this.AddHtml(324, 46, 152, 225, @"Dungeony jsou temné jeskyně a podzemní kobky plné nástrah a nebezpečných monster. Do těchto míst se odváží jen ti největší dobrodruzi aby zde získali peníze a slávu. Častěji tu ovšem naleznou smrt. Říka se, že nejhlubších místech těchto dungeonů lze nalézt různé poklady a tak mnoho lidí stále a znovu riskuje vše, jen aby alespoň část pokladu získali.", (bool)true, (bool)true);
            this.AddButton(20, 55, 9763, 9762, 501, GumpButtonType.Reply, 0);
            this.AddLabel(40, 52, 43, @"Covetous");
            this.AddButton(20, 85, 9763, 9762, 502, GumpButtonType.Reply, 0);
            this.AddLabel(40, 82, 43, @"Deceit");
            this.AddButton(20, 115, 9763, 9762, 503, GumpButtonType.Reply, 0);
            this.AddLabel(40, 112, 43, @"Despise");
            this.AddButton(20, 145, 9763, 9762, 504, GumpButtonType.Reply, 0);
            this.AddLabel(40, 142, 43, @"Destard");
            this.AddButton(20, 175, 9763, 9762, 505, GumpButtonType.Reply, 0);
            this.AddLabel(40, 172, 43, @"Hythloth");
            this.AddButton(20, 205, 9763, 9762, 506, GumpButtonType.Reply, 0);
            this.AddLabel(40, 202, 43, @"Shame");
            this.AddButton(20, 235, 9763, 9762, 507, GumpButtonType.Reply, 0);
            this.AddLabel(40, 232, 43, @"Wrong");
            this.AddButton(120, 55, 9763, 9762, 508, GumpButtonType.Reply, 0);
            this.AddLabel(140, 52, 43, @"Fire");
            this.AddButton(120, 85, 9763, 9762, 509, GumpButtonType.Reply, 0);
            this.AddLabel(140, 82, 43, @"Ice");
            this.AddButton(120, 115, 9763, 9762, 510, GumpButtonType.Reply, 0);
            this.AddLabel(140, 112, 43, @"Terathan Keep");
            this.AddButton(120, 145, 9763, 9762, 511, GumpButtonType.Reply, 0);
            this.AddLabel(140, 142, 43, @"Pandemonium");
            this.AddButton(120, 175, 9763, 9762, 512, GumpButtonType.Reply, 0);
            this.AddLabel(140, 172, 43, @"Orc Caves");

            // PAGE 6
            this.AddPage(6);
            this.AddHtml(10, 10, 303, 27, @"Felucca Dungeony", (bool)true, (bool)false);
            this.AddAlphaRegion(10, 45, 303, 225);
            this.AddHtml(324, 46, 152, 225, @"Dungeony jsou temné jeskyně a podzemní kobky plné nástrah a nebezpečných monster. Do těchto míst se odváží jen ti největší dobrodruzi aby zde získali peníze a slávu. Častěji tu ovšem naleznou smrt. Říka se, že nejhlubších místech těchto dungeonů lze nalézt různé poklady a tak mnoho lidí stále a znovu riskuje vše, jen aby alespoň část pokladu získali. V dungeonech ve Feluccii je třeba si dát dobrý pozor na silné Teragony. Mnoho odvážlivců kteří přecenili své síly již toto setkání zaplatili svým životem.", (bool)true, (bool)true);
            this.AddButton(20, 55, 9763, 9762, 601, GumpButtonType.Reply, 0);
            this.AddLabel(40, 52, 38, @"Covetous");
            this.AddButton(20, 85, 9763, 9762, 602, GumpButtonType.Reply, 0);
            this.AddLabel(40, 82, 38, @"Deceit");
            this.AddButton(20, 115, 9763, 9762, 606, GumpButtonType.Reply, 0);
            this.AddLabel(40, 112, 38, @"Shame");
            this.AddButton(20, 145, 9763, 9762, 604, GumpButtonType.Reply, 0);
            this.AddLabel(40, 142, 38, @"Destard");
            this.AddButton(20, 175, 9763, 9762, 605, GumpButtonType.Reply, 0);
            this.AddLabel(40, 172, 38, @"Hythloth");
            this.AddButton(20, 205, 9763, 9762, 603, GumpButtonType.Reply, 0);
            this.AddLabel(40, 202, 38, @"Despise + Toxic Caves");
            this.AddButton(20, 235, 9763, 9762, 607, GumpButtonType.Reply, 0);
            this.AddLabel(40, 232, 38, @"Wrong");
            this.AddButton(120, 55, 9763, 9762, 608, GumpButtonType.Reply, 0);
            this.AddLabel(140, 52, 38, @"Fire");
            this.AddButton(120, 85, 9763, 9762, 609, GumpButtonType.Reply, 0);
            this.AddLabel(140, 82, 38, @"Ice");
            this.AddButton(120, 115, 9763, 9762, 610, GumpButtonType.Reply, 0);
            this.AddLabel(140, 112, 38, @"Terathan Keep");
            this.AddButton(120, 145, 9763, 9762, 611, GumpButtonType.Reply, 0);
            this.AddLabel(140, 142, 38, @"Khaldun");
            this.AddButton(120, 175, 9763, 9762, 612, GumpButtonType.Reply, 0);
            this.AddLabel(140, 172, 38, @"Orc Caves");

            // PAGE 7
            this.AddPage(7);
            this.AddHtml(10, 10, 303, 27, @"Malas", (bool)true, (bool)false);
            this.AddAlphaRegion(10, 45, 303, 225);
            this.AddHtml(324, 46, 152, 225, @"Povrch Malasu, plující v temném moři hvězd, je poškozen neustálými otřesy, které ohrožují stabilitu tohoto kontinentu. Jeho vznik je velikou záhadou a jeho budoucnost tajemstvím. Ale je známo, že tento kontinent není jako ostatní. Tři veliké části země - jedna z nich je již nyní se rozpadající ostrůvek - jsou spojeny mosty, pod nimiž se nachází obrovská nekonečná propast, která nikam nevede. Přesto dosud život v této nestálé krajině jen kvete a zvířata všech druhů a všichni lidé mohou považovat Malas svým domovem.", (bool)true, (bool)true);
            this.AddButton(20, 55, 9763, 9762, 701, GumpButtonType.Reply, 0);
            this.AddLabel(40, 52, 94, @"Luna");
            this.AddButton(20, 85, 9763, 9762, 702, GumpButtonType.Reply, 0);
            this.AddLabel(40, 82, 94, @"Umbra");
            this.AddButton(20, 115, 9763, 9762, 703, GumpButtonType.Reply, 0);
            this.AddLabel(40, 112, 94, @"Mine 1");
            this.AddButton(20, 145, 9763, 9762, 704, GumpButtonType.Reply, 0);
            this.AddLabel(40, 142, 94, @"Mine 2");
            this.AddButton(20, 175, 9763, 9762, 705, GumpButtonType.Reply, 0);
            this.AddLabel(40, 172, 94, @"Mine 3");
            this.AddButton(20, 205, 9763, 9762, 706, GumpButtonType.Reply, 0);
            this.AddLabel(40, 202, 94, @"Arena");
            this.AddButton(20, 235, 9763, 9762, 707, GumpButtonType.Reply, 0);
            this.AddLabel(40, 232, 94, @"Doom");
            this.AddButton(120, 55, 9763, 9762, 708, GumpButtonType.Reply, 0);
            this.AddLabel(140, 52, 94, @"Crystal Fens");
            this.AddButton(120, 85, 9763, 9762, 709, GumpButtonType.Reply, 0);
            this.AddLabel(140, 82, 94, @"Dry Highlands");
            this.AddButton(120, 115, 9763, 9762, 710, GumpButtonType.Reply, 0);
            this.AddLabel(140, 112, 94, @"Forgotten Pyramid");
            this.AddButton(120, 145, 9763, 9762, 711, GumpButtonType.Reply, 0);
            this.AddLabel(140, 142, 94, @"Orc Fortress");

            // PAGE 8
            this.AddPage(8);
            this.AddHtml(10, 10, 303, 27, @"Specialni Lokace", (bool)true, (bool)false);
            this.AddAlphaRegion(10, 45, 303, 225);
            this.AddHtml(324, 46, 152, 225, @"Rozcestník do všech různých koutů světa. Ve výcvikovém táboře se naučíte mnoha věcem. Na trhu si můžete pro změnu koupit vybavení od ostatních dobrodruhů nebo řemeslníků. V supermarketu si můžete zakoupit vybavení do svého domu. V minimarketu na Vás čekají obchodníci, kteří vám prodají vše potřebné. Event center Vás zavede například do Arény, či na soutěž ve střelbě s lukem. Mistři barvíři Vám pomohou nabarvit si nějaký předmět v Domě barev a v muzeu ve městě Vesper se můžete pokochat pohledem na vystavené předměty.", (bool)true, (bool)true);
            this.AddButton(20, 55, 9763, 9762, 801, GumpButtonType.Reply, 0);
            this.AddLabel(40, 52, 128, @"Vycvikovy tabor");
            this.AddButton(20, 85, 9763, 9762, 802, GumpButtonType.Reply, 0);
            this.AddLabel(40, 82, 128, @"Trznice");
            this.AddButton(20, 115, 9763, 9762, 803, GumpButtonType.Reply, 0);
            this.AddLabel(40, 112, 128, @"Supermarket");
            this.AddButton(20, 145, 9763, 9762, 804, GumpButtonType.Reply, 0);
            this.AddLabel(40, 142, 128, @"Minimarket");
            this.AddButton(20, 175, 9763, 9762, 805, GumpButtonType.Reply, 0);
            this.AddLabel(40, 172, 128, @"Events Center");
            this.AddButton(20, 205, 9763, 9762, 806, GumpButtonType.Reply, 0);
            this.AddLabel(40, 202, 128, @"Dum barev");
            this.AddButton(20, 235, 9763, 9762, 807, GumpButtonType.Reply, 0);
            this.AddLabel(40, 232, 128, @"Muzeum Vesper");
            this.AddButton(160, 55, 9763, 9762, 808, GumpButtonType.Reply, 0);
            this.AddLabel(180, 52, 128, @"Chamber of Virtue");
            this.AddButton(160, 85, 9763, 9762, 809, GumpButtonType.Reply, 0);
            this.AddLabel(180, 82, 128, @"Cech obchodniku");
            this.AddButton(160, 115, 9763, 9762, 810, GumpButtonType.Reply, 0);
            this.AddLabel(180, 112, 128, @"Legendary Enhancer");

            // PAGE 9
            this.AddPage(9);
            this.AddHtml(10, 10, 303, 27, @"Ilshenar", (bool)true, (bool)false);
            this.AddAlphaRegion(10, 45, 303, 225);
            this.AddHtml(324, 46, 152, 225, @"Velice málo známá divočina plná zvířat a tvorů s magickými vlastnostmi. Pozor na silné Paragony.", (bool)true, (bool)true);
            this.AddButton(20, 55, 9763, 9762, 901, GumpButtonType.Reply, 0);
            this.AddLabel(40, 52, 69, @"Rat Cave");
            this.AddButton(20, 85, 9763, 9762, 902, GumpButtonType.Reply, 0);
            this.AddLabel(40, 82, 69, @"Spider Cave");
            this.AddButton(20, 115, 9763, 9762, 903, GumpButtonType.Reply, 0);
            this.AddLabel(40, 112, 69, @"Ancient Citadel");
            this.AddButton(20, 145, 9763, 9762, 904, GumpButtonType.Reply, 0);
            this.AddLabel(40, 142, 69, @"Gargoyle City");
            this.AddButton(20, 175, 9763, 9762, 905, GumpButtonType.Reply, 0);
            this.AddLabel(40, 172, 69, @"Mistas");
            this.AddButton(20, 205, 9763, 9762, 906, GumpButtonType.Reply, 0);
            this.AddLabel(40, 202, 69, @"Montor");
            this.AddButton(20, 235, 9763, 9762, 907, GumpButtonType.Reply, 0);
            this.AddLabel(40, 232, 69, @"Savage Camp");
            this.AddButton(160, 55, 9763, 9762, 908, GumpButtonType.Reply, 0);
            this.AddLabel(180, 52, 69, @"Ankh");
            this.AddButton(160, 85, 9763, 9762, 909, GumpButtonType.Reply, 0);
            this.AddLabel(180, 82, 69, @"Blood");
            this.AddButton(160, 115, 9763, 9762, 910, GumpButtonType.Reply, 0);
            this.AddLabel(180, 112, 69, @"Rock");
            this.AddButton(160, 145, 9763, 9762, 911, GumpButtonType.Reply, 0);
            this.AddLabel(180, 142, 69, @"Sorceror");
            this.AddButton(160, 175, 9763, 9762, 912, GumpButtonType.Reply, 0);
            this.AddLabel(180, 172, 69, @"Reg Volon");//spectre
            this.AddButton(160, 205, 9763, 9762, 913, GumpButtonType.Reply, 0);
            this.AddLabel(180, 202, 69, @"Wisp");
            this.AddButton(160, 235, 9763, 9762, 914, GumpButtonType.Reply, 0);
            this.AddLabel(180, 232, 69, @"Cyclops Temple");

            // PAGE 10
            this.AddPage(10);
            this.AddHtml(10, 10, 303, 27, @"Mondain's Legacy", (bool)true, (bool)false);
            this.AddAlphaRegion(10, 45, 303, 225);
            this.AddHtml(324, 46, 152, 225, @"Nebezpečná místa, kde je zřetelně vidět rozklad a úpadek kdysi krásného světa Sosarie.", (bool)true, (bool)true);
            this.AddButton(20, 55, 9763, 9762, 1001, GumpButtonType.Reply, 0);
            this.AddLabel(40, 52, 109, @"Paroxysmus");
            this.AddButton(20, 85, 9763, 9762, 1002, GumpButtonType.Reply, 0);
            this.AddLabel(40, 82, 109, @"Twisted Weald");
            this.AddButton(20, 115, 9763, 9762, 1003, GumpButtonType.Reply, 0);
            this.AddLabel(40, 112, 109, @"Blighted Grove");
            this.AddButton(20, 145, 9763, 9762, 1004, GumpButtonType.Reply, 0);
            this.AddLabel(40, 142, 109, @"Bedlam");
            this.AddButton(20, 175, 9763, 9762, 1005, GumpButtonType.Reply, 0);
            this.AddLabel(40, 172, 109, @"Prism of Light + Warrior's Dungeon");
            this.AddButton(20, 205, 9763, 9762, 1006, GumpButtonType.Reply, 0);
            this.AddLabel(40, 202, 109, @"The Citadel");
            this.AddButton(20, 235, 9763, 9762, 1007, GumpButtonType.Reply, 0);
            this.AddLabel(40, 232, 109, @"Painted Caves");
            this.AddButton(160, 55, 9763, 9762, 1008, GumpButtonType.Reply, 0);
            this.AddLabel(180, 52, 109, @"Labyrinth");
            this.AddButton(160, 85, 9763, 9762, 1009, GumpButtonType.Reply, 0);
            this.AddLabel(180, 82, 109, @"Sanctuary");
            this.AddButton(160, 145, 9763, 9762, 1010, GumpButtonType.Reply, 0);
            this.AddLabel(180, 142, 109, @"Heartwood");
        }


        //============ ODPOVEDI
        public override void OnResponse(NetState state, RelayInfo info) //Function for GumpButtonType.Reply Buttons
        {
            Mobile from = state.Mobile;

            switch (info.ButtonID)
            {
                case 0: //Case uses the ActionIDs defenied above. Case 0 defenies the actions for the button with the action id 0
                    {
                        //Cancel
                        // from.SendMessage( "You have chosen to stay here." );
                        f_Map = from.Map;
                        f_Location = from.Location;
                        break;
                    }

                // START TRAMMEL Mesta

                case 101: //Case uses the ActionIDs defenied above. Case 0 defenies the actions for the button with the action id 0
                    {
                        //britian
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(1424, 1697, 0);
                        break;
                    }
                case 102: //Same as above
                    {
                        //Delucia
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(5272, 3995, 37);
                        break;
                    }
                case 103:
                    {
                        //Ocllo
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(3650, 2519, 0);
                        break;
                    }
                case 104:
                    {
                        //Vesper
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(2899, 676, 0);
                        break;
                    }
                case 105:
                    {
                        //Cove
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(2237, 1214, 0);
                        break;
                    }

                case 106:
                    {
                        //Jhelom
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(1417, 3821, 0);
                        break;
                    }
                case 107:
                    {
                        //Minoc
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(2503, 563, 0);
                        break;
                    }
                case 108:
                    {
                        //Moonglow
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(4454, 1170, 0);
                        break;
                    }
                case 109:
                    {
                        //Nujel'm
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(3770, 1308, 0);
                        break;
                    }
                case 110:
                    {
                        //Serp hold
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(2895, 3479, 15);
                        break;
                    }
                case 111:
                    {
                        //Skara Brae
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(612, 2145, 0);
                        break;
                    }
                case 112:
                    {
                        //Trinsic
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(1823, 2826, 0);
                        break;
                    }

                case 113:
                    {
                        //Wind
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(1361, 895, 0);
                        break;
                    }
                case 114:
                    {
                        //Yew
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(548, 1006, 0);
                        break;
                    }
                case 115:
                    {
                        //Papua
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(5729, 3209, -1);
                        break;
                    }
                case 116:
                    {
                        //Magincia
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(3728, 2164, 20);
                        break;
                    }
                //==== END TRAMMEL Mesta

                // START FELUCCA Mesta

                case 201: //Case uses the ActionIDs defenied above. Case 0 defenies the actions for the button with the action id 0
                    {
                        //britian
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(1424, 1697, 0);
                        break;
                    }
                case 202: //Same as above
                    {
                        //Delucia
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(5272, 3995, 37);
                        break;
                    }
                case 203:
                    {
                        //Ocllo
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(3650, 2519, 0);
                        break;
                    }
                case 204:
                    {
                        //Vesper
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(2899, 676, 0);
                        break;
                    }
                case 205:
                    {
                        //Cove
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(2237, 1214, 0);
                        break;
                    }

                case 206:
                    {
                        //Jhelom
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(1417, 3821, 0);
                        break;
                    }
                case 207:
                    {
                        //Minoc
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(2503, 563, 0);
                        break;
                    }
                case 208:
                    {
                        //Moonglow
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(4454, 1170, 0);
                        break;
                    }
                case 209:
                    {
                        //Nujel'm
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(3770, 1308, 0);
                        break;
                    }
                case 210:
                    {
                        //Serp hold
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(2895, 3479, 15);
                        break;
                    }
                case 211:
                    {
                        //Skara Brae
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(612, 2145, 0);
                        break;
                    }
                case 212:
                    {
                        //Trinsic
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(1823, 2826, 0);
                        break;
                    }

                case 213:
                    {
                        //Wind
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(1361, 895, 0);
                        break;
                    }
                case 214:
                    {
                        //Yew
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(548, 1006, 0);
                        break;
                    }
                case 215:
                    {
                        //Papua
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(5729, 3209, -1);
                        break;
                    }
                case 216:
                    {
                        //Magincia
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(3728, 2164, 20);
                        break;
                    }
                //==== END FELUCCA Mesta


                // START TOKUNO

                case 301:
                    {
                        //Zento
                        f_Map = Map.Tokuno;
                        f_Location = new Point3D(736, 1256, 30);
                        break;
                    }
                case 302: //Same as above
                    {
                        //Waste
                        f_Map = Map.Tokuno;
                        f_Location = new Point3D(725, 1051, 35);
                        break;
                    }
                case 303:
                    {
                        //Bushido Dojo
                        f_Map = Map.Tokuno;
                        f_Location = new Point3D(338, 400, 32);
                        break;
                    }
                case 304:
                    {
                        //Fan Dancer Dojo
                        f_Map = Map.Tokuno;
                        f_Location = new Point3D(977, 223, 23);
                        break;
                    }
                case 305:
                    {
                        //Kitsune Woods
                        f_Map = Map.Tokuno;
                        f_Location = new Point3D(579, 449, 36);
                        break;
                    }

                case 306:
                    {
                        //Yomotsu Mines
                        f_Map = Map.Tokuno;
                        f_Location = new Point3D(254, 787, 64);
                        break;
                    }
                case 307:
                    {
                        //Crane March
                        f_Map = Map.Tokuno;
                        f_Location = new Point3D(191, 998, 10);
                        break;
                    }
                case 308:
                    {
                        //Sleeping Dragon
                        f_Map = Map.Tokuno;
                        f_Location = new Point3D(910, 346, 8);
                        break;
                    }
                case 309:
                    {
                        //Central Shrine
                        f_Map = Map.Tokuno;
                        f_Location = new Point3D(1044, 516, 15);
                        break;
                    }
                case 310:
                    {
                        //Lotus Lakes
                        f_Map = Map.Tokuno;
                        f_Location = new Point3D(1051, 939, 28);
                        break;
                    }
                case 311:
                    {
                        //Storm Point
                        f_Map = Map.Tokuno;
                        f_Location = new Point3D(1174, 1003, 34);
                        break;
                    }

                //==== END TOKUNO

                ////// START OF Auberon CASES

                case 401:
                    {
                        // Etharcas mountains
                        f_Map = Map.Auberon;
                        f_Location = new Point3D(1216, 468, -13);
                        break;
                    }
                case 402:
                    {
                        //Lucennon valley
                        f_Map = Map.Auberon;
                        f_Location = new Point3D(721, 1363, -61);
                        break;
                    }
                case 403:
                    {
                        // Ebenya
                        f_Map = Map.Auberon;
                        f_Location = new Point3D(746, 724, -29);
                        break;
                    }
                case 404:
                    {
                        // Darkmarsh Swamp
                        f_Map = Map.Auberon;
                        f_Location = new Point3D(285, 1016, 0);
                        break;
                    }
                case 405:
                    {
                        // Euphor pass
                        f_Map = Map.Auberon;
                        f_Location = new Point3D(983, 1011, -36);
                        break;
                    }
                case 406:
                    {
                        // Woodmoor
                        f_Map = Map.Auberon;
                        f_Location = new Point3D(1174, 1288, -30);
                        break;
                    }
                case 407:
                    {
                        // Euphartica
                        f_Map = Map.Auberon;
                        f_Location = new Point3D(1531, 1341, -3);
                        break;
                    }
                case 408:
                    {
                        // Tirantor woods
                        f_Map = Map.Auberon;
                        f_Location = new Point3D(528, 214, -47);
                        break;
                    }
                case 409:
                    {
                        // Amennum
                        f_Map = Map.Auberon;
                        f_Location = new Point3D(1721, 219, 96);
                        break;
                    }
                ///// END OF Auberon

                ///// START TRAMMEL Dungeony

                case 501:
                    {
                        //Covetous
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(2499, 922, 0);
                        break;
                    }
                case 502:
                    {
                        //Deceit
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(4111, 434, 5);
                        break;
                    }
                case 503:
                    {
                        //Despise
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(1301, 1080, 0);
                        break;
                    }
                case 504:
                    {
                        //Destard
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(1176, 2639, 0);
                        break;
                    }
                case 505:
                    {
                        //Hythloth
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(4722, 3825, 0);
                        break;
                    }
                case 506:
                    {
                        //Shame
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(514, 1561, 0);
                        break;
                    }
                case 507:
                    {
                        //Wrong
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(2044, 238, 10);
                        break;
                    }
                case 508:
                    {
                        // Fire
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(5760, 2907, 17);
                        break;
                    }
                case 509:
                    {
                        // Ice
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(1999, 81, 5);
                        break;
                    }
                case 510:
                    {
                        // Terathan Keep
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(5499, 3224, 0);
                        break;
                    }
                case 511:
                    {
                        // Pandemonium
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(1719, 1067, 0);
                        break;
                    }
                case 512:
                    {
                        // Orc Caves
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(1011, 1424, 0);
                        break;
                    }

                ///// END TRAMMEL Dungeony

                ///// START FELUCCA Dungeony

                case 601:
                    {
                        //Covetous
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(2499, 922, 0);
                        break;
                    }
                case 602:
                    {
                        //Deceit
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(4111, 434, 5);
                        break;
                    }
                case 603:
                    {
                        //Despise
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(1301, 1080, 0);
                        break;
                    }
                case 604:
                    {
                        //Destard
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(1176, 2639, 0);
                        break;
                    }
                case 605:
                    {
                        //Hythloth
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(4722, 3825, 0);
                        break;
                    }
                case 606:
                    {
                        //Shame
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(514, 1561, 0);
                        break;
                    }
                case 607:
                    {
                        //Wrong
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(2044, 238, 10);
                        break;
                    }
                case 608:
                    {
                        // Fire
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(5760, 2907, 17);
                        break;
                    }
                case 609:
                    {
                        // Ice
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(1999, 81, 5);
                        break;
                    }
                case 610:
                    {
                        // Terathan Keep
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(5499, 3224, 0);
                        break;
                    }
                case 611:
                    {
                        // Khaldun
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(6008, 3778, 20);
                        break;
                    }
                case 612:
                    {
                        // Orc Caves
                        f_Map = Map.Felucca;
                        f_Location = new Point3D(1011, 1424, 0);
                        break;
                    }
                ///// END FELUCCA Dungeony


                ////  START MALAS CASES

                case 701:
                    {
                        // Luna
                        f_Map = Map.Malas;
                        f_Location = new Point3D(991, 519, -50);
                        break;
                    }
                case 702:
                    {
                        // Umbra
                        f_Map = Map.Malas;
                        f_Location = new Point3D(2044, 1344, -85);
                        break;
                    }
                case 703:
                    {
                        // Mine 1
                        f_Map = Map.Malas;
                        f_Location = new Point3D(2102, 558, -90);
                        break;
                    }
                case 704:
                    {
                        // Mine 2
                        f_Map = Map.Malas;
                        f_Location = new Point3D(2157, 459, -90);
                        break;
                    }
                case 705:
                    {
                        // Mine 3
                        f_Map = Map.Malas;
                        f_Location = new Point3D(1793, 472, -90);
                        break;
                    }
                case 706:
                    {
                        // Arena
                        f_Map = Map.Malas;
                        f_Location = new Point3D(2365, 1129, -90);
                        break;
                    }
                case 707:
                    {
                        // DOOM
                        f_Map = Map.Malas;
                        f_Location = new Point3D(2367, 1268, -85);
                        break;
                    }
                case 708:
                    {
                        // Crystal Fens
                        f_Map = Map.Malas;
                        f_Location = new Point3D(1388, 616, -85);
                        break;
                    }
                case 709:
                    {
                        // Dry Highlands
                        f_Map = Map.Malas;
                        f_Location = new Point3D(2128, 1668, -90);
                        break;
                    }
                case 710:
                    {
                        // Forgotten Pyramid
                        f_Map = Map.Malas;
                        f_Location = new Point3D(1851, 1800, -110);
                        break;
                    }
                case 711:
                    {
                        // Orc Fortress
                        f_Map = Map.Malas;
                        f_Location = new Point3D(1284, 1273, -90);
                        break;
                    }


                ///// END OF MALAS


                ////  START SPECIALS CASES

                case 801:
                    {
                        // vycvikovy tabor
                        f_Map = Map.Malas;
                        f_Location = new Point3D(371, 754, -1);
                        break;
                    }
                case 802:
                    {
                        // trznice
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(2973, 3362, 15);
                        break;
                    }
                case 803:
                    {
                        // supermarket
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(1362, 1625, 94);
                        break;
                    }
                case 804:
                    {
                        // minimarket
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(4479, 1132, 0);
                        break;
                    }
                case 805:
                    {
                        // events center
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(4311, 990, 0);
                        break;
                    }
                case 806:
                    {
                        // dum barev
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(1504, 1529, 40);
                        break;
                    }
                case 807:
                    {
                        // muzeum vesper
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(2925, 969, -21);
                        break;
                    }
                case 808:
                    {
                        // chamber of virtue
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(1545, 1617, 10);
                        break;
                    }
                case 809:
                    {
                        // cech obchodniku
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(1631, 1674, 15);
                        break;
                    }
                case 810:
                    {
                        // legendary enhancer
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(1506, 1578, 20);
                        break;
                    }
                ///// END OF SPECIALS



                ////// START OF ILSHENAR CASES

                case 901:
                    {
                        // Rat Cave
                        f_Map = Map.Ilshenar;
                        f_Location = new Point3D(1034, 1153, -22);
                        break;
                    }
                case 902:
                    {
                        //Spider Cave
                        f_Map = Map.Ilshenar;
                        f_Location = new Point3D(1421, 913, -16);
                        break;
                    }
                case 903:
                    {
                        // Ancient Citadel
                        f_Map = Map.Ilshenar;
                        f_Location = new Point3D(1518, 568, -13);
                        break;
                    }
                case 904:
                    {
                        // Gargoyle City
                        f_Map = Map.Ilshenar;
                        f_Location = new Point3D(836, 641, -20);
                        break;
                    }
                case 905:
                    {
                        // Mistas
                        f_Map = Map.Ilshenar;
                        f_Location = new Point3D(820, 1073, -30);
                        break;
                    }
                case 906:
                    {
                        // Montor
                        f_Map = Map.Ilshenar;
                        f_Location = new Point3D(1643, 310, 48);
                        break;
                    }
                case 907:
                    {
                        // Savage Camp
                        f_Map = Map.Ilshenar;
                        f_Location = new Point3D(1251, 743, -80);
                        break;
                    }
                case 908:
                    {
                        // Ankh
                        f_Map = Map.Ilshenar;
                        f_Location = new Point3D(576, 1150, -100);
                        break;
                    }
                case 909:
                    {
                        // Blood
                        f_Map = Map.Ilshenar;
                        f_Location = new Point3D(1747, 1228, -1);
                        break;
                    }
                case 910:
                    {
                        // Rock
                        f_Map = Map.Ilshenar;
                        f_Location = new Point3D(1788, 573, 71);
                        break;
                    }
                case 911:
                    {
                        // Sorceror
                        f_Map = Map.Ilshenar;
                        f_Location = new Point3D(548, 462, -53);
                        break;
                    }
                case 912:
                    {
                        // Spectre - Reg Volon
                        f_Map = Map.Ilshenar;
                        f_Location = new Point3D(1363, 1105, -26);
                        break;
                    }
                case 913:
                    {
                        // Wisp
                        f_Map = Map.Ilshenar;
                        f_Location = new Point3D(651, 1302, -58);
                        break;
                    }
                case 914:
                    {
                        // Cyclops Temple
                        f_Map = Map.Ilshenar;
                        f_Location = new Point3D(861, 1304, -71);
                        break;
                    }

                ///// END OF ILSHENAR

                ////  START MONDAINS LEGACY

                case 1001:
                    {
                        // Palace of Paroxymus
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(5569, 3020, 32);
                        break;
                    }
                case 1002:
                    {
                        // Twisted Weald
                        f_Map = Map.Ilshenar;
                        f_Location = new Point3D(1461, 1329, -23);
                        break;
                    }
                case 1003:
                    {
                        // Blighted Grove
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(584, 1644, -5);
                        break;
                    }
                case 1004:
                    {
                        // Bedlam
                        f_Map = Map.Malas;
                        f_Location = new Point3D(2078, 1376, -70);
                        break;
                    }
                case 1005:
                    {
                        // Prism of Light
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(3788, 1095, 19);
                        break;
                    }
                case 1006:
                    {
                        // The Citadel
                        f_Map = Map.Tokuno;
                        f_Location = new Point3D(1355, 762, 17);
                        break;
                    }
                case 1007:
                    {
                        // Painted Caves
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(1715, 2993, 0);
                        break;
                    }
                case 1008:
                    {
                        // Labyrinth
                        f_Map = Map.Malas;
                        f_Location = new Point3D(1733, 982, -80);
                        break;
                    }
                case 1009:
                    {
                        // Sanctuary
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(796, 1607, 0);
                        break;
                    }
                case 1010:
                    {
                        // heartwood
                        f_Map = Map.Trammel;
                        f_Location = new Point3D(7077, 381, 0);
                        break;
                    }
                    ///// END MONDAINS LEGACY
            }

            BaseHire hire = BaseHire.HireTable[from] as BaseHire;

            if (f_Map == Map.Auberon && from.AccessLevel == AccessLevel.Player && hire != null && !hire.Deleted && hire.GetOwner() == from && hire is Medic)
                from.SendMessage("Nemuzes se premistit na vybrane misto pokud te doprovazi medik.");
            else if (m_Stone != null && !m_Stone.Deleted && !(m_Stone.IsChildOf(from.Backpack) || m_Stone.Parent == from || (from.InRange(m_Stone.GetWorldLocation(), 4) && from.InLOS(m_Stone))))
                from.SendLocalizedMessage(502138);
            else if (from.Player && !from.Alive)
                from.SendMessage("Nemuzes se premistit pokud jsi mrtv{0}.", from.Female ? "a" : "y");
            else if ((f_Map == Map.Felucca || f_Map == Map.Auberon) && from is PlayerMobile && ((PlayerMobile)from).Young)
                from.SendMessage("Jako mlady dobrodruh nemuzes cestovat do zeme Felluca nebo Auberon.");
            else if (from.Kills >= 5 && f_Map != Map.Felucca)
                from.SendLocalizedMessage(1019004); // You are not allowed to travel there.
            else if (Factions.Sigil.ExistsOn(from))
                from.SendLocalizedMessage(1061632); // You can't do that while carrying the sigil.
            else if (Spells.SpellHelper.CheckCombat(from))
                from.SendLocalizedMessage(1005564, "", 0x22); // Wouldst thou flee during the heat of battle??
            else if (Server.Misc.WeightOverloading.IsOverloaded(from))
                from.SendLocalizedMessage(502359, "", 0x22); // Thou art too encumbered to move.
            else if (f_Map != null)
            {
                if (f_Location != from.Location)
                    from.PlaySound(0x1FC);

                Mobiles.BaseCreature.TeleportPets(from, f_Location, f_Map, false);
                from.Map = f_Map;
                from.Location = f_Location;
                from.Combatant = null;

                if (f_Location != from.Location)
                    from.PlaySound(0x1FC);
            }
        }
    }
}
