using System;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	public class Paragon
	{
		public static double ChestChance = .03;         // Chance that a paragon will carry a paragon chest
		public static Map[] Maps         = new Map[]    // Maps that paragons will spawn on
		{
			Map.Ilshenar,
			Map.Auberon
		};

		public static Type[] Artifacts = new Type[]
		{
			typeof( GoldBricks ), typeof( PhillipsWoodenSteed ), 
			typeof( AlchemistsBauble ), typeof( ArcticDeathDealer ),
			typeof( BlazeOfDeath ), typeof( BowOfTheJukaKing ),
			typeof( BurglarsBandana ), typeof( CavortingClub ),
			typeof( EnchantedTitanLegBone ), typeof( GwennosHarp ),
			typeof( IolosLute ), typeof( LunaLance ),
			typeof( NightsKiss ), typeof( NoxRangersHeavyCrossbow ),
			typeof( OrcishVisage ), typeof( PolarBearMask ),
			typeof( ShieldOfInvulnerability ), typeof( StaffOfPower ),
			typeof( VioletCourage ), typeof( HeartOfTheLion ), 
			typeof( WrathOfTheDryad ), typeof( PixieSwatter ), 
			typeof( GlovesOfThePugilist )
		};
		
		public static Type[] MLMiniArtifacts = new Type[]
		{
			typeof( AegisOfGrace ), typeof( BladeDance ), 
			typeof( Bonesmasher ), typeof( FeyLeggings ),
			typeof( FleshRipper ), typeof( PadsOfTheCuSidhe ),
			typeof( RaedsGlory ), typeof( RighteousAnger ),
			typeof( RobeOfTheEclipse ), typeof( RobeOfTheEquinox ),
			typeof( BloodwoodSpirit ), typeof( TotemOfVoid ),
			typeof( BrightsightLenses ), typeof( WildfireBow ), typeof( WindSong ),
			typeof( SoulSeeker ), typeof( TalonBite )
		};

		public static int    hue   = 0x501;        // Paragon hue
		
		// Buffs
		public static double HitsBuff   = 6.0;
		public static double StrBuff    = 1.30;
		public static double IntBuff    = 1.80;
		public static double DexBuff    = 1.35;
		public static double SkillsBuff = 1.90;
		public static double SpeedBuff  = 1.30;
		public static double FameBuff   = 1.40;
		public static double KarmaBuff  = 1.40;
		public static int    DamageBuff = 8;

		public static void Convert( BaseCreature bc )
		{
			if ( bc.IsParagon )
				return;
//          if ( ((Mobile)bc).Map != Map.Auberon )
// 			   bc.Hue = hue;

			if ( bc.HitsMaxSeed >= 0 )
				bc.HitsMaxSeed = (int)( bc.HitsMaxSeed * HitsBuff );
			
			bc.RawStr = (int)( bc.RawStr * StrBuff );
			bc.RawInt = (int)( bc.RawInt * IntBuff );
			bc.RawDex = (int)( bc.RawDex * DexBuff );

			bc.Hits = bc.HitsMax;
			bc.Mana = bc.ManaMax;
			bc.Stam = bc.StamMax;

			for( int i = 0; i < bc.Skills.Length; i++ )
			{
				Skill skill = (Skill)bc.Skills[i];

				if ( skill.Base > 0.0 )
					skill.Base *= SkillsBuff;
			}

			bc.PassiveSpeed /= SpeedBuff;
			bc.ActiveSpeed /= SpeedBuff;

			bc.DamageMin += DamageBuff;
			bc.DamageMax += DamageBuff;

			if ( bc.Fame > 0 )
				bc.Fame = (int)( bc.Fame * FameBuff );

			if ( bc.Fame > 32000 )
				bc.Fame = 32000;

			// TODO: Mana regeneration rate = Sqrt( buffedFame ) / 4

			if ( bc.Karma != 0 )
			{
				bc.Karma = (int)( bc.Karma * KarmaBuff );

				if( Math.Abs( bc.Karma ) > 32000 )
					bc.Karma = 32000 * Math.Sign( bc.Karma );
			}
		}

		public static void UnConvert( BaseCreature bc )
		{
			if ( !bc.IsParagon )
				return;

// 			bc.Hue = 0;

			if ( bc.HitsMaxSeed >= 0 )
				bc.HitsMaxSeed = (int)( bc.HitsMaxSeed / HitsBuff );
			
			bc.RawStr = (int)( bc.RawStr / StrBuff );
			bc.RawInt = (int)( bc.RawInt / IntBuff );
			bc.RawDex = (int)( bc.RawDex / DexBuff );

			bc.Hits = bc.HitsMax;
			bc.Mana = bc.ManaMax;
			bc.Stam = bc.StamMax;

			for( int i = 0; i < bc.Skills.Length; i++ )
			{
				Skill skill = (Skill)bc.Skills[i];

				if ( skill.Base > 0.0 )
					skill.Base /= SkillsBuff;
			}
			
			bc.PassiveSpeed *= SpeedBuff;
			bc.ActiveSpeed *= SpeedBuff;

			bc.DamageMin -= DamageBuff;
			bc.DamageMax -= DamageBuff;

			if ( bc.Fame > 0 )
				bc.Fame = (int)( bc.Fame / FameBuff );
			if ( bc.Karma != 0 )
				bc.Karma = (int)( bc.Karma / KarmaBuff );
		}

		public static bool CheckConvert( BaseCreature bc )
		{
			return CheckConvert( bc, bc.Location, bc.Map );
		}

		public static bool CheckConvert( BaseCreature bc, Point3D location, Map m )
		{
			if ( Array.IndexOf( Maps, m ) == -1 )
				return false;

			if ( bc is BaseChampion || bc is Harrower || bc is BaseVendor || bc is BaseEscortable || bc is Clone || bc is DrakAuberon )
				return false;
            
			if ( Region.Find( location, m ).IsPartOf( typeof( Server.Regions.WispRegion ) ) )
			   return true;

			int fame = bc.Fame;

			if ( fame > 32000 )
				fame = 32000;

			double chance = ( m == Map.Auberon ) ? 0.4 : 1 / Math.Round( 20.0 - ( fame / 3200 ));
			
			return ( chance > Utility.RandomDouble() );
		}

		public static bool CheckArtifactChance( Mobile m, BaseCreature bc )
		{
			if ( m.Map == Map.Underworld )
				return false;

			double fame = (double)bc.Fame;

			if ( fame > 32000 )
				fame = 32000;

			double chance = 1 / ( Math.Max( 10, 100 * ( 0.83 - Math.Round( Math.Log( Math.Round( fame / 6000, 3 ) + 0.001, 10 ), 3 ) ) ) * ( 100 - Math.Sqrt( m.Luck ) ) / 100.0 );

			return chance > Utility.RandomDouble();
		}

		public static void GiveArtifactTo( Mobile m )
		{
         if ( DungeonRat.IsInsideWisp( m ) )
			{
            Item item = null;
            if ( Utility.RandomDouble() < 0.15 )
               item = (Item)Activator.CreateInstance( ASoullessBlade.ExtraLoot[Utility.Random(ASoullessBlade.ExtraLoot.Length)] );
            else
            {
      			switch( Utility.Random( 20 ) )
      			{
      				case 0: item = new Tokens( Utility.RandomMinMax( 20, 50 ) ); break;
      				case 1: item = new CechovniMince( Utility.RandomMinMax( 10, 20 ) ); break;
      				case 3: item = new CharmOfLuck(); break;
      				case 4: item = new BottledFire( Utility.RandomMinMax( 1, 3 ) ); break;
      				case 5: item = new ArtifactFragment( Utility.RandomMinMax( 1, 3 ) ); break;
      				case 6: item = new GuildCoin( Utility.RandomMinMax( 10, 20 ) ); break;
      				default: item = new Gold( Utility.RandomMinMax( 1000, 20000 ) ); break;
      			}
            }

            m.SendSound( 0x3D );
            Guilds.Guild.GiveXp( m, 350 );
            
            if ( m.AddToBackpack( item ) )
    				m.SendMessage( 0x35,"Odmena za zabiti montra byla umistena do tveho batohu." );
    			else
    				m.SendMessage( 0x35, "Protoze je tvuj batoh plny, odmena za zabiti monstra byla umistena na zem k tvym noham." );
         }
         else
         {
            Guilds.Guild.GiveXp( m, 150 );
            
            Item item = (Item)Activator.CreateInstance( Artifacts[Utility.Random(Artifacts.Length)] );
    
    			if ( m.AddToBackpack( item ) )
    				m.SendMessage( "As a reward for slaying the mighty paragon, an artifact has been placed in your backpack." );
    			else
    				m.SendMessage( "As your backpack is full, your reward for destroying the legendary paragon has been placed at your feet." );
         }
		}
		
		public static void GiveMLArtifactTo( Mobile m )
		{
			Guilds.Guild.GiveXp( m, 250 );
         
         Item item = (Item)Activator.CreateInstance( MLMiniArtifacts[Utility.Random(MLMiniArtifacts.Length)] );
			
         if ( item == null )
				return;

			if ( m.AddToBackpack( item ) )
				m.SendMessage( "As a reward for slaying the mighty monster, an artifact has been placed in your backpack." );
			else
				m.SendMessage( "As your backpack is full, your reward for destroying the mighty monster has been placed at your feet." );
		}
	}
}