using System;
using Server;
using Server.Items;
using Server.Commands;

namespace Server.Mobiles
{
    public class Teragon
    {
        public static double ChestChance = 0.01;         // Chance that a Teragon will carry a Teragon chest
        public static Map[] Maps = new Map[]    // Maps that Teragons will spawn on
		{
            Map.Felucca,
            Map.Auberon
        };

        public static Type[] Artifacts = new Type[]
        {
			//level armor
            typeof( LevelArmorOfFortune ), typeof( LevelGauntletsOfNobility ),
            typeof( LevelHelmOfInsight ), typeof( LevelHolyKnightsBreastplate ),
            typeof( LevelInquisitorsResolution ), typeof( LevelJackalsCollar ),
            typeof( LevelLeggingsOfBane ), typeof( LevelMidnightBracers ),
            typeof( LevelOrnateCrownOfTheHarrower ), typeof( LevelShadowDancerLeggings ),
            typeof( LevelTunicOfFire ), typeof( LevelVoiceOfTheFallenKing ),
            typeof( LevelDaemonArms ), typeof( LevelDaemonGloves ), typeof( LevelDaemonHelm ),
            typeof( LevelDaemonChest ), typeof( LevelDaemonLegs ), typeof( LevelGemmedCirclet ),
            typeof( LevelRangerArms ), typeof( LevelRangerGloves ), typeof( LevelRangerGorget ),
            typeof( LevelRangerChest ), typeof( LevelRangerLegs ), typeof( LevelHornedTribalMask ),
            typeof( LevelTribalMask ),  typeof( LevelGlasses ),
			//level clothing
			typeof( LevelDivineCountenance ), typeof( LevelHatOfTheMagi ),
            typeof( LevelHuntersHeaddress ), typeof( LevelSpiritOfTheTotem ),
			//level sperky
			typeof( LevelBraceletOfHealth ), typeof( LevelRingOfTheElements ),
            typeof( LevelRingOfTheVile ), typeof( LevelOrnamentOfTheMagician ),         
            //level stity
			typeof( LevelAegis ), typeof( LevelArcaneShield ),
            //Level weapons
			typeof( LevelAxeOfTheHeavens ), typeof( LevelBladeOfInsanity ),
            typeof( LevelBladeOfTheRighteous ), typeof( LevelBoneCrusher ),
            typeof( LevelFrostbringer ), typeof( LevelBreathOfTheDead ),
            typeof( LevelLegacyOfTheDreadLord ), typeof( LevelSerpentsFang ),
            typeof( LevelStaffOfTheMagi ), typeof( LevelTheBeserkersMaul ),
            typeof( LevelTheDragonSlayer ), typeof( LevelTheDryadBow ),
            typeof( LevelTheTaskmaster ), typeof( LevelTitansHammer ),
            typeof( LevelZyronicClaw ), typeof( LevelBlightGrippedLongbow ),
            typeof( LevelColdForgedBlade ), typeof( LevelLuminousRuneBlade ),
            typeof( LevelOverseerSunderedBlade ), typeof( LevelPhantomStaff ),
            typeof( LevelRuneCarvingKnife ), typeof( LevelShardThrasher ),
            typeof( LevelSilvanisFeywoodBow ), typeof( LevelTheNightReaper ),
            typeof( LevelTribalSpear ),  typeof( LevelGlacialStaff ),
         //ostatni 
			typeof( WonderousLevelUpScroll ), typeof( ExaltedLevelUpScroll ), typeof( MythicalLevelUpScroll ), typeof( SpendingPointsScroll ),
            typeof( LegendaryLevelUpScroll ), typeof( MonsterStatuette ), typeof( MiniHouseDeed ), typeof( SpellbookBasket ), typeof( ArtifactFragment ),
            typeof( PowerScroll ), typeof( TorchWeapon ), typeof( RandomLevelItemBag ), typeof( RandomGlassesBag ),
            typeof( RandomLevelClothingBag ), typeof( BankCrystal ), typeof( RandomLibraryTalismanBag ),
            typeof( RecipeScrollTinkerNeonRing ), typeof( RecipeScrollCarpMagicFountain ), typeof( RecipeJewelryPolishingSolution ), typeof( SkillBall ), typeof( RandomPlateOfHonorBag ),
            typeof( PSToken ), typeof( ColdBow ), typeof( EnergyBow ), typeof( FireBow ), typeof( PoisonBow ),
            typeof( Glasses ), typeof( ParrotItem ), typeof( PetBondingDeed ), typeof( PetPowerScroll ),
            typeof( RunicBl ), typeof( RunicDa ), typeof( RunicFw ), typeof( CarpRunicFw ), typeof( TinkerRunicBl ),
            typeof( BasketOfHerbs ), typeof( BlessedStatue ), typeof( DragonBrazier ), typeof( CarvedWoodenScreen ), typeof( MongbatDartboard ),
            typeof( HauntedMirrorNDeed ), typeof( HauntedMirrorWDeed ), typeof( SacrificialAltarEastDeed ), typeof( SacrificialAltarSouthDeed ), typeof( MountedDreadHorn ),
            typeof( PegLeghook ), typeof( NobleSword ), typeof( DeathAxe ), typeof( SparrowBlade ), typeof( WyrmSoulBow ), typeof( DyeTester ),
            typeof( ItemBlessDeed ), typeof( HoodedShroudOfShadows ), typeof( SoulStone ), typeof( CrimsonCinture ), typeof( MagicScroll ), typeof( MagicalWire )
            /*typeof( CharmOfCorpseExplosion ), typeof( ShamansMask ), typeof( CharmOfColdSnap ), typeof( Eradicator ), typeof( DyeRackDeed ), typeof( SilverWovenTShirt )*/
		};

        public static Type[] KhaldunArtifacts = new Type[]
        {
            typeof( Brick ), typeof( HurdyGurdy ), typeof( ArtifactFragment ), typeof( HealingCloudJug ), typeof( CharmOfCorpseExplosion ), typeof( CharmOfColdSnap )
        };

        public static Type[] TalentArtifacts = new Type[]
        {
            typeof( MagicalWire ), typeof( SlzaAuberonu ), typeof( MesicniKamen ), typeof( SelfRepairOil ),
            typeof( ScrollOfVirtue ), typeof( DyeThinner ), typeof( ArcaneDust ),
            typeof( LegendaryLevelUpScroll ), typeof( CharmOfLuck ), typeof( LestidloNaBotySDI ),
            typeof( ClothingSkillScroll ), typeof( ArtifactFragment ), typeof( EyeOfNewt ), typeof( LestidloNaBotyDI ),
            typeof( ScrollOfKo ), typeof( JewelryPolishingSolution ), typeof( SpendingPointsScroll ),
			typeof( MagicScroll )
        };

        public static int hue = 1276;        // Teragon hue

        // Buffs
        public static double HitsBuff = 7.9;
        public static double StrBuff = 1.70;
        public static double IntBuff = 1.95;
        public static double DexBuff = 1.40;
        public static double SkillsBuff = 2.20;
        public static double SpeedBuff = 1.40;
        public static double FameBuff = 2.00;
        public static double KarmaBuff = 2.00;
        public static int DamageBuff = 9;

        public static void Convert(BaseCreature bc)
        {
            if (bc.IsTeragon)
                return;

            // 			if ( ((Mobile)bc).Map == Map.Felucca )
            //             bc.Hue = hue;

            if (bc.HitsMaxSeed >= 0)
                bc.HitsMaxSeed = (int)(bc.HitsMaxSeed * HitsBuff);

            bc.RawStr = (int)(bc.RawStr * StrBuff);
            bc.RawInt = (int)(bc.RawInt * IntBuff);
            bc.RawDex = (int)(bc.RawDex * DexBuff);

            bc.Hits = bc.HitsMax;
            bc.Mana = bc.ManaMax;
            bc.Stam = bc.StamMax;

            for (int i = 0; i < bc.Skills.Length; i++)
            {
                Skill skill = (Skill)bc.Skills[i];

                if (skill.Base > 0.0)
                    skill.Base *= SkillsBuff;
            }

            bc.PassiveSpeed /= SpeedBuff;
            bc.ActiveSpeed /= SpeedBuff;

            bc.DamageMin += DamageBuff;
            bc.DamageMax += DamageBuff;

            if (bc.Fame > 0)
                bc.Fame = (int)(bc.Fame * FameBuff);

            if (bc.Fame > 32000)
                bc.Fame = 32000;

            // TODO: Mana regeneration rate = Sqrt( buffedFame ) / 4

            if (bc.Karma != 0)
            {
                bc.Karma = (int)(bc.Karma * KarmaBuff);

                if (Math.Abs(bc.Karma) > 32000)
                    bc.Karma = 32000 * Math.Sign(bc.Karma);
            }
        }

        public static void UnConvert(BaseCreature bc)
        {
            if (!bc.IsTeragon)
                return;

            // 			bc.Hue = 0;

            if (bc.HitsMaxSeed >= 0)
                bc.HitsMaxSeed = (int)(bc.HitsMaxSeed / HitsBuff);

            bc.RawStr = (int)(bc.RawStr / StrBuff);
            bc.RawInt = (int)(bc.RawInt / IntBuff);
            bc.RawDex = (int)(bc.RawDex / DexBuff);

            bc.Hits = bc.HitsMax;
            bc.Mana = bc.ManaMax;
            bc.Stam = bc.StamMax;

            for (int i = 0; i < bc.Skills.Length; i++)
            {
                Skill skill = (Skill)bc.Skills[i];

                if (skill.Base > 0.0)
                    skill.Base /= SkillsBuff;
            }

            bc.PassiveSpeed *= SpeedBuff;
            bc.ActiveSpeed *= SpeedBuff;

            bc.DamageMin -= DamageBuff;
            bc.DamageMax -= DamageBuff;

            if (bc.Fame > 0)
                bc.Fame = (int)(bc.Fame / FameBuff);
            if (bc.Karma != 0)
                bc.Karma = (int)(bc.Karma / KarmaBuff);
        }

        public static bool CheckConvert(BaseCreature bc)
        {
            return CheckConvert(bc, bc.Location, bc.Map);
        }

        public static bool CheckConvert(BaseCreature bc, Point3D location, Map m)
        {
            if (!Core.AOS)
                return false;

            if (Array.IndexOf(Maps, m) == -1)
                return false;

            if (bc is BaseVendor || bc is BaseEscortable || bc is Clone || bc is Harrower || bc is HarrowerTentacles || bc is DrakAuberon) //bc is BaseChampion || bc is Harrower || 
                return false;

            // 			int fame = bc.Fame;
            // 
            // 			if ( fame > 32000 )
            // 				fame = 32000;

            double chance = 0.25;// 3 / Math.Round( 20.0 - ( fame / 3200 ));

            return (chance > Utility.RandomDouble());
        }

        public static bool CheckArtifactChance(Mobile m, BaseCreature bc)
        {
            if (m.Map == Map.Underworld)
                return false;

            double fame = (double)bc.Fame;
            int luck = m.Luck;

            if (fame > 20000)
                fame = 20000;

            if (luck > 3000)
                luck = 3000;

            double chance = 1 / (Math.Max(10, 100 * (0.83 - Math.Round(Math.Log(Math.Round(fame / 6000, 3) + 0.001, 10), 3))) * (100 - Math.Sqrt(luck)) / 100.0);
            double deleno = 30.0;

            if ((chance / 10.0) > Utility.RandomDouble() && DungeonRat.IsInsideWisp(m))
                Paragon.GiveArtifactTo(m);

            if (m is PlayerMobile)
            {
                PlayerMobile.TalentEntry te = ((PlayerMobile)m).GetTalent(PlayerMobile.TalentType.StestiPripraveneho);

                int cost = (int)fame / 10;

                if (cost > 1000)
                    cost = Utility.RandomMinMax(700, 1000);

                if (te != null && te.Enabled && te.Charges >= cost)
                {
                    te.Charges -= cost;

                    deleno = 20.0;
                }
            }

            return (chance / deleno) > Utility.RandomDouble();
        }

        public static void GiveArtifactTo(Mobile m, BaseCreature bc)
        {
            PlayerTitles.TitleProgress(m, "collector", 1);

            Item item;
            bool talentActive = false;

            if (m is PlayerMobile)
            {
                PlayerMobile.TalentEntry te = ((PlayerMobile)m).GetTalent(PlayerMobile.TalentType.StestiPripraveneho);

                if (te != null && te.Enabled && Utility.RandomDouble() < 0.35)
                {
                    talentActive = true;
                }
            }

            if (!KhaldunRevenant.IsInsideKhaldun(bc))
            {
                Guilds.Guild.GiveXp(m, 10000);
                item = talentActive ? (Item)Activator.CreateInstance(TalentArtifacts[Utility.Random(TalentArtifacts.Length)]) : (Item)Activator.CreateInstance(Artifacts[Utility.Random(Artifacts.Length)]);
                World.Broadcast(37, true, "{0} ziskava artefakt za zabiti mocneho Teragona!", m.RawName);
                LogIt.WriteLine("Teragons arties", m, "{0} ziskava artefakt {1} z {2} [t.Fame: {3}, p.Luck: {4}]", m.RawName, CommandLogging.Format(item), bc, bc.Fame, m.Luck);
            }
            else
            {
                Guilds.Guild.GiveXp(m, 15000);
                item = talentActive ? (Item)Activator.CreateInstance(TalentArtifacts[Utility.Random(TalentArtifacts.Length)]) : (Item)Activator.CreateInstance(KhaldunArtifacts[Utility.Random(KhaldunArtifacts.Length)]);

                if (!talentActive)
                    item.BlessedFor = m;

                World.Broadcast(37, true, "{0} ziskava artefakt z dungeonu Khaldun!", m.RawName);
                LogIt.WriteLine("Khaldun arties", m, "{0} ziskava artefakt {1} z {2} [t.Fame: {3}, p.Luck: {4}]", m.RawName, CommandLogging.Format(item), bc, bc.Fame, m.Luck);
            }

            if (item is BaseTool)
                ((BaseTool)item).UsesRemaining = 25;
            else if (item is PSToken || item is SpendingPointsScroll || item is EyeOfNewt || item is ArtifactFragment || item is MesicniKamen)
                item.Amount = 5;

            m.SendSound(0x3D);

            if (m.AddToBackpack(item))
                m.SendMessage("Odmena za zabiti Teragona byla umistena do tveho batohu.");
            else
                m.SendMessage("Protoze je tvuj batoh plny, odmena za zabiti Teragona byla umistena na zem k tvym noham.");
        }
    }
}