using System;
using Server;
using Server.Items;
using Server.Network;
using Server.Mobiles;
using Server.Engines.BulkOrders;
using System.Collections;

namespace Server.Engines.XmlSpawner2
{
	public class BODModule : XmlAttachment
	{
		private DateTime m_NextFletcherBulkOrder;
		private DateTime m_NextCarpenterBulkOrder;

		[CommandProperty( AccessLevel.GameMaster )]
		public TimeSpan NextFletcherBulkOrder
		{
			get
			{
				TimeSpan ts = m_NextFletcherBulkOrder - DateTime.Now;
				
				if ( ts < TimeSpan.Zero )
					ts = TimeSpan.Zero;
				
				return ts;
			}
			set
			{
				try{ m_NextFletcherBulkOrder = DateTime.Now + value; }
				catch{}
			}
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public TimeSpan NextCarpenterBulkOrder
		{
			get
			{
				TimeSpan ts = m_NextCarpenterBulkOrder - DateTime.Now;
				
				if ( ts < TimeSpan.Zero )
					ts = TimeSpan.Zero;
				
				return ts;
			}
			set
			{
				try{ m_NextCarpenterBulkOrder = DateTime.Now + value; }
				catch{}
			}
		}

		public BODModule(ASerial serial) : base(serial)
		{
		}

		[Attachable]
		public BODModule()
		{
		    Name = "BODs";
          m_BOBFilter = new Engines.BulkOrders.BOBFilter();
		}
		
		private Engines.BulkOrders.BOBFilter m_BOBFilter;
		
		public Engines.BulkOrders.BOBFilter BOBFilter
		{
			get{ return m_BOBFilter; }
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize(writer);

			writer.Write( (int) 0 );
			// version 0
			writer.Write( NextFletcherBulkOrder );
			writer.Write( NextCarpenterBulkOrder );
			m_BOBFilter.Serialize( writer );
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			// version 0
			int version = reader.ReadInt();
			
			NextFletcherBulkOrder = reader.ReadTimeSpan();
			NextCarpenterBulkOrder = reader.ReadTimeSpan();
			m_BOBFilter = new Engines.BulkOrders.BOBFilter( reader );
			
			if ( m_BOBFilter == null )
				m_BOBFilter = new Engines.BulkOrders.BOBFilter();
		}
	}
}
