using System;
using System.Collections;
using Server;
using Server.Gumps;
using Server.Items;
using Server.Mobiles;

namespace Server.Engines.BulkOrders
{
	public class BOBFilterGump : Gump
	{
		private PlayerMobile m_From;
		private BulkOrderBook m_Book;
        private GumpMaterial m_GumpMaterial;

		private const int LabelColor = 0x7FFF;

        #region Nove filtry a offsety

        private static int[] m_XOffsets_NewMaterial = new int[] { 0, 115, 230, 345 };
        private static int[] m_XWidths_NewMaterial = new int[] { 110, 110, 110, 110 };
        private static int[] m_XOffsets_Skills = new int[] { 0 };
        private static int[] m_XWidths_Sklils = new int[] { 100 };

        private static int[,] m_SkillFilters = new int[,]
            {
                { 1044067, 1 },
                { 1002155, 2 },
                { 1015156, 49 },
                { 1002054, 50 }
            };

        private static int[,] m_BlacksmithingFilters = new int[,]
            {
                { 1062226,  3 }, // Iron
                { 1018335,  7 }, // Bronze
                { 1018339, 11 }, // Valorite
                {       0, 15 }, // Obsidian

                { 1018332,  4 }, // Dull Copper
                { 1018336,  8 }, // Golden
                {       0, 12 }, // Silver
                {       0, 16 }, // Jade

                { 1018333,  5 }, // Shadow Iron
                { 1018337,  9 }, // Agapite
                {       0, 13 }, // Platinum
                {       0, 17 }, // Moonstone 

                { 1018334,  6 }, // Copper
                { 1018338, 10 }, // Verite
                {       0, 14 }, // Mythril	   
            };

        private static int[,] m_TailoringFilters = new int[,]
            {
                { 1044286, 20 }, // Cloth
                { 1062238, 24 }, // Barbed
                { 0, 0 },
                { 0, 0 },

				{ 1062235, 21 }, // Leather
                {	0, 25 }, // Dragon
                { 0, 0 },
                { 0, 0 },

				{ 1062236, 22 }, // Spined
                {	0, 26 }, // Daemon
                { 0, 0 },
                { 0, 0 },

				{ 1062237, 23 }, // Horned
            };

        private static int[,] m_FletchingFilters = new int[,]
            {
                {0,27},//Wood
                {0,31},//Mahogany
                {0,35},//Heartwood
                { 0, 0 },

                {0,28},//Pine
                {0,32},//Oak
                {0,36},//Bloodwood
                { 0, 0 },

                {0,29},//Cedar
                {0,33},//Ash
                {0,37},//Frostwood
                { 0, 0 },

                {0,30},//Cherry
                {0,34},//Yew 
            };

        private static int[,] m_CarpentryFilters = new int[,]
            {
                {0,38},//Wood
                {0,42},//Mahogany
                {0,46},//Heartwood
                { 0, 0 },

                {0,39},//Pine
                {0,43},//Oak
                {0,47},//Bloodwood
                { 0, 0 },

                {0,40},//Cedar
                {0,44},//Ash
                {0,48},//Frostwood
                { 0, 0 },

                {0,41},//Cherry
                {0,45},//Yew 
            };

		private static int[,] m_NewMaterialFilters = new int[,]
			{
                { 0, 0},
				{ 1044067,  1 }, // Blacksmithy
                { 1044094,  2 }, // Tailoring
				{ 1062226,  3 }, // Iron
				{ 1018332,  4 }, // Dull Copper
				{ 1018333,  5 }, // Shadow Iron
				{ 1018334,  6 }, // Copper
				{ 1018335,  7 }, // Bronze

				//{       0,  0 }, // --Blank--
				{ 1018336,  8 }, // Golden
				{ 1018337,  9 }, // Agapite
				{ 1018338, 10 }, // Verite
				{ 1018339, 11 }, // Valorite
				{       0, 12 }, // Silver
				
				//{       0,  0 }, // --Blank--
				{       0, 13 }, // Platinum
				{       0, 14 }, // Mythril
				{       0, 15 }, // Obsidian
				{       0, 16 }, // Jade
				{       0, 17 }, // Moonstone
				
				//{       0,  0 }, // --Blank--
				{	0, 18 }, // Sunstone
				{	0, 19 }, // Bloodstone
				//{	0,  0 }, // --Blank--
				//{	0,  0 }, // --Blank--
				//{       0,  0 }, // --Blank--

				
				{ 1044286, 20 }, // Cloth
				{ 1062235, 21 }, // Leather
				{ 1062236, 22 }, // Spined
				{ 1062237, 23 }, // Horned
				{ 1062238, 24 }, // Barbed				
				
				//{       0,  0 }, // --Blank--
				{	0, 25 }, // Dragon
				{	0, 26 }, // Daemon
				//{       0,  0 }, // --Blank--
				//{       0,  0 }	 // --Blank--

                {0,27},//Wood
                {0,28},//Pine
                {0,29},//Cedar
                {0,30},//Cherry
                {0,31},//Mahogany
                {0,32},//Oak
                {0,33},//Ash
                {0,34},//Yew 
                {0,35},//Heartwood
                {0,36},//Bloodwood
                {0,37},//Frostwood

                {0,38},//Wood
                {0,39},//Pine
                {0,40},//Cedar
                {0,41},//Cherry
                {0,42},//Mahogany
                {0,43},//Oak
                {0,44},//Ash
                {0,45},//Yew 
                {0,46},//Heartwood
                {0,47},//Bloodwood
                {0,48},//Frostwood

                {0, 49}, //fletching
                {0, 50} //carpentry

			};

        #endregion

        private static int[,] m_MaterialFilters = new int[,]
			{
				{ 1044067,  1 }, // Blacksmithy
				{ 1062226,  3 }, // Iron
				{ 1018332,  4 }, // Dull Copper
				{ 1018333,  5 }, // Shadow Iron
				{ 1018334,  6 }, // Copper
				{ 1018335,  7 }, // Bronze

				{       0,  0 }, // --Blank--
				{ 1018336,  8 }, // Golden
				{ 1018337,  9 }, // Agapite
				{ 1018338, 10 }, // Verite
				{ 1018339, 11 }, // Valorite
				{       0, 12 }, // Silver
				
				{       0,  0 }, // --Blank--
				{       0, 13 }, // Platinum
				{       0, 14 }, // Mythril
				{       0, 15 }, // Obsidian
				{       0, 16 }, // Jade
				{       0, 17 }, // Moonstone
				
				{       0,  0 }, // --Blank--
				{	0, 18 }, // Sunstone
				{	0, 19 }, // Bloodstone
				{	0,  0 }, // --Blank--
				{	0,  0 }, // --Blank--
				{       0,  0 }, // --Blank--

				{ 1044094,  2 }, // Tailoring
				{ 1044286, 20 }, // Cloth
				{ 1062235, 21 }, // Leather
				{ 1062236, 22 }, // Spined
				{ 1062237, 23 }, // Horned
				{ 1062238, 24 }, // Barbed				
				
				{       0,  0 }, // --Blank--
				{	0, 25 }, // Dragon
				{	0, 26 }, // Daemon
				{       0,  0 }, // --Blank--
				{       0,  0 }	 // --Blank--
			};

		private static int[,] m_TypeFilters = new int[,]
			{
				{ 1062229, 0 }, // All
				{ 1062224, 1 }, // Small
				{ 1062225, 2 }  // Large
			};

		private static int[,] m_QualityFilters = new int[,]
			{
				{ 1062229, 0 }, // All
				{ 1011542, 1 }, // Normal
				{ 1060636, 2 }  // Exceptional
			};

		private static int[,] m_AmountFilters = new int[,]
			{
				{ 1062229, 0 }, // All
				{ 1049706, 1 }, // 10
				{ 1016007, 2 }, // 15
				{ 1062239, 3 }  // 20
			};

		private static int[][,] m_Filters = new int[][,]
			{
				m_TypeFilters,
				m_QualityFilters,
				m_NewMaterialFilters, //m_MaterialFilters, nahrazeno novym kompletnim seznamem materialu
				m_AmountFilters
			};

		private static int[] m_XOffsets_Type = new int[]{ 0, 75, 170 };
		private static int[] m_XOffsets_Quality = new int[]{ 0, 75, 170 };
		private static int[] m_XOffsets_Amount = new int[]{ 0, 75, 180, 275 };
		private static int[] m_XOffsets_Material = new int[]{ 0, 105, 210, 305, 390, 485 };

		private static int[] m_XWidths_Small = new int[]{ 50, 50, 70, 50 };
		private static int[] m_XWidths_Large = new int[]{ 80, 50, 50, 50, 50, 50 };

		private void AddFilterList( int x, int y, int[] xOffsets, int yOffset, int[,] filters, int[] xWidths, int filterValue, int filterIndex )
		{
			for ( int i = 0; i < filters.GetLength( 0 ); ++i )
			{
				int number = filters[i, 0];

				bool isSelected = ( filters[i, 1] == filterValue );

				if ( !isSelected && (i % xOffsets.Length) == 0 )
					isSelected = ( filterValue == 0 );

                //oznaceni aktulaniho odvetvi
                if (filterValue > 0)
                {
                    if (filters[i, 1] == 1 && filterValue < 20 && filterValue > 2)
                        isSelected = true;
                    else if (filters[i, 1] == 2 && filterValue < 27 && filterValue >= 20)
                        isSelected = true;
                    else if (filters[i, 1] == 49 && filterValue < 38 && filterValue >= 27 )
                        isSelected = true;
                    else if (filters[i, 1] == 50 && filterValue < 49 && filterValue >= 38)
                        isSelected = true;
                }
						
				if ( number == 0 && filters[i, 1] == 0 )
					continue;
				else switch (filters[i, 1])
					 {
						 case 12:
						 {
							 AddHtml( x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Silver" : "<basefont color=#FFFFFF>Silver", false, false );
							 AddButton( x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0 ); continue;	
						 }
						 case 13:
						 {
							 AddHtml( x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Platinum" : "<basefont color=#FFFFFF>Platinum", false, false );
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;	
						 }
						 case 14:
						 {
							 AddHtml( x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Mythril" : "<basefont color=#FFFFFF>Mythril", false, false );
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;	
						 }
						 case 15:
						 {
							 AddHtml( x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Obsidian" : "<basefont color=#FFFFFF>Obsidian", false, false );
							 AddButton( x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0 ); continue;	
						 }
						 case 16:
						 {
							 AddHtml( x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Jade" : "<basefont color=#FFFFFF>Jade", false, false );
							 AddButton( x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0 ); continue;	
						 }
						 case 17:
						 {
							 AddHtml( x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Moonstone" : "<basefont color=#FFFFFF>Moonstone", false, false );
							 AddButton( x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0 ); continue;	
						 }
						 case 18:
						 {
							 AddHtml( x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Sunstone" : "<basefont color=#FFFFFF>Sunstone", false, false );
							 AddButton( x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0 ); continue;	
						 }
						 case 19:
						 {
							 AddHtml( x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Bloodstone" : "<basefont color=#FFFFFF>Bloodstone", false, false );
							 AddButton( x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0 ); continue;	
						 }
						 case 25:
						 {
							 AddHtml( x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Dragon" : "<basefont color=#FFFFFF>Dragon", false, false );
							 AddButton( x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0 ); continue;	
						 }
						 case 26:
						 {
							 AddHtml( x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Daemon" : "<basefont color=#FFFFFF>Daemon", false, false );
							 AddButton( x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0 ); continue;	
						 }
						
                        //dreva fletching
                         case 27:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Wood" : "<basefont color=#FFFFFF>Wood", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }
                         case 28:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Pine" : "<basefont color=#FFFFFF>Pine", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }
                         case 29:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Cedar" : "<basefont color=#FFFFFF>Cedar", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }
                         case 30:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Cherry" : "<basefont color=#FFFFFF>Cherry", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }
                         case 31:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Mahogany" : "<basefont color=#FFFFFF>Mahogany", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }
                         case 32:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Oak" : "<basefont color=#FFFFFF>Oak", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }
                         case 33:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Ash" : "<basefont color=#FFFFFF>Ash", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }
                         case 34:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Yew" : "<basefont color=#FFFFFF>Yew", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }
                         case 35:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Heartwood" : "<basefont color=#FFFFFF>Heartwood", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }
                         case 36:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Bloodwood" : "<basefont color=#FFFFFF>Bloodwood", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }
                         case 37:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Frostwood" : "<basefont color=#FFFFFF>Frostwood", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }

                        //dreva carpentry

                         case 38:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Wood" : "<basefont color=#FFFFFF>Wood", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }
                         case 39:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Pine" : "<basefont color=#FFFFFF>Pine", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }
                         case 40:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Cedar" : "<basefont color=#FFFFFF>Cedar", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }
                         case 41:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Cherry" : "<basefont color=#FFFFFF>Cherry", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }
                         case 42:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Mahogany" : "<basefont color=#FFFFFF>Mahogany", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }
                         case 43:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Oak" : "<basefont color=#FFFFFF>Oak", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }
                         case 44:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Ash" : "<basefont color=#FFFFFF>Ash", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }
                         case 45:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Yew" : "<basefont color=#FFFFFF>Yew", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }
                         case 46:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Heartwood" : "<basefont color=#FFFFFF>Heartwood", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }
                         case 47:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Bloodwood" : "<basefont color=#FFFFFF>Bloodwood", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }
                         case 48:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Frostwood" : "<basefont color=#FFFFFF>Frostwood", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }

                        //complet fletching a carpentry
                         case 49:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Fletching" : "<basefont color=#FFFFFF>Fletching", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }
                         case 50:
                         {
                             AddHtml(x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, isSelected ? "<basefont color=#8484FF>Carpentry" : "<basefont color=#FFFFFF>Carpentry", false, false);
                             AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0); continue;
                         }

					 }

				AddHtmlLocalized( x + 35 + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), xWidths[i % xOffsets.Length], 32, number, isSelected ? 16927 : LabelColor, false, false );
                AddButton(x + xOffsets[i % xOffsets.Length], y + ((i / xOffsets.Length) * yOffset), 4005, 4007, 4 + filterIndex + ((filters[i, 1]) * 4), GumpButtonType.Reply, 0);
			}
		}

		public override void OnResponse( Server.Network.NetState sender, RelayInfo info )
		{
			BOBFilter f = ( m_From.UseOwnFilter ? m_From.BOBFilter : m_Book.Filter );

			int index = info.ButtonID;

			switch ( index )
			{
				case 0: // Apply
				{
					m_From.SendGump( new BOBGump( m_From, m_Book ) );

					break;
				}
				case 1: // Set Book Filter
				{
					m_From.UseOwnFilter = false;
					m_From.SendGump( new BOBFilterGump( m_From, m_Book ) );

					break;
				}
				case 2: // Set Your Filter
				{
					m_From.UseOwnFilter = true;
					m_From.SendGump( new BOBFilterGump( m_From, m_Book ) );

					break;
				}
				case 3: // Clear Filter
				{
					f.Clear();
					m_From.SendGump( new BOBFilterGump( m_From, m_Book ) );

					break;
				}
				default:
				{
					index -= 4; //snulovani indexu

					int type = index % 4; // urci typ filtru = type, quality, material, quantity
					
                    index /= 4;

					if ( type >= 0 && type < m_Filters.Length )
					{
						int[,] filters = m_Filters[type];

						if ( index >= 0 && index < filters.GetLength( 0 ) )
						{
							if ( filters[index, 0] == 0 && filters[index, 1] == 0 )
								break;

							switch ( type )
							{
								case 0: f.Type = filters[index, 1]; break;
								case 1: f.Quality = filters[index, 1]; break;
								case 2: f.Material = filters[index, 1]; break;
								case 3: f.Quantity = filters[index, 1]; break;
							}

							m_From.SendGump( new BOBFilterGump( m_From, m_Book ) );
						}
					}

					break;
				}
			}
		}


        public enum GumpMaterial : byte
        {
            All,
            Blacksmithing,
            Tailoring,
            Fletching,
            Carpentry
        }

		public BOBFilterGump( PlayerMobile from, BulkOrderBook book ) : base( 12, 24 )
		{
			from.CloseGump( typeof( BOBGump ) );
			from.CloseGump( typeof( BOBFilterGump ) );

			m_From = from;
			m_Book = book;

			BOBFilter f = ( from.UseOwnFilter ? from.BOBFilter : book.Filter );

			AddPage( 0 );

			AddBackground( 10, 10, 630, 439, 5054 );

			AddImageTiled( 18, 20, 613, 420, 2624 );
			AddAlphaRegion( 18, 20, 613, 420 );

			AddImage( 5, 5, 10460 );
			AddImage( 615, 5, 10460 );
			AddImage( 5, 424, 10460 );
			AddImage( 615, 424, 10460 );

			AddHtmlLocalized( 270, 20, 200, 32, 1062223, LabelColor, false, false ); // Filter Preference

			AddHtmlLocalized( 26, 35, 120, 32, 1062228, LabelColor, false, false ); // Bulk Order Type
			AddFilterList( 25, 61, m_XOffsets_Type, 40, m_TypeFilters, m_XWidths_Small, f.Type, 0 );

			AddHtmlLocalized( 320, 35, 50, 32, 1062215, LabelColor, false, false ); // Quality
			AddFilterList( 320, 61, m_XOffsets_Quality, 40, m_QualityFilters, m_XWidths_Small, f.Quality, 1 );

            //zobrazuje stalou nabidku vyrobnich odvetvi
            AddFilterList(25, 152, m_XOffsets_Skills, 40, m_SkillFilters, m_XWidths_Sklils, f.Material, 2);

            if (f.Material > 0)
            {
                AddHtmlLocalized(170, 120, 120, 32, 1062232, LabelColor, false, false); // Material Type

                //vyber materialu
                if (f.Material < 20 && f.Material != 2)
                    AddFilterList(170, 152, m_XOffsets_NewMaterial, 40, m_BlacksmithingFilters, m_XWidths_NewMaterial, f.Material, 2);
                else if (f.Material < 27)
                    AddFilterList(170, 152, m_XOffsets_NewMaterial, 40, m_TailoringFilters, m_XWidths_NewMaterial, f.Material, 2);
                else if (f.Material < 38 || f.Material == 49)
                    AddFilterList(170, 152, m_XOffsets_NewMaterial, 40, m_FletchingFilters, m_XWidths_NewMaterial, f.Material, 2);
                else if (f.Material < 49 || f.Material == 50)
                    AddFilterList(170, 152, m_XOffsets_NewMaterial, 40, m_CarpentryFilters, m_XWidths_NewMaterial, f.Material, 2);
            }

			//AddFilterList( 170, 132, m_XOffsets_Material, 40, m_MaterialFilters, m_XWidths_Large, f.Material, 2 );

			AddHtmlLocalized( 26, 350, 120, 32, 1062217, LabelColor, false, false ); // Amount
			AddFilterList( 25, 372, m_XOffsets_Amount, 40, m_AmountFilters, m_XWidths_Small, f.Quantity, 3 );

			AddHtmlLocalized( 75, 416, 120, 32, 1062477, ( from.UseOwnFilter ? LabelColor : 16927 ), false, false ); // Set Book Filter
			AddButton( 40, 416, 4005, 4007, 1, GumpButtonType.Reply, 0 );

			AddHtmlLocalized( 235, 416, 120, 32, 1062478, ( from.UseOwnFilter ? 16927 : LabelColor ), false, false ); // Set Your Filter
			AddButton( 200, 416, 4005, 4007, 2, GumpButtonType.Reply, 0 );

			AddHtmlLocalized( 405, 416, 120, 32, 1062231, LabelColor, false, false ); // Clear Filter
			AddButton( 370, 416, 4005, 4007, 3, GumpButtonType.Reply, 0 );

			AddHtmlLocalized( 540, 416, 50, 32, 1011046, LabelColor, false, false ); // APPLY
			AddButton( 505, 416, 4017, 4018, 0, GumpButtonType.Reply, 0 );
		}
	}
}