using System;
using Server.Items;
using Server.Multis;
using Server.Engines.Plants;

namespace Server.Engines.Craft
{
	#region Mondain's Legacy
	public enum CarpRecipes
	{
		// start RecipeScrollMLCarp 100-119
		WarriorStatueSouth 		= 100,
		WarriorStatueEast 		= 101,
		SquirrelStatueSouth 	= 102,
		SquirrelStatueEast 		= 103,
		ElvenAlchemyTable 			= 104,
		OrnateElvenChair 		= 105,
		ArcaneBookshelfSouth	= 106,
		ArcaneBookshelfEast		= 107,
		OrnateElvenChest		= 108,
		ElvenDresserSouth		= 109,
		ElvenDresserEast		= 110,
		FancyElvenArmoire		= 111,
		ArcanistsWildStaff 		= 112,
		AncientWildStaff		= 113,
		ThornedWildStaff 		= 114,
		HardenedWildStaff 		= 115,
		TallElvenBedSouth 		= 116,
		TallElvenBedEast 		= 117,
		StoneAnvilSouth			= 118,
		StoneAnvilEast			= 119,
		// end RecipeScrollMLCarp

		// start RecipeScrollCarpBoxes 120-149
		BlackSmithBox 			= 120,
		TailoringBox 			= 121,
		WoodBox 			= 122,
		MasonryBox 			= 123,
		ScaleBox 			= 124,
		MarbleBox 			= 125,
		SeedBox 			= 126,
		GemBox 			= 127,
		// end RecipeScrollCarpBoxes

		// start RecipeScrollMLCarpArties 150-159
		PhantomStaff 			= 150,
		IronwoodCrown 			= 151,
		BrambleCoat 			= 152,
		// end RecipeScrollMLCarpArties

		MagicFountain 			= 160,
		MagicalFishingPole 			= 161
	}

	#endregion

	public class DefCarpentry : CraftSystem
	{

		public override SkillName MainSkill
		{

			get	{ return SkillName.Carpentry;	}
		}

		public override int GumpTitleNumber
		{

			get { return 1044004; } // <CENTER>CARPENTRY MENU</CENTER>
		}

		private static CraftSystem m_CraftSystem;

		public static CraftSystem CraftSystem
		{

			get
			{

				if ( m_CraftSystem == null )
					m_CraftSystem = new DefCarpentry();

				return m_CraftSystem;
			}
		}

		public override CraftECA ECA { get { return CraftECA.ChanceMinusSixtyToFourtyFive; } }

		public override double GetChanceAtMin( CraftItem item )
		{

			return 0.5; // 50%
		}

		public override bool RetainsColorFrom( CraftItem item, Type type )
		{

			return true;
		}

		private DefCarpentry() : base( 1, 1, 1.25 )// base( 1, 1, 3.0 )
		{
		}

		public override int CanCraft( Mobile from, BaseTool tool, Type itemType )
		{

			if( tool == null || tool.Deleted || tool.UsesRemaining < 0 )
				return 1044038; // You have worn out your tool!
			else if ( !BaseTool.CheckTool( tool, from ) )
				return 1048146; // If you have a tool equipped, you must use that tool.
			else if ( !BaseTool.CheckAccessible( tool, from ) )
				return 1044263; // The tool must be on your person to use.

			return 0;
		}

		public override void PlayCraftEffect( Mobile from )
		{
			// no animation
			//if ( from.Body.Type == BodyType.Human && !from.Mounted )
			//	from.Animate( 9, 5, 1, true, false, 0 );

			from.PlaySound( 0x23D );
		}

		public override int PlayEndingEffect( Mobile from, bool failed, bool lostMaterial, bool toolBroken, int quality, bool makersMark, CraftItem item )
		{

			if ( toolBroken )
				from.SendLocalizedMessage( 1044038 ); // You have worn out your tool

			if ( failed )
			{

				if ( lostMaterial )
					return 1044043; // You failed to create the item, and some of your materials are lost.
				else
					return 1044157; // You failed to create the item, but no materials were lost.
			}
			else
			{

				if ( quality == 0 )
					return 502785; // You were barely able to make this item.  It's quality is below average.
				else if ( makersMark && quality == 2 )
					return 1044156; // You create an exceptional quality item and affix your maker's mark.
				else if ( quality == 2 )
					return 1044155; // You create an exceptional quality item.
				else
					return 1044154; // You create the item.
			}
		}

		public override void InitCraftList()
		{

			int index = -1;

			// Other Items
			index =	AddCraft( typeof( Board ),				1044294, 1027127,	 0.0,   0.0,	typeof( Log ), 1044466,  1, 1044465 );
			SetUseAllRes( index, true );

			AddCraft( typeof( BarrelStaves ),				1044294, 1027857,	00.0,  25.0,	typeof( Log ), 1044041,  5, 1044351 );
			AddCraft( typeof( BarrelLid ),					1044294, 1027608,	11.0,  36.0,	typeof( Log ), 1044041,  4, 1044351 );

			index = AddCraft( typeof( MagicWallToolKit ), 1044294, "magic wall tool kit", 100.0, 150.0, typeof( RunedSwitch ), 1072896, 1, 1053098 ); //This is in the categor of Other during AoS
			AddSkill( index, SkillName.Tinkering, 75.0, 150.0 );
		   AddRes( index, typeof( ScrollOfSuccess ), "scroll of success", 3, 1044253 );
		   AddRes( index, typeof( MimicShard ), "mimic shard", 5, 1044253);
		   AddRes( index, typeof( CharmOfLuck ), "charm of luck", 5, 1044253 );
		   SetNoUWMap( index, true );

			AddCraft( typeof( ShortMusicStand ),				1044294, 1044313,	78.9, 103.9,	typeof( Log ), 1044041, 15, 1044351 );
			AddCraft( typeof( TallMusicStand ),				1044294, 1044315,	81.5, 106.5,	typeof( Log ), 1044041, 20, 1044351 );
			// 			AddCraft( typeof( Easle ),					1044294, 1044317,	86.8, 111.8,	typeof( Log ), 1044041, 20, 1044351 );
			AddCraft( typeof( Torch ),		1044294, 1022578,	25.0,  35.0,	typeof( Log ), 1044041,  1, 1044351 );
			index = AddCraft( typeof( WoodenDecoSign ), 1044294, 1023023, 85.0, 110.0, typeof( Log ), 1044041, 5, 1044351 );
			AddRes( index, typeof( Taint ), 1032679, 2, 1053098 );

         if( Core.SE )
			{

				index = AddCraft( typeof( RedHangingLantern ), 1044294, 1029412, 65.0, 90.0, typeof( Log ), 1044041, 5, 1044351 );
				AddRes( index, typeof( BlankScroll ), 1044377, 10, 1044378 );
				SetNeededExpansion( index, Expansion.SE );

				index = AddCraft( typeof( WhiteHangingLantern ), 1044294, 1029416, 65.0, 90.0, typeof( Log ), 1044041, 5, 1044351 );
				AddRes( index, typeof( BlankScroll ), 1044377, 10, 1044378 );
				SetNeededExpansion( index, Expansion.SE );

				index = AddCraft( typeof( ShojiScreen ), 1044294, 1029423, 80.0, 105.0, typeof( Log ), 1044041, 75, 1044351 );
				AddSkill( index, SkillName.Tailoring, 50.0, 55.0 );
				AddRes( index, typeof( Cloth ), 1044286, 60, 1044287 );
				SetNeededExpansion( index, Expansion.SE );

				index = AddCraft( typeof( BambooScreen ), 1044294, 1029428, 80.0, 105.0, typeof( Log ), 1044041, 75, 1044351 );
				AddSkill( index, SkillName.Tailoring, 50.0, 55.0 );
				AddRes( index, typeof( Cloth ), 1044286, 60, 1044287 );
				SetNeededExpansion( index, Expansion.SE );
			}

			if( Core.AOS )	//Duplicate Entries to preserve ordering depending on era
			{

				index = AddCraft( typeof( FishingPole ), 1044294, 1023519, 40.0, 45.0, typeof( Log ), 1044041, 5, 1044351 ); //This is in the categor of Other during AoS
				AddSkill( index, SkillName.Tailoring, 40.0, 45.0 );
				AddRes( index, typeof( Cloth ), 1044286, 5, 1044287 );

				index = AddCraft( typeof( MagicalFishingPole ), 1044294, "magical fishing pole", 50.0, 100.0, typeof( Log ), 1044041, 5, 1044351 ); //This is in the categor of Other during AoS
				AddSkill( index, SkillName.Tailoring, 40.0, 45.0 );
				AddRes( index, typeof( Cloth ), 1044286, 5, 1044287 );
				AddRes( index, typeof( WhitePearl ), 1032694, 10, 1044253 );
				AddRes( index, typeof( SlzaAuberonu ), "slza auberonu", 1, 1044253 );
				AddRecipe( index, (int) CarpRecipes.MagicalFishingPole );

				#region Mondain's Legacy
				if (Core.ML)
				{
					index = AddCraft(typeof(RunedSwitch), 1044294, 1072896, 70.0, 120.0, typeof(Log), 1044041, 2, 1044351);
					AddRes(index, typeof(EnchantedSwitch), 1072893, 1, 1053098);
					AddRes(index, typeof(RunedPrism), 1073465, 1, 1053098);
					AddRes(index, typeof(JeweledFiligree), 1072894, 1, 1053098);
					SetNeededExpansion(index, Expansion.ML);
					SetNoUWMap(index, true);
				}

				#endregion

				// Furniture
				AddCraft(typeof(FootStool),					1044291, 1022910,		11.0, 36.0,	typeof(Log), 1044041, 9, 1044351);
				AddCraft(typeof(Stool),					1044291, 1022602,		11.0, 36.0,	typeof(Log), 1044041, 9, 1044351);
				AddCraft(typeof(BambooChair),				1044291, 1044300,		21.0, 46.0,	typeof(Log), 1044041, 13, 1044351);
				AddCraft(typeof(WoodenChair),				1044291, 1044301,		21.0, 46.0,	typeof(Log), 1044041, 13, 1044351);
				AddCraft(typeof(FancyWoodenChairCushion),			1044291, 1044302,		42.1, 67.1,	typeof(Log), 1044041, 15, 1044351);
				AddCraft(typeof(WoodenChairCushion),				1044291, 1044303,		42.1, 67.1,	typeof(Log), 1044041, 13, 1044351);
				AddCraft(typeof(WoodenBench),				1044291, 1022860,		52.6, 77.6,	typeof(Log), 1044041, 17, 1044351);
				AddCraft(typeof(WoodenThrone),				1044291, 1044304,		52.6, 77.6,	typeof(Log), 1044041, 17, 1044351);
				AddCraft(typeof(Throne),					1044291, 1044305,		73.6, 98.6,	typeof(Log), 1044041, 19, 1044351);
				AddCraft(typeof(Nightstand),					1044291, 1044306,		42.1, 67.1,	typeof(Log), 1044041, 17, 1044351);
				AddCraft(typeof(WritingTable),				1044291, 1022890,		63.1, 88.1,	typeof(Log), 1044041, 17, 1044351);
				AddCraft(typeof(YewWoodTable),				1044291, 1044307,		63.1, 88.1,	typeof(Log), 1044041, 23, 1044351);
				AddCraft(typeof(LargeTable),					1044291, 1044308,		84.2, 109.2,	typeof(Log), 1044041, 27, 1044351);

				if(Core.SE)
				{
					index = AddCraft(typeof(ElegantLowTable),		1044291, 1030265,	60.0, 100.0,	typeof(Log), 1044041, 17, 1044351);
					SetNeededExpansion(index, Expansion.SE);

					index = AddCraft(typeof(PlainLowTable),		1044291, 1030266,	60.0, 100.0,	typeof(Log), 1044041, 17, 1044351);
					SetNeededExpansion(index, Expansion.SE);

					if(Core.ML)
					{
						index = AddCraft(typeof(OrnateElvenChair), 1044291, 1072870, 80.0, 120.0, typeof(Log), 1044041, 25, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 2, 1044253);
						AddRecipe(index, (int) CarpRecipes.OrnateElvenChair);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(ElvenReadingChair), 1044291, 1031765, 80.0, 120.0, typeof(Log), 1044041, 25, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 2, 1044253);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(ElvenLoveSeat), 1044291, 1032424, 80.0, 120.0, typeof(Log), 1044041, 25, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 4, 1044253);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(BigElvenChair), 1044291, 1031756, 80.0, 120.0, typeof(Log), 1044041, 25, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 4, 1044253);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(OrnateElvenTable), 1044291, 1031746, 80.0, 120.0, typeof(Log), 1044041, 25, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 5, 1044253);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(FancyElvenTable), 1044291, 1031751, 80.0, 120.0, typeof(Log), 1044041, 25, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 5, 1044253);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(ElvenWashBasin), 1044291, 1031531, 80.0, 120.0, typeof(Log), 1044041, 25, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 5, 1044253);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(ElvenAlchemyTable), 1044291, 1032408, 80.0, 130.0, typeof(Log), 1044041, 45, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 6, 1044253);
						AddRecipe(index, (int) CarpRecipes.ElvenAlchemyTable);
						SetNeededExpansion(index, Expansion.ML);
					}
				}

				// Containers
				AddCraft(typeof(WoodenBox),					1044292, 1023709,		21.0, 46.0,	typeof(Log), 1044041, 10, 1044351);
				AddCraft(typeof(SmallCrate),					1044292, 1044309,		10.0, 35.0,	typeof(Log), 1044041, 8 , 1044351);
				AddCraft(typeof(MediumCrate),				1044292, 1044310,		31.0, 56.0,	typeof(Log), 1044041, 15, 1044351);
				AddCraft(typeof(LargeCrate),					1044292, 1044311,		47.3, 72.3,	typeof(Log), 1044041, 18, 1044351);
				AddCraft(typeof(WoodenChest),				1044292, 1023650,		73.6, 98.6,	typeof(Log), 1044041, 20, 1044351);
				AddCraft(typeof(EmptyBookcase),				1044292, 1022718,		31.5, 56.5,	typeof(Log), 1044041, 25, 1044351);
				AddCraft(typeof(FancyArmoire),				1044292, 1044312,		84.2, 109.2,	typeof(Log), 1044041, 35, 1044351);
				AddCraft(typeof(Armoire),					1044292, 1022643,		84.2, 109.2,	typeof(Log), 1044041, 35, 1044351);

				index = AddCraft(typeof(WireBox),			1044292, "Magical wire & Magic scroll Box",	50.0, 55.0,	typeof(Log), 1044041, 10, 1044351);
				AddSkill(index, SkillName.Tinkering, 50.0, 55.0);
				AddRes(index, typeof(IronIngot), 1044036, 10, 1044037);
				AddRes(index, typeof(MimicShard), "mimic shard", 1, 1044253);

				index = AddCraft(typeof(MetalBox),			1044292, 1022472,	54.2, 79.2,	typeof(Log), 1044041, 10, 1044351);
				AddSkill(index, SkillName.Tinkering, 50.0, 55.0);
				AddRes(index, typeof(IronIngot), 1044036, 10, 1044037);
				AddRes(index, typeof(MimicShard), "mimic shard", 1, 1044253);

				index = AddCraft(typeof(ToolBox),			1044292, "tool box",	54.2, 79.2,	typeof(Log), 1044041, 10, 1044351);
				AddSkill(index, SkillName.Tinkering, 50.0, 55.0);
				AddRes(index, typeof(IronIngot), 1044036, 10, 1044037);
				AddRes(index, typeof(MimicShard), "mimic shard", 1, 1044253);

				index = AddCraft(typeof(BlackSmithBox),			1044292, "blacksmith box",	54.2, 79.2,	typeof(Log), 1044041, 10, 1044351);
				AddSkill(index, SkillName.Tinkering, 50.0, 55.0);
				AddRes(index, typeof(IronIngot), 1044036, 10, 1044037);
				AddRes(index, typeof(MimicShard), "mimic shard", 1, 1044253);
				AddRecipe(index, (int) CarpRecipes.BlackSmithBox);

				index = AddCraft(typeof(TailoringBox),			1044292, "tailoring box",	54.2, 79.2,	typeof(Log), 1044041, 10, 1044351);
				AddSkill(index, SkillName.Tinkering, 50.0, 55.0);
				AddRes(index, typeof(Cloth), 1044286, 10, 1044287);
				AddRes(index, typeof(MimicShard), "mimic shard", 1, 1044253);
				AddRecipe(index, (int) CarpRecipes.TailoringBox);

				index = AddCraft(typeof(WoodBox),				1044292, "wood box",		54.2, 79.2,	typeof(Log), 1044041, 10, 1044351);
				AddSkill(index, SkillName.Tinkering, 50.0, 55.0);
				AddRes(index, typeof(MimicShard), "mimic shard", 1, 1044253);
				AddRecipe(index, (int) CarpRecipes.WoodBox);

				index = AddCraft(typeof(MasonryBox),				1044292, "masonry box",		54.2, 79.2,	typeof(Log), 1044041, 10, 1044351);
				AddSkill(index, SkillName.Tinkering, 50.0, 55.0);
				AddRes(index, typeof(Granite), 1044607, 1, 1044513);
				AddRes(index, typeof(MimicShard), "mimic shard", 1, 1044253);
				AddRecipe(index, (int) CarpRecipes.MasonryBox);

				index = AddCraft(typeof(ScaleBox),				1044292, "scale box",		54.2, 79.2,	typeof(Log), 1044041, 10, 1044351);
				AddSkill(index, SkillName.Tinkering, 50.0, 55.0);
				AddRes(index, typeof(BlackScales), 1053131, 10, 1060884);
				AddRes(index, typeof(MimicShard), "mimic shard", 1, 1044253);
				AddRecipe(index, (int) CarpRecipes.ScaleBox);

				index = AddCraft(typeof(MarbleBox),				1044292, "marble box",		54.2, 79.2,	typeof(Log), 1044041, 10, 1044351);
				AddSkill(index, SkillName.Tinkering, 50.0, 55.0);
				AddRes(index, typeof(Marble), 1021801, 10, "You do not have sufficient marble to make that.");
				AddRes(index, typeof(MimicShard), "mimic shard", 1, 1044253);
				AddRecipe(index, (int) CarpRecipes.MarbleBox);

				index = AddCraft(typeof(SeedBox),				1044292, "seed box",		54.2, 79.2,	typeof(Log), 1044041, 10, 1044351);
				AddSkill(index, SkillName.Tinkering, 50.0, 55.0);
				AddRes(index, typeof(Seed), 1060810, 2, "You do not have sufficient seeds to make that.");
				AddRes(index, typeof(MimicShard), "mimic shard", 1, 1044253);
				AddRecipe(index, (int) CarpRecipes.SeedBox);

				index = AddCraft(typeof(GemBox),				1044292, "gem box",		54.2, 79.2,	typeof(Log), 1044041, 10, 1044351);
				AddSkill(index, SkillName.Tinkering, 50.0, 55.0);
				AddRes(index, typeof(BrilliantAmber), 1026256, 5, 1053098);
				AddRes(index, typeof(MimicShard), "mimic shard", 1, 1044253);
				AddRecipe(index, (int) CarpRecipes.GemBox);

				index = AddCraft(typeof(MailBox),			1044292, "postovni schranka",	50.0, 55.0,	typeof(Log), 1044041, 10, 1044351);
				AddSkill(index, SkillName.Tinkering, 50.0, 55.0);
				AddRes(index, typeof(IronIngot), 1044036, 5, 1044037);
				AddRes(index, typeof(MimicShard), "mimic shard", 1, 1044253);

				if(Core.SE)
				{
					index = AddCraft(typeof(PlainWoodenChest),		1044292, 1030251, 90.0, 115.0,	typeof(Log), 1044041, 30, 1044351);
					SetNeededExpansion(index, Expansion.SE);

					index = AddCraft(typeof(OrnateWoodenChest),		1044292, 1030253, 90.0, 115.0,	typeof(Log), 1044041, 30, 1044351);
					SetNeededExpansion(index, Expansion.SE);

					index = AddCraft(typeof(GildedWoodenChest),		1044292, 1030255, 90.0, 115.0,	typeof(Log), 1044041, 30, 1044351);
					SetNeededExpansion(index, Expansion.SE);

					index = AddCraft(typeof(WoodenFootLocker),		1044292, 1030257, 90.0, 115.0,	typeof(Log), 1044041, 30, 1044351);
					SetNeededExpansion(index, Expansion.SE);

					index = AddCraft(typeof(FinishedWoodenChest), 1044292, 1030259, 90.0, 115.0,	typeof(Log), 1044041, 30, 1044351);
					SetNeededExpansion(index, Expansion.SE);

					index = AddCraft(typeof(TallCabinet),		1044292, 1030261, 90.0, 115.0,	typeof(Log), 1044041, 35, 1044351);
					SetNeededExpansion(index, Expansion.SE);

					index = AddCraft(typeof(ShortCabinet),		1044292, 1030263, 90.0, 115.0,	typeof(Log), 1044041, 35, 1044351);
					SetNeededExpansion(index, Expansion.SE);

					index = AddCraft(typeof(RedArmoire),			1044292, 1030328, 90.0, 115.0,	typeof(Log), 1044041, 40, 1044351);
					SetNeededExpansion(index, Expansion.SE);

					index = AddCraft(typeof(ElegantArmoire),		1044292, 1030330, 90.0, 115.0,	typeof(Log), 1044041, 40, 1044351);
					SetNeededExpansion(index, Expansion.SE);

					index = AddCraft(typeof(MapleArmoire),		1044292, 1030328, 90.0, 115.0,	typeof(Log), 1044041, 40, 1044351);
					SetNeededExpansion(index, Expansion.SE);

					index = AddCraft(typeof(CherryArmoire),		1044292, 1030328, 90.0, 115.0,	typeof(Log), 1044041, 40, 1044351);
					SetNeededExpansion(index, Expansion.SE);

					if(Core.ML)
					{
						index = AddCraft(typeof(ArcaneBookshelfEastDeed), 1044292, 1073371, 80.0, 125.0, typeof(Log), 1044041, 80, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 10, 1044253);
						AddRecipe(index, (int) CarpRecipes.ArcaneBookshelfEast);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(ArcaneBookshelfSouthDeed), 1044292, 1072871, 80.0, 125.0, typeof(Log), 1044041, 80, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 10, 1044253);
						AddRecipe(index, (int) CarpRecipes.ArcaneBookshelfSouth);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(ElvenDresserEastDeed), 1044292, 1073388, 80.0, 125.0, typeof(Log), 1044041, 45, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 10, 1044253);
						AddRecipe(index, (int) CarpRecipes.ElvenDresserEast);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(ElvenDresserSouthDeed), 1044292, 1072864, 80.0, 125.0, typeof(Log), 1044041, 45, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 10, 1044253);
						AddRecipe(index, (int) CarpRecipes.ElvenDresserSouth);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(FancyElvenArmoire), 1044292, 1031527, 80.0, 120.0, typeof(Log), 1044041, 60, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 10, 1044253);
						AddRecipe(index, (int) CarpRecipes.FancyElvenArmoire);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(ElvenBookshelf), 1044292, 1031759, 80.0, 120.0, typeof(Log), 1044041, 60, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 10, 1044253);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(OrnateElvenChest), 1044292, 1031761, 80.0, 120.0, typeof(Log), 1044041, 45, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 10, 1044253);
						AddRecipe(index, (int) CarpRecipes.OrnateElvenChest);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(OrnateElvenBox), 1044292, 1031764, 80.0, 120.0, typeof(Log), 1044041, 40, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 10, 1044253);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(SimpleElvenArmoire), 1044292, 1031526, 80.0, 120.0, typeof(Log), 1044041, 55, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 10, 1044253);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(ElvenStorageTable), 1044292, 1031753, 80.0, 120.0, typeof(Log), 1044041, 55, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 10, 1044253);
						SetNeededExpansion(index, Expansion.ML);
					}
				}

				index = AddCraft(typeof(Keg), 	1044292, 1023711, 57.8, 82.8, typeof(BarrelStaves), 1044288, 3, 1044253);
				AddRes(index, typeof(BarrelHoops), 1044289, 1, 1044253);
				AddRes(index, typeof(BarrelLid), 1044251, 1, 1044253);

				index = AddCraft(typeof(Barrel), 	1044292, 1023703, 65.8, 92.8, typeof(BarrelStaves), 1044288, 6, 1044253);
				AddRes(index, typeof(BarrelHoops), 1044289, 2, 1044253);
				AddRes(index, typeof(BarrelLid), 1044251, 1, 1044253);

				// Staves and Shields
				AddCraft(typeof(ShepherdsCrook), 				1044295, 1023713, 78.9, 103.9, typeof(Log), 1044041, 7, 1044351);
				AddCraft(typeof(QuarterStaff), 				1044295, 1023721, 73.6, 98.6, typeof(Log), 1044041, 6, 1044351);
				AddCraft(typeof(GnarledStaff), 				1044295, 1025112, 78.9, 103.9, typeof(Log), 1044041, 7, 1044351);
				
				if(Core.ML)
				{
					index = AddCraft(typeof(WildStaff), 1044295, 1031557, 75.0, 125.0, typeof(Log), 1044041, 8, 1044351);
					AddRes(index, typeof(PerfectEmerald), 1032692, 2, 1044240);
					AddRes(index, typeof(BrilliantAmber), 1026256, 5, 1053098);
					SetNeededExpansion(index, Expansion.ML);
					SetNoUWMap(index, true);

					index = AddCraft(typeof(PhantomStaff), 1044295, 1072919, 90.0, 130.0, typeof(Log), 1044041, 16, 1044351);
					AddRes(index, typeof(DiseasedBark), 1032683, 1, 1053098);
					AddRes(index, typeof(Putrefication), 1032678, 10, 1053098);
					AddRes(index, typeof(Taint), 1032679, 10, 1053098);
					AddRecipe(index, (int) CarpRecipes.PhantomStaff);
					ForceNonExceptional(index);
					SetNeededExpansion(index, Expansion.ML);
					SetNoUWMap(index, true);

					index = AddCraft(typeof(ArcanistsWildStaff), 1044295, 1073549, 63.8, 113.8, typeof(Log), 1044041, 16, 1044351);
					AddRes(index, typeof(WhitePearl), 1026253, 2, 1053098);
					AddRes(index, typeof(BrilliantAmber), 1026256, 5, 1053098);
					AddRecipe(index, (int) CarpRecipes.ArcanistsWildStaff);
					SetNeededExpansion(index, Expansion.ML);
					SetNoUWMap(index, true);

					index = AddCraft(typeof(AncientWildStaff), 1044295, 1073550, 63.8, 113.8, typeof(Log), 1044041, 16, 1044351);
					AddRes(index, typeof(PerfectEmerald), 1026251, 21, 1053098);
					AddRes(index, typeof(BrilliantAmber), 1026256, 5, 1053098);
					AddRecipe(index, (int) CarpRecipes.AncientWildStaff);
					SetNeededExpansion(index, Expansion.ML);
					SetNoUWMap(index, true);

					index = AddCraft(typeof(ThornedWildStaff), 1044295, 1073551, 63.8, 113.8, typeof(Log), 1044041, 16, 1044351);
					AddRes(index, typeof(FireRuby), 1026254, 2, 1053098);
					AddRes(index, typeof(BrilliantAmber), 1026256, 5, 1053098);
					AddRecipe(index, (int) CarpRecipes.ThornedWildStaff);
					SetNeededExpansion(index, Expansion.ML);
					SetNoUWMap(index, true);

					index = AddCraft(typeof(HardenedWildStaff), 1044295, 1073552, 63.8, 113.8, typeof(Log), 1044041, 16, 1044351);
					AddRes(index, typeof(Turquoise), 1026250, 2, 1053098);
					AddRes(index, typeof(BrilliantAmber), 1026256, 5, 1053098);
					AddRecipe(index, (int) CarpRecipes.HardenedWildStaff);
					SetNeededExpansion(index, Expansion.ML);
					SetNoUWMap(index, true);
				}

				AddCraft(typeof(WoodenShield), 				1044295, 1027034, 52.6, 77.6, typeof(Log), 1044041, 9, 1044351);

				// 				index = AddCraft( typeof( FishingPole ), Core.AOS ? 1044294 : 1044295, 1023519, 68.4, 93.4, typeof( Log ), 1044041, 5, 1044351 ); //This is in the categor of Other during AoS
				// 				AddSkill( index, SkillName.Tailoring, 40.0, 45.0 );
				// 				AddRes( index, typeof( Cloth ), 1044286, 5, 1044287 );

				if(Core.SE)
				{
					index = AddCraft(typeof(Bokuto), 			1044295, 1030227, 70.0, 95.0, typeof(Log), 1044041, 6, 1044351);
					SetNeededExpansion(index, Expansion.SE);
					SetNoUWMap(index, true);

					index = AddCraft(typeof(Fukiya), 1044295, 1030229, 60.0, 85.0, typeof(Log), 1044041, 6, 1044351);
					SetNeededExpansion(index, Expansion.SE);
					SetNoUWMap(index, true);

					index = AddCraft(typeof(Tetsubo), 			1044295, 1030225, 85.0, 110.0, typeof(Log), 1044041, 8, 1044351);
					AddSkill(index, SkillName.Tinkering, 40.0, 45.0);
					AddRes(index, typeof(IronIngot), 1044036, 5, 1044037);
					SetNeededExpansion(index, Expansion.SE);
					SetNoUWMap(index, true);

					//Elven armor
					if(Core.ML)
					{
						index = AddCraft(typeof(WoodlandArms), 1044295, 1032643, 75.0, 125.0, typeof(Log), 1044041, 16, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 5, 1044253);
						SetNoUWMap(index, true);
						SetNeededExpansion(index, Expansion.ML);
						index = AddCraft(typeof(WoodlandGloves), 1044295, 1032641, 75.0, 125.0, typeof(Log), 1044041, 16, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 5, 1044253);
						SetNoUWMap(index, true);
						SetNeededExpansion(index, Expansion.ML);
						index = AddCraft(typeof(WoodlandGorget), 1044295, 1032640, 75.0, 125.0, typeof(Log), 1044041, 16, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 5, 1044253);
						SetNoUWMap(index, true);
						SetNeededExpansion(index, Expansion.ML);
						index = AddCraft(typeof(WoodlandChest), 1044295, 1032638, 75.0, 125.0, typeof(Log), 1044041, 22, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 8, 1044253);
						SetNeededExpansion(index, Expansion.ML);
						SetNoUWMap(index, true);
						index = AddCraft(typeof(WoodlandLegs), 1044295, 1032642, 75.0, 125.0, typeof(Log), 1044041, 22, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 8, 1044253);
						SetNeededExpansion(index, Expansion.ML);
						SetNoUWMap(index, true);
						index = AddCraft(typeof(RavenHelm), 1044295, 1032648, 75.0, 125.0, typeof(Log), 1044041, 10, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 4, 1044253);
						AddRes(index, typeof(Feather), 1044562, 25, 1044563);
						SetNeededExpansion(index, Expansion.ML);
						SetNoUWMap(index, true);
						index = AddCraft(typeof(WingedHelm), 1044295, 1032650, 75.0, 125.0, typeof(Log), 1044041, 10, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 4, 1044253);
						AddRes(index, typeof(Feather), 1044562, 25, 1044563);
						SetNeededExpansion(index, Expansion.ML);
						SetNoUWMap(index, true);
						index = AddCraft(typeof(VultureHelm), 1044295, 1032649, 75.0, 125.0, typeof(Log), 1044041, 10, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 4, 1044253);
						AddRes(index, typeof(Feather), 1044562, 25, 1044563);
						SetNeededExpansion(index, Expansion.ML);
						SetNoUWMap(index, true);
						index = AddCraft(typeof(IronwoodCrown), 1044295, 1072924, 85.0, 120.0, typeof(Log), 1044041, 10, 1044351);
						AddRes(index, typeof(DiseasedBark), 1032683, 1, 1053098);
						AddRes(index, typeof(Corruption), 1032676, 10, 1053098);
						AddRes(index, typeof(Putrefication), 1032678, 10, 1053098);
						AddRecipe(index, (int) CarpRecipes.IronwoodCrown);
						ForceNonExceptional(index);
						SetNeededExpansion(index, Expansion.ML);
						SetNoUWMap(index, true);

						index = AddCraft(typeof(BrambleCoat), 1044295, 1072925, 85.0, 120.0, typeof(Log), 1044041, 10, 1044351);
						AddRes(index, typeof(DiseasedBark), 1032683, 1, 1053098);
						AddRes(index, typeof(Taint), 1032679, 10, 1053098);
						AddRes(index, typeof(Scourge), 1032677, 10, 1053098);
						AddRecipe(index, (int) CarpRecipes.BrambleCoat);
						ForceNonExceptional(index);
						SetNeededExpansion(index, Expansion.ML);
						SetNoUWMap(index, true);
					}
				}

				// Instruments
				index = AddCraft(typeof(LapHarp), 				1044293, 1023762, 63.1, 88.1, typeof(Log), 1044041, 20, 1044351);
				AddSkill(index, SkillName.Musicianship, 45.0, 50.0);
				AddRes(index, typeof(Cloth), 1044286, 10, 1044287);

				index = AddCraft(typeof(Harp), 				1044293, 1023761, 78.9, 103.9, typeof(Log), 1044041, 35, 1044351);
				AddSkill(index, SkillName.Musicianship, 45.0, 50.0);
				AddRes(index, typeof(Cloth), 1044286, 15, 1044287);

				index = AddCraft(typeof(Drums), 				1044293, 1023740, 57.8, 82.8, typeof(Log), 1044041, 20, 1044351);
				AddSkill(index, SkillName.Musicianship, 45.0, 50.0);
				AddRes(index, typeof(Cloth), 1044286, 10, 1044287);

				index = AddCraft(typeof(Lute), 				1044293, 1023763, 68.4, 93.4, typeof(Log), 1044041, 25, 1044351);
				AddSkill(index, SkillName.Musicianship, 45.0, 50.0);
				AddRes(index, typeof(Cloth), 1044286, 10, 1044287);

				index = AddCraft(typeof(Tambourine), 			1044293, 1023741, 57.8, 82.8, typeof(Log), 1044041, 15, 1044351);
				AddSkill(index, SkillName.Musicianship, 45.0, 50.0);
				AddRes(index, typeof(Cloth), 1044286, 10, 1044287);

				index = AddCraft(typeof(TambourineTassel), 			1044293, 1044320, 57.8, 82.8, typeof(Log), 1044041, 15, 1044351);
				AddSkill(index, SkillName.Musicianship, 45.0, 50.0);
				AddRes(index, typeof(Cloth), 1044286, 15, 1044287);

				if(Core.SE)
				{
					index = AddCraft(typeof(BambooFlute), 		1044293, 1030247, 80.0, 105.0, typeof(Log), 1044041, 15, 1044351);
					AddSkill(index, SkillName.Musicianship, 45.0, 50.0);
					SetNeededExpansion(index, Expansion.SE);
				}

				index = AddCraft(typeof(Fiddle), 			1044293, "fiddle", 80.0, 110.0, typeof(Log), 1044041, 15, 1044351);
				AddSkill(index, SkillName.Musicianship, 75.0, 100.0);

				// Misc
				index = AddCraft(typeof(SmallBedSouthDeed), 			1044290, 1044321, 94.7, 113.1, typeof(Log), 1044041, 100, 1044351);
				AddSkill(index, SkillName.Tailoring, 75.0, 80.0);
				AddRes(index, typeof(Cloth), 1044286, 100, 1044287);
				index = AddCraft(typeof(SmallBedEastDeed), 			1044290, 1044322, 94.7, 113.1, typeof(Log), 1044041, 100, 1044351);
				AddSkill(index, SkillName.Tailoring, 75.0, 80.0);
				AddRes(index, typeof(Cloth), 1044286, 100, 1044287);
				index = AddCraft(typeof(LargeBedSouthDeed), 			1044290, 1044323, 94.7, 113.1, typeof(Log), 1044041, 150, 1044351);
				AddSkill(index, SkillName.Tailoring, 75.0, 80.0);
				AddRes(index, typeof(Cloth), 1044286, 150, 1044287);
				index = AddCraft(typeof(LargeBedEastDeed), 			1044290, 1044324, 94.7, 113.1, typeof(Log), 1044041, 150, 1044351);
				AddSkill(index, SkillName.Tailoring, 75.0, 80.0);
				AddRes(index, typeof(Cloth), 1044286, 150, 1044287);
				AddCraft(typeof(DartBoardSouthDeed), 			1044290, 1044325, 15.7, 40.7, typeof(Log), 1044041, 5, 1044351);
				AddCraft(typeof(DartBoardEastDeed), 				1044290, 1044326, 15.7, 40.7, typeof(Log), 1044041, 5, 1044351);
				AddCraft(typeof(BallotBoxDeed), 				1044290, 1044327, 47.3, 72.3, typeof(Log), 1044041, 5, 1044351);
				index = AddCraft(typeof(PentagramDeed), 			1044290, 1044328, 100.0, 125.0, typeof(Log), 1044041, 100, 1044351);
				AddSkill(index, SkillName.Magery, 75.0, 80.0);
				AddRes(index, typeof(IronIngot), 1044036, 40, 1044037);
				index = AddCraft(typeof(AbbatoirDeed), 			1044290, 1044329, 100.0, 125.0, typeof(Log), 1044041, 100, 1044351);
				AddSkill(index, SkillName.Magery, 50.0, 55.0);
				AddRes(index, typeof(IronIngot), 1044036, 40, 1044037);

				if (Core.AOS)
				{
					if(Core.ML)
					{
						index = AddCraft(typeof(ArcaneCircleDeed), 1044290, 1032419, 90.0, 130.0, typeof(Log), 1044041, 100, 1044351);
						AddSkill(index, SkillName.Spellweaving, 50.0, 55.0);
						AddRes(index, typeof(BarkFragment), 1032687, 5, 1044253);
						AddRes(index, typeof(FireRuby), 1032695, 2, 1044240);
						AddRes(index, typeof(PerfectEmerald), 1032692, 2, 1044240);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(SmallElvenBedEastDeed), 1044290, 1072861, 70.0, 110.0, typeof(Log), 1044041, 100, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 5, 1044253);
						AddRes(index, typeof(Cloth), 1044286, 100, 1044287);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(SmallElvenBedSouthDeed), 1044290, 1072860, 70.0, 110.0, typeof(Log), 1044041, 100, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 5, 1044253);
						AddRes(index, typeof(Cloth), 1044286, 100, 1044287);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(TallElvenBedEastDeed), 1044290, 1072859, 90.0, 130.0, typeof(Log), 1044041, 150, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 8, 1044253);
						AddRes(index, typeof(Cloth), 1044286, 150, 1044287);
						AddRecipe(index, (int) CarpRecipes.TallElvenBedEast);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(TallElvenBedSouthDeed), 1044290, 1072858, 90.0, 130.0, typeof(Log), 1044041, 150, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 8, 1044253);
						AddRes(index, typeof(Cloth), 1044286, 150, 1044287);
						AddRecipe(index, (int) CarpRecipes.TallElvenBedSouth);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(WarriorStatueEastDeed), 1044290, 1072888, 90.0, 130.0, typeof(Log), 1044041, 250, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 5, 1044253);
						AddRecipe(index, (int) CarpRecipes.WarriorStatueEast);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(WarriorStatueSouthDeed), 1044290, 1072887, 90.0, 130.0, typeof(Log), 1044041, 250, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 5, 1044253);
						AddRecipe(index, (int) CarpRecipes.WarriorStatueSouth);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(SquirrelStatueEastDeed), 1044290, 1073398, 90.0, 130.0, typeof(Log), 1044041, 250, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 5, 1044253);
						AddRecipe(index, (int) CarpRecipes.SquirrelStatueEast);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(SquirrelStatueSouthDeed), 1044290, 1072884, 90.0, 130.0, typeof(Log), 1044041, 250, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 5, 1044253);
						AddRecipe(index, (int) CarpRecipes.SquirrelStatueSouth);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(ArcanistStatueEastDeed), 1044290, 1072886, 90.0, 130.0, typeof(Log), 1044041, 250, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 5, 1044253);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(ArcanistStatueSouthDeed), 1044290, 1072885, 90.0, 130.0, typeof(Log), 1044041, 250, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 5, 1044253);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(ElvenBookStand), 1044290, 1031742, 70.0, 110.0, typeof(Log), 1044041, 25, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 1, 1044253);
						SetNeededExpansion(index, Expansion.ML);

						index = AddCraft(typeof(ParrotPerchAddonDeed), 1044290, 1032214, 70.0, 110.0, typeof(Log), 1044041, 5, 1044351);
						AddRes(index, typeof(BarkFragment), 1032687, 1, 1044253);
						SetNeededExpansion(index, Expansion.ML);
					}

					AddCraft(typeof(PlayerBBEast), 			1044290, 1062420, 85.0, 110.0, typeof(Log), 1044041, 50, 1044351);
					AddCraft(typeof(PlayerBBSouth), 			1044290, 1062421, 85.0, 110.0, typeof(Log), 1044041, 50, 1044351);
				}

				// Blacksmithy
				index = AddCraft(typeof(SmallForgeDeed), 			1044296, 1044330, 73.6, 98.6, typeof(Log), 1044041, 5, 1044351);
				AddSkill(index, SkillName.Blacksmith, 75.0, 80.0);
				AddRes(index, typeof(IronIngot), 1044036, 75, 1044037);
				// start - dwarwen forges
				index = AddCraft(typeof(DwarvenForgeEastAddonDeed),	1044296, "dwarven forge (east)", 78.9, 103.9, typeof(Log), 1044041, 5, 1044351);
				AddSkill(index, SkillName.Blacksmith, 80.0, 90.0);
				AddRes(index, typeof(IronIngot), 1044036, 90, 1044037);

				index = AddCraft(typeof(DwarvenForgeEast2AddonDeed),	1044296, "dwarven forge 2 (east)", 78.9, 103.9, typeof(Log), 1044041, 5, 1044351);
				AddSkill(index, SkillName.Blacksmith, 80.0, 90.0);
				AddRes(index, typeof(IronIngot), 1044036, 90, 1044037);

				index = AddCraft(typeof(DwarvenForgeSouthAddonDeed),	1044296, "dwarven forge (south)", 78.9, 103.9, typeof(Log), 1044041, 5, 1044351);
				AddSkill(index, SkillName.Blacksmith, 80.0, 90.0);
				AddRes(index, typeof(IronIngot), 1044036, 90, 1044037);

				index = AddCraft(typeof(DwarvenForgeSouth2AddonDeed),	1044296, "dwarven forge 2 (south)", 78.9, 103.9, typeof(Log), 1044041, 5, 1044351);
				AddSkill(index, SkillName.Blacksmith, 80.0, 90.0);
				AddRes(index, typeof(IronIngot), 1044036, 90, 1044037);

				// end - dwarwen forges
				index = AddCraft(typeof(LargeForgeEastDeed), 		1044296, 1044331, 78.9, 103.9, typeof(Log), 1044041, 5, 1044351);
				AddSkill(index, SkillName.Blacksmith, 80.0, 85.0);
				AddRes(index, typeof(IronIngot), 1044036, 100, 1044037);
				index = AddCraft(typeof(LargeForgeSouthDeed), 		1044296, 1044332, 78.9, 103.9, typeof(Log), 1044041, 5, 1044351);
				AddSkill(index, SkillName.Blacksmith, 80.0, 85.0);
				AddRes(index, typeof(IronIngot), 1044036, 100, 1044037);
				index = AddCraft(typeof(AnvilEastDeed), 			1044296, 1044333, 73.6, 98.6, typeof(Log), 1044041, 5, 1044351);
				AddSkill(index, SkillName.Blacksmith, 75.0, 80.0);
				AddRes(index, typeof(IronIngot), 1044036, 150, 1044037);
				index = AddCraft(typeof(AnvilSouthDeed), 			1044296, 1044334, 73.6, 98.6, typeof(Log), 1044041, 5, 1044351);
				AddSkill(index, SkillName.Blacksmith, 75.0, 80.0);
				AddRes(index, typeof(IronIngot), 1044036, 150, 1044037);
				if(Core.ML)
				{
					index = AddCraft(typeof(ElvenForgeDeed), 1044296, 1031736, 80.0, 130.0, typeof(Log), 1044041, 200, 1044351);
					AddRes(index, typeof(BarkFragment), 1032687, 2, 1044253);
					SetNeededExpansion(index, Expansion.ML);
				}

				// Training
				index = AddCraft(typeof(TrainingDummyEastDeed), 		1044297, 1044335, 68.4, 93.4, typeof(Log), 1044041, 55, 1044351);
				AddSkill(index, SkillName.Tailoring, 50.0, 55.0);
				AddRes(index, typeof(Cloth), 1044286, 60, 1044287);
				index = AddCraft(typeof(TrainingDummySouthDeed), 		1044297, 1044336, 68.4, 93.4, typeof(Log), 1044041, 55, 1044351);
				AddSkill(index, SkillName.Tailoring, 50.0, 55.0);
				AddRes(index, typeof(Cloth), 1044286, 60, 1044287);
				index = AddCraft(typeof(PickpocketDipEastDeed), 		1044297, 1044337, 73.6, 98.6, typeof(Log), 1044041, 65, 1044351);
				AddSkill(index, SkillName.Tailoring, 50.0, 55.0);
				AddRes(index, typeof(Cloth), 1044286, 60, 1044287);
				index = AddCraft(typeof(PickpocketDipSouthDeed), 		1044297, 1044338, 73.6, 98.6, typeof(Log), 1044041, 65, 1044351);
				AddSkill(index, SkillName.Tailoring, 50.0, 55.0);
				AddRes(index, typeof(Cloth), 1044286, 60, 1044287);

				// Tailoring
				index = AddCraft(typeof(Dressform), 				1044298, 1044339, 63.1, 88.1, typeof(Log), 1044041, 25, 1044351);
				AddSkill(index, SkillName.Tailoring, 65.0, 70.0);
				AddRes(index, typeof(Cloth), 1044286, 10, 1044287);
				index = AddCraft(typeof(SpinningwheelEastDeed), 		1044298, 1044341, 73.6, 98.6, typeof(Log), 1044041, 75, 1044351);
				AddSkill(index, SkillName.Tailoring, 65.0, 70.0);
				AddRes(index, typeof(Cloth), 1044286, 25, 1044287);
				index = AddCraft(typeof(SpinningwheelSouthDeed), 		1044298, 1044342, 73.6, 98.6, typeof(Log), 1044041, 75, 1044351);
				AddSkill(index, SkillName.Tailoring, 65.0, 70.0);
				AddRes(index, typeof(Cloth), 1044286, 25, 1044287);
				index = AddCraft(typeof(LoomEastDeed), 			1044298, 1044343, 84.2, 109.2, typeof(Log), 1044041, 85, 1044351);
				AddSkill(index, SkillName.Tailoring, 65.0, 70.0);
				AddRes(index, typeof(Cloth), 1044286, 25, 1044287);
				index = AddCraft(typeof(LoomSouthDeed), 			1044298, 1044344, 84.2, 109.2, typeof(Log), 1044041, 85, 1044351);
				AddSkill(index, SkillName.Tailoring, 65.0, 70.0);
				AddRes(index, typeof(Cloth), 1044286, 25, 1044287);
				if(Core.ML)
				{
					index = AddCraft(typeof(ElvenSpinningwheelEastDeed), 1044298, 1073393, 80.0, 130.0, typeof(Log), 1044041, 75, 1044351);
					AddRes(index, typeof(BarkFragment), 1032687, 2, 1044253);
					AddSkill(index, SkillName.Tailoring, 65.0, 70.0);
					AddRes(index, typeof(Cloth), 1044286, 25, 1044287);
					SetNeededExpansion(index, Expansion.ML);

					index = AddCraft(typeof(ElvenSpinningwheelSouthDeed), 1044298, 1072878, 80.0, 130.0, typeof(Log), 1044041, 75, 1044351);
					AddRes(index, typeof(BarkFragment), 1032687, 2, 1044253);
					AddSkill(index, SkillName.Tailoring, 65.0, 70.0);
					AddRes(index, typeof(Cloth), 1044286, 25, 1044287);
					SetNeededExpansion(index, Expansion.ML);
				}

				// Cooking
				index = AddCraft(typeof(StoneOvenEastDeed), 			1044299, 1044345, 68.4, 93.4, typeof(Log), 1044041, 85, 1044351);
				AddSkill(index, SkillName.Tinkering, 50.0, 55.0);
				AddRes(index, typeof(IronIngot), 1044036, 125, 1044037);
				index = AddCraft(typeof(StoneOvenSouthDeed), 		1044299, 1044346, 68.4, 93.4, typeof(Log), 1044041, 85, 1044351);
				AddSkill(index, SkillName.Tinkering, 50.0, 55.0);
				AddRes(index, typeof(IronIngot), 1044036, 125, 1044037);
				index = AddCraft(typeof(FlourMillEastDeed), 			1044299, 1044347, 94.7, 119.7, typeof(Log), 1044041, 100, 1044351);
				AddSkill(index, SkillName.Tinkering, 50.0, 55.0);
				AddRes(index, typeof(IronIngot), 1044036, 50, 1044037);
				index = AddCraft(typeof(FlourMillSouthDeed), 		1044299, 1044348, 94.7, 119.7, typeof(Log), 1044041, 100, 1044351);
				AddSkill(index, SkillName.Tinkering, 50.0, 55.0);
				AddRes(index, typeof(IronIngot), 1044036, 50, 1044037);
				AddCraft(typeof(WaterTroughEastDeed), 			1044299, 1044349, 94.7, 119.7, typeof(Log), 1044041, 150, 1044351);
				AddCraft(typeof(WaterTroughSouthDeed), 			1044299, 1044350, 94.7, 119.7, typeof(Log), 1044041, 150, 1044351);
				if(Core.ML)
				{
					index = AddCraft(typeof(ElvenStove), 1044299, 1031739, 80.0, 130.0, typeof(Log), 1044041, 40, 1044351);
					AddRes(index, typeof(BarkFragment), 1032687, 2, 1044253);
					AddSkill(index, SkillName.Tinkering, 50.0, 55.0);
					AddRes(index, typeof(IronIngot), 1044036, 125, 1044037);
					SetNeededExpansion(index, Expansion.ML);
				}

				// Boat Crafting
				index = AddCraft(typeof(SmallBoatDeed), "Boat Crafting", 1041205, 60.0, 100.0, typeof(Log), 1044041, 500, 1044351);
				AddRes(index, typeof(Rope), 1020934, 2, 1044253);
				AddSkill(index, SkillName.Tinkering, 75.0, 100.0);
				AddRes(index, typeof(IronIngot), 1044036, 50, 1044037);
				AddSkill(index, SkillName.Tailoring, 75.0, 100.0);
				AddRes(index, typeof(Cloth), 1044286, 75, 1044287);
				SetNoUWMap(index, true);

				index = AddCraft(typeof(MediumBoatDeed), "Boat Crafting", 1041207, 75.0, 110.0, typeof(Log), 1044041, 750, 1044351);
				AddRes(index, typeof(Rope), 1020934, 4, 1044253);
				AddSkill(index, SkillName.Tinkering, 80.0, 110.0);
				AddRes(index, typeof(IronIngot), 1044036, 75, 1044037);
				AddSkill(index, SkillName.Tailoring, 80.0, 110.0);
				AddRes(index, typeof(Cloth), 1044286, 100, 1044287);
				SetNoUWMap(index, true);

				index = AddCraft(typeof(LargeBoatDeed), "Boat Crafting", 1041209, 90.0, 120.0, typeof(Log), 1044041, 1000, 1044351);
				AddRes(index, typeof(Rope), 1020934, 6, 1044253);
				AddSkill(index, SkillName.Tinkering, 90.0, 120.0);
				AddRes(index, typeof(IronIngot), 1044036, 100, 1044037);
				AddSkill(index, SkillName.Tailoring, 80.0, 110.0);
				AddRes(index, typeof(Cloth), 1044286, 150, 1044287);
				SetNoUWMap(index, true);

				index = AddCraft(typeof(SmallDragonBoatDeed), "Boat Crafting", 1041206, 60.0, 100.0, typeof(Log), 1044041, 500, 1044351);
				AddRes(index, typeof(Rope), 1020934, 2, 1044253);
				AddSkill(index, SkillName.Tinkering, 75.0, 100.0);
				AddRes(index, typeof(IronIngot), 1044036, 50, 1044037);
				AddSkill(index, SkillName.Tailoring, 75.0, 100.0);
				AddRes(index, typeof(Cloth), 1044286, 75, 1044287);
				SetNoUWMap(index, true);

				index = AddCraft(typeof(MediumDragonBoatDeed), "Boat Crafting", 1041208, 75.0, 110.0, typeof(Log), 1044041, 750, 1044351);
				AddRes(index, typeof(Rope), 1020934, 4, 1044253);
				AddSkill(index, SkillName.Tinkering, 80.0, 110.0);
				AddRes(index, typeof(IronIngot), 1044036, 75, 1044037);
				AddSkill(index, SkillName.Tailoring, 80.0, 110.0);
				AddRes(index, typeof(Cloth), 1044286, 100, 1044287);
				SetNoUWMap(index, true);

				index = AddCraft(typeof(LargeDragonBoatDeed), "Boat Crafting", 1041210, 90.0, 120.0, typeof(Log), 1044041, 1000, 1044351);
				AddRes(index, typeof(Rope), 1020934, 6, 1044253);
				AddSkill(index, SkillName.Tinkering, 90.0, 120.0);
				AddRes(index, typeof(IronIngot), 1044036, 100, 1044037);
				AddSkill(index, SkillName.Tailoring, 80.0, 110.0);
				AddRes(index, typeof(Cloth), 1044286, 150, 1044287);
				SetNoUWMap(index, true);

				// Set the overidable material
				SetSubRes(typeof(Log), "Change Wood");

				// Add every material you want the player to be able to chose from
				// This will overide the overidable material
				AddSubRes(typeof(Log),			"Normal", 0.0, "You can not work with the kind of wood");
				AddSubRes(typeof(PineLog),	 		"Pine", 35.0, "You can not work with the kind of wood");
				AddSubRes(typeof(CedarLog),	 	 	"Cedar", 45.0, "You can not work with the kind of wood");
				AddSubRes(typeof(CherryLog),			"Cherry", 75.0, "You can not work with the kind of wood");
				AddSubRes(typeof(MahoganyLog),		"Mahogany", 85.0, "You can not work with the kind of wood");
				AddSubRes(typeof(OakLog),			"Oak", 90.0, "You can not work with the kind of wood");
				AddSubRes(typeof(AshLog),			"Ash", 95.0, "You can not work with the kind of wood");
				AddSubRes(typeof(YewLog),			"Yew", 100.0, "You can not work with the kind of wood");
				AddSubRes(typeof(HeartwoodLog),		"Heartwood", 105.0, "You can not work with the kind of wood");
				AddSubRes(typeof(BloodwoodLog),		"Bloodwood", 110.0, "You can not work with the kind of wood");
				AddSubRes(typeof(FrostwoodLog),		"Frostwood", 115.0, "You can not work with the kind of wood");

				MarkOption = true;
				Repair = Core.AOS;
				CanEnhance = Core.AOS;
			}
		}
	}
}