using System;
using Server.Mobiles;

namespace Server.Items
{
	public class Brick : Item
	{
		private int m_Charges;
		public DateTime m_NextSpecial;
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int Charges
		{
			get{ return m_Charges; }
			set
			{
				if ( value > 500000 )
					m_Charges = 500000;
				else if ( value < 0 )
					m_Charges = 0;
				else
					m_Charges = value;

				InvalidateProperties();
			}
		}
		
		[Constructable]
		public Brick() : base( 222 )
		{
			Weight = 3.0;
			Hue = 1640;
			Name = "strange brick";
			Charges = 10;
			LootType = LootType.Blessed;
		}
		
		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );

			list.Add( 1060741, m_Charges.ToString() ); // charges: ~1_val~
		}
		
		public override void OnDoubleClick( Mobile from )
		{
// 			from.SendMessage( "Inside Khaldun: {0}", KhaldunRevenant.IsInsideKhaldun( from ) );
         if ( !this.IsChildOf( from.Backpack ) )
			{
				from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
			}
			else if ( m_Charges < 10 )
			{
				MessageHelper.SendLocalizedMessageTo( this, from, 1042544, 0x59 ); // This item is out of charges.
			}
			else if ( DateTime.Now > m_NextSpecial )
			{
				KhalAnkur.Waller( 3, 3, from );
				this.Charges -= 10;
				m_NextSpecial = DateTime.Now + TimeSpan.FromSeconds( 120.0 );
			}
			else
				from.SendLocalizedMessage( 1074882, "few" ); // You must wait ~1_val~ seconds for this to recharge.
		}

		public Brick( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.WriteEncodedInt( (int) 0 ); // version

			writer.WriteEncodedInt( (int) m_Charges );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadEncodedInt();

			switch ( version )
			{
				case 1:
					{
						goto case 0;
					}
				case 0:
					{
						m_Charges = Math.Min( reader.ReadEncodedInt(), 500000 );
						break;
					}
			}
		}
	}
}
