using System;
using Server.Mobiles;

namespace Server.Items
{
	public class HealingCloudJug : Item
	{
		private int m_Charges;
		private int m_Clouds;
		public DateTime m_NextSpecial;
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int Charges
		{
			get{ return m_Charges; }
			set
			{
				if ( value > 500000 )
					m_Charges = 500000;
				else if ( value < 0 )
					m_Charges = 0;
				else
					m_Charges = value;

				InvalidateProperties();
			}
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int Clouds
		{
			get{ return m_Clouds; }
			set
			{
				if ( value < 0 )
					m_Clouds = 0;
				else
					m_Clouds = value;

				InvalidateProperties();
			}
		}
		
		[Constructable]
		public HealingCloudJug() : base( 2504 )
		{
			Weight = 1.0;
			Hue = 2648;
			Name = "jug of healing clouds";
			LootType = LootType.Blessed;
		}
		
		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );
			
 			list.Add( 1060658, "Healing clouds\t{0}/5", m_Clouds );
			list.Add( 1060741, m_Charges.ToString() ); // charges: ~1_val~
		}
		
		public override void OnDoubleClick( Mobile from )
		{
         if ( !this.IsChildOf( from.Backpack ) )
			{
				from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
			}
			else if ( m_Clouds < 1 || m_Charges < 1 )
			{
				MessageHelper.SendLocalizedMessageTo( this, from, 1042544, 0x59 ); // This item is out of charges.
			}
			else if ( DateTime.Now > m_NextSpecial )
			{
            DropCloud( from );
    			
				this.Clouds--;
				this.Charges--;
				m_NextSpecial = DateTime.Now + TimeSpan.FromSeconds( 90.0 );
			}
			else
				from.SendLocalizedMessage( 1074882, "few" ); // You must wait ~1_val~ seconds for this to recharge.
		}
		
		public static void DropCloud( Mobile from )
		{
  			bool validLocation = false;
  			Point3D loc = from.Location;
  			
  			for ( int j = 0; !validLocation && j < 10; ++j )
  			{
  				int x = from.X + Utility.Random( 5 );
  				int y = from.Y + Utility.Random( 5 );
  				int z = from.Map.GetAverageZ( x, y );
  				
  				if ( validLocation = ( from.Map.CanFit( x, y, from.Z, 6, false, false ) && from.InLOS( new Point3D( x, y, from.Z ) ) ) )
  					loc = new Point3D( x, y, from.Z );
  				else if ( validLocation = ( from.Map.CanFit( x, y, z, 6, false, false ) && from.InLOS( new Point3D( x, y, z ) ) ) )
  					loc = new Point3D( x, y, z );
  			}
  			
  			if ( !validLocation )
  				return;
  			
  			new HealingCloud().MoveToWorld( loc, from.Map );
      }

		public HealingCloudJug( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.WriteEncodedInt( (int) 0 ); // version

			writer.WriteEncodedInt( (int) m_Charges );
			writer.WriteEncodedInt( (int) m_Clouds );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadEncodedInt();

			switch ( version )
			{
				case 1:
					{
						goto case 0;
					}
				case 0:
					{
						m_Charges = Math.Min( reader.ReadEncodedInt(), 500000 );
						m_Clouds = reader.ReadEncodedInt();
						break;
					}
			}
		}
	}
}
