using System;
using Server;
using Server.ContextMenus;
using Server.Targeting;
using System.Collections;
using System.Collections.Generic;

namespace Server.Items
{
	public class HurdyGurdy : LapHarp
	{
		public override int InitMaxUses{ get{ return 250; } }

      [Constructable]
		public HurdyGurdy() : base()
		{
			Name = "hurdy-gurdy";
			ItemID = 11002;
			Weight = 3.0;
			SuccessSound = 913;
			FailureSound = 1456;
			UsesRemaining = 250;
			ReplenishesCharges = true;
			Quality = InstrumentQuality.Exceptional;
			Slayer = SlayerName.Silver;
			Slayer2 = SlayerName.Repond;
			LootType = LootType.Blessed;
		}
		
		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );

			list.Add( "Better sound: +20%\nIgnores slayer opposition groups\nSlayer randomizing" );
		}
		
		public override void PlayInstrumentWell( Mobile from )
		{
			from.PlaySound( Utility.RandomList( 743, 744, 745, 67, 69, 82, 1027, 1035, 1048, 1284, 1419, 1457, 913, 914, 915 ) );
		}
		
		public override TimeSpan ChargeReplenishRate { get { return TimeSpan.FromHours( 6.0 ); } }
		
		public static void RandomizeSlayers( BaseInstrument hurdygurdy )
		{
         if ( Utility.RandomDouble() < 0.85 )
			{
				SlayerName randslay = (SlayerName) SlayerGroup.Groups[Utility.Random( SlayerGroup.Groups.Length )].Super.Name;
				
				if ( Utility.RandomBool() && hurdygurdy.Slayer2 != randslay )
				  hurdygurdy.Slayer = randslay;
				else if ( hurdygurdy.Slayer != randslay )
			      hurdygurdy.Slayer2 = randslay;
			}
		}
		
		public override void GetContextMenuEntries( Mobile from, List<ContextMenuEntry> list )
		{
			base.GetContextMenuEntries( from, list );

			if ( from.Alive && UsesRemaining < InitMaxUses && IsChildOf( from.Backpack ) )
             list.Add( new RechargeEntry( from, this ) );
      }

      public class RechargeEntry : ContextMenuEntry
      {
          private Mobile m_From;
          private HurdyGurdy m_harp;

          public RechargeEntry(Mobile from, HurdyGurdy harp) : base(6132, 1)//Use
          {
              m_From = from;
              m_harp = harp;
          }

          public override void OnClick()
          {
              if ( m_harp == null || m_harp.Deleted )
               return;
              
              if ( !m_harp.IsChildOf( m_From.Backpack ) )
                  m_From.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
              else
              {
                  m_From.Target = new InternalTarget( m_harp );
                  m_From.SendMessage( "Zamer stribrne mince" );
              } 
          }
      }
      
		private class InternalTarget : Target
		{
			private HurdyGurdy m_Harp;

			public InternalTarget( HurdyGurdy harp ) : base( 1, false, TargetFlags.None )
			{
				m_Harp = harp;
			}

			protected override void OnTarget( Mobile from, object target )
			{
				if ( !( target is Tokens ) )
				{
					from.SendMessage( "Musis zamerit stribrne mince" );
					return;
				}
				
				Item item = (Item) target;
					
				int need = ( item.Amount > m_Harp.InitMaxUses - m_Harp.UsesRemaining ) ? m_Harp.InitMaxUses - m_Harp.UsesRemaining : item.Amount;
				
            m_Harp.UsesRemaining += need;
            item.Consume( need );
            from.PlaySound( 501 );
            m_Harp.PlayInstrumentWell( from );
            from.FixedParticles( 14120, 1, 10, 0x1F78, m_Harp.Hue, 5, EffectLayer.Waist );
			}
		}

		public HurdyGurdy( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			if ( Weight != 3.0 )
				Weight = 3.0;
		}
	}
}